/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ASlider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

class AScene45 {
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    final int ORIGIN_SC = 0;
    final int ORIGIN_C = 1;
    final int ORIGIN_S = 2;
    protected int m_origin_mode = 0;
    protected Color m_colorSC = Color.white;
    protected Color m_colorC = Color.red;
    protected Color m_colorS = Color.blue;
    protected Color m_color_bk = new Color(164, 164, 164);
    protected Color m_color_pink = new Color(255, 200, 200);
    protected Color m_color_blueL = new Color(200, 200, 255);
    protected int m_circleR = 20;
    protected int m_squareR = 14;
    protected double m_transformX = 0.0;
    protected double m_transformY = 0.0;
    protected double m_time = 0.0;
    protected int m_counter = 0;
    protected int m_max_counter = 0;
    protected int m_second_step = 4;
    protected double m_init_speed = 0.0;
    protected double m_accel = 0.0;
    protected double m_vcircleX = 0.0;
    protected double m_vcircleY = 0.0;
    protected int m_x0;
    protected int m_y0;
    protected int m_xSC;
    protected int m_ySC;
    protected int m_xC;
    protected int m_yC;
    protected int m_xS;
    protected int m_yS;
    protected int m_xLeft;
    protected int m_xRight;
    protected int m_yTop;
    protected int m_yBottom;
    protected Vector m_circlePoints = new Vector();
    protected Vector m_squarePoints = new Vector();
    protected Vector m_originPoints = new Vector();
    boolean m_result = true;

    public AScene45(int mode, ASlider slider1, ASlider slider2, int xLeft, int yTop, int xRight, int yBottom, int x0, int y0) {
        this.m_origin_mode = mode;
        this.m_slider1 = slider1;
        this.m_slider2 = slider2;
        this.m_xLeft = xLeft;
        this.m_xRight = xRight;
        this.m_yTop = yTop;
        this.m_yBottom = yBottom;
        this.m_xS = this.m_xSC = x0;
        this.m_xC = this.m_xSC;
        this.m_x0 = this.m_xSC;
        this.m_yS = this.m_ySC = y0;
        this.m_yC = this.m_ySC;
        this.m_y0 = this.m_ySC;
    }

    public void paint(Graphics g) {
        g.setColor(this.m_color_bk);
        g.fillRect(this.m_xLeft, this.m_yTop, this.m_xRight - this.m_xLeft, this.m_yBottom - this.m_yTop);
        g.setColor(Color.black);
        g.drawRect(this.m_xLeft, this.m_yTop, this.m_xRight - this.m_xLeft, this.m_yBottom - this.m_yTop);
        for (int count = 0; count < this.m_counter / this.m_second_step; ++count) {
            Point point = (Point)this.m_circlePoints.elementAt(count);
            g.setColor(this.m_color_pink);
            g.drawOval(point.x - this.m_circleR, point.y - this.m_circleR, 2 * this.m_circleR, 2 * this.m_circleR);
            point = (Point)this.m_squarePoints.elementAt(count);
            g.setColor(this.m_color_blueL);
            g.drawRect(point.x - this.m_squareR, point.y - this.m_squareR, 2 * this.m_squareR, 2 * this.m_squareR);
            point = (Point)this.m_originPoints.elementAt(count);
            g.setColor(Color.green);
            g.drawOval(point.x - 3, point.y - 3, 6, 6);
        }
        this.paintSysCoor(g);
        this.paintCircle(g);
        this.paintSquare(g);
        g.setColor(Color.green);
        g.fillOval(this.m_xSC - 3, this.m_ySC - 3, 6, 6);
        g.setColor(Color.black);
        g.drawOval(this.m_xSC - 3, this.m_ySC - 3, 6, 6);
    }

    protected void paintSysCoor(Graphics g) {
        g.setColor(this.m_colorSC);
        g.drawLine(this.m_xLeft, this.m_ySC, this.m_xRight, this.m_ySC);
        g.drawLine(this.m_xSC, this.m_yTop, this.m_xSC, this.m_yBottom);
    }

    protected void paintCircle(Graphics g) {
        g.setColor(this.m_colorC);
        g.fillOval(this.m_xC - this.m_circleR, this.m_yC - this.m_circleR, 2 * this.m_circleR, 2 * this.m_circleR);
        g.setColor(Color.black);
        g.drawOval(this.m_xC - this.m_circleR, this.m_yC - this.m_circleR, 2 * this.m_circleR, 2 * this.m_circleR);
    }

    protected void paintSquare(Graphics g) {
        g.setColor(this.m_colorS);
        g.fillRect(this.m_xS - this.m_squareR, this.m_yS - this.m_squareR, 2 * this.m_squareR, 2 * this.m_squareR);
        g.setColor(Color.black);
        g.drawRect(this.m_xS - this.m_squareR, this.m_yS - this.m_squareR, 2 * this.m_squareR, 2 * this.m_squareR);
    }

    public void setOriginMode(int mode) {
        this.m_origin_mode = mode;
    }

    public void setScene() {
        this.m_init_speed = (double)this.m_slider1.getCurrentValue() / 4.0;
        this.m_accel = (double)this.m_slider2.getCurrentValue() / 5.0;
        this.m_vcircleX = (this.m_init_speed + this.m_accel * this.m_time) * 0.707;
        this.m_vcircleY = (this.m_init_speed + this.m_accel * this.m_time) * 0.707;
        switch (this.m_origin_mode) {
            case 0: {
                this.m_transformX = 0.0;
                this.m_transformY = 0.0;
                break;
            }
            case 1: {
                this.m_transformX = this.m_vcircleX * this.m_time;
                this.m_transformY = this.m_vcircleY * this.m_time;
                break;
            }
            case 2: {
                this.m_transformX = (double)2 * this.m_time;
                this.m_transformY = 0.0;
            }
        }
        this.m_xSC = this.m_x0 - (int)this.m_transformX;
        this.m_ySC = this.m_y0 + (int)this.m_transformY;
        this.m_xC = this.m_x0 + (int)(this.m_vcircleX * this.m_time - this.m_transformX);
        this.m_yC = this.m_y0 - (int)(this.m_vcircleY * this.m_time - this.m_transformY);
        this.m_xS = this.m_x0 + (int)((double)2 * this.m_time - this.m_transformX);
        this.m_yS = this.m_y0 + (int)this.m_transformY;
    }

    public boolean moveScene(double time_shift, boolean mode) {
        double time_save = this.m_time;
        int counter_save = this.m_counter;
        if (this.m_counter == 0 && !mode) {
            return false;
        }
        if (mode) {
            this.m_time += time_shift;
            ++this.m_counter;
            this.m_max_counter = this.m_counter;
        } else {
            this.m_time -= time_shift;
            --this.m_counter;
        }
        this.setScene();
        if (this.m_xC < this.m_xLeft || this.m_xC > this.m_xRight || this.m_yC < this.m_yTop || this.m_yC > this.m_yBottom || this.m_xS < this.m_xLeft || this.m_xS > this.m_xRight || this.m_yS < this.m_yTop || this.m_yS > this.m_yBottom) {
            if (mode) {
                this.m_time -= time_shift;
                --this.m_counter;
                this.setScene();
                return false;
            }
            this.m_time += time_shift;
            ++this.m_counter;
            this.m_max_counter = this.m_counter;
            this.setScene();
            return false;
        }
        if (this.m_counter == this.m_max_counter && this.m_counter >= this.m_second_step && this.m_counter % this.m_second_step == 0) {
            this.m_circlePoints.addElement(new Point(this.m_xC, this.m_yC));
            this.m_squarePoints.addElement(new Point(this.m_xS, this.m_yS));
            this.m_originPoints.addElement(new Point(this.m_xSC, this.m_ySC));
        }
        return this.m_result;
    }
}

