/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class ABlock23 {
    protected ABlockPair23 m_pair;
    protected Color m_color;
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_white = new Color(255, 255, 255);
    protected Color m_tens_color = new Color(0, 204, 255);
    protected Color m_weight_color = new Color(51, 153, 102);
    protected int m_width;
    protected int m_height;
    protected int m_x;
    protected int m_y;
    protected int m_x_rope;
    protected int m_y_rope;
    protected int m_y_pulley = ABlockPair23.m_pulley_y;
    protected int m_y_ground = 326;
    protected int m_y_init;
    protected static int m_static_id = 0;
    protected int m_id;
    protected double m_tension = 0.0;
    protected double m_weight = 0.0;
    protected int m_mass;
    int[] m_arrowX = new int[]{0, 0, 0};
    int[] m_arrowY = new int[]{0, 0, 0};

    public ABlock23(ABlockPair23 pair, Color color, int width, int height, int x_rope, int y_rope) {
        this.m_pair = pair;
        this.m_id = m_static_id;
        this.m_color = color;
        this.m_width = width;
        this.m_height = height;
        this.m_x_rope = x_rope;
        this.m_y_rope = this.m_y_init = y_rope;
        this.m_mass = this.m_id == 0 ? 0 : 5;
        ++m_static_id;
    }

    public void paint(Graphics g) {
        if (this.m_id == 0) {
            return;
        }
        this.m_x_rope = ABlockPair23.m_pulley_x + 3 * ASim23.getPulleyRadius() / 2;
        g.setColor(this.m_color);
        g.fillRect(this.m_x_rope - this.m_width / 2, this.m_y_rope, this.m_width, this.m_height);
        g.setColor(this.m_color_black);
        g.drawRect(this.m_x_rope - this.m_width / 2, this.m_y_rope, this.m_width, this.m_height);
        g.drawLine(this.m_x_rope, this.m_y_rope, this.m_x_rope, this.m_y_pulley);
        g.setColor(this.m_color);
        g.fillRect(475 - this.m_width / 2, 161 - this.m_width / 2, this.m_width, this.m_height);
        g.setColor(this.m_color_black);
        g.drawRect(475 - this.m_width / 2, 161 - this.m_width / 2, this.m_width, this.m_height);
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public boolean setRopeY(int new_y_rope) {
        if (new_y_rope + this.m_height > this.m_y_ground) {
            this.m_y_rope = this.m_y_ground - this.m_height;
            return false;
        }
        if (this.m_mass > this.m_pair.getOtherMass(this) && new_y_rope <= this.m_y_init) {
            this.m_y_rope = this.m_y_init;
            this.m_pair.setOtherToInit(this);
            return false;
        }
        this.m_y_rope = new_y_rope;
        return true;
    }

    public int getRopeY() {
        return this.m_y_rope;
    }

    public void setMass(int mass) {
        this.m_mass = mass;
    }

    public void setTension(double tension) {
        this.m_tension = tension;
    }

    public void setWeight(double weight) {
        this.m_weight = weight;
    }

    public void paintWeight(Graphics g, Color color, int x, int y, int s_width, boolean mode) {
        if (this.m_pair.getTension() == 0.0) {
            return;
        }
        g.setColor(color);
        int length = !mode ? (int)this.m_pair.getTension() : (int)this.m_tension;
        if (mode) {
            g.fillRect(x + s_width / 2 - 2, y + s_width / 2, 4, length);
        } else {
            g.fillRect(x + s_width / 2 - 2, y, 4, length);
        }
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        if (!mode) {
            g.setColor(this.m_color_white);
            g.fillOval(x + s_width / 2 - 2, y - 2, 4, 4);
            g.setColor(this.m_color_black);
            g.drawOval(x + s_width / 2 - 2, y - 2, 4, 4);
            g.setColor(color);
            s_width = 0;
        }
        this.m_arrowY[0] = y + s_width / 2 + length;
        this.m_arrowY[1] = y + s_width / 2 + length;
        this.m_arrowY[2] = y + s_width / 2 + length + 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(this.m_color_black);
        if (mode) {
            g.drawString(ASim23.cutDouble(String.valueOf((double)this.m_mass * 9.8)), 250, 164);
        }
    }

    protected void paintTension(Graphics g, int x, int y, int s_width) {
        if (this.m_mass == 0) {
            return;
        }
        g.setColor(this.m_tens_color);
        int length = (int)this.m_tension;
        g.fillRect(x + s_width / 2 - 2, y + s_width / 2 - length, 4, length);
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        this.m_arrowY[0] = y + s_width / 2 - length;
        this.m_arrowY[1] = y + s_width / 2 - length;
        this.m_arrowY[2] = y + s_width / 2 - length - 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(this.m_color_white);
        g.fillOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(this.m_color_black);
        g.drawOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(this.m_color_black);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_tension)), 250, 141);
    }

    public int getY() {
        return this.m_y_rope;
    }

    public boolean setY(int y) {
        boolean result = true;
        if (y <= this.m_y_ground - this.m_height) {
            this.m_y_rope = y;
        } else {
            this.m_y_rope = this.m_y_ground - this.m_height;
            result = false;
        }
        return result;
    }

    public int getMass() {
        return this.m_mass;
    }

    public int getSide() {
        return this.m_width;
    }
}

