/*
 * Decompiled with CFR 0.152.
 */
import com.maris.util.zUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

class ABlockPair23 {
    final int CLOCKWISE = 0;
    final int CONTR_CLOCKWISE = 1;
    final int STILL = 2;
    final int NORMAL = 0;
    final int MOUSE_OVER = 1;
    final int PRESSED = 2;
    final int DISABLED = 3;
    final int MOTION = 0;
    final int GROUND = 1;
    protected int m_regime = 2;
    protected ASim23 m_applet;
    protected double m_tension1;
    protected double m_tension2;
    protected double m_normal1;
    protected double m_normal2;
    protected double m_mg1;
    protected double m_mg2;
    protected double m_coef = 300.0;
    protected double m_time = 0.0;
    protected double m_acceleration = 0.0;
    protected boolean m_move = false;
    protected boolean m_latch1 = true;
    protected boolean m_latch2 = true;
    protected Color m_weight_color = new Color(51, 153, 102);
    protected Color m_tens_color = new Color(0, 204, 255);
    protected Color m_norm_color = new Color(255, 204, 0);
    protected Color m_color_red = new Color(255, 0, 0);
    protected Color m_color_blue = new Color(0, 0, 255);
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_white = new Color(255, 255, 255);
    protected Color m_color_grey = new Color(192, 192, 192);
    protected int m_block1_mass = 0;
    protected int m_block2_mass = 5;
    protected boolean m_can_move = false;
    protected int m_init_y = 200;
    protected ABlock23 m_block1;
    protected ABlock23 m_block2;
    protected static int m_pulley_x = 89;
    protected static int m_pulley_y = 59;
    protected static int m_pulley_x1 = 400;
    protected static int m_pulley_y1 = 161;
    protected double m_aa;
    protected double m_mi;
    protected double m_nt;
    protected Image m_image;
    protected int[] m_arrowX = new int[3];
    protected int[] m_arrowY = new int[3];

    public ABlockPair23(ASim23 applet, Image image) {
        this.m_applet = applet;
        this.m_image = image;
        this.m_block1 = new ABlock23(this, this.m_color_red, 22, 22, 56, this.m_init_y);
        this.m_block2 = new ABlock23(this, this.m_color_blue, 26, 26, 118, this.m_init_y);
        ABlock23.m_static_id = 0;
        this.setAcceleration();
    }

    public void paint(Graphics g) {
        this.paintPulley(g, m_pulley_x, m_pulley_y);
        this.paintPulley(g, m_pulley_x1, m_pulley_y1);
        this.paintRadius(g);
        this.m_block2.paintWeight(g, this.m_tens_color, m_pulley_x1, m_pulley_y1, 3 * ASim23.getPulleyRadius(), false);
        if (this.m_regime == 2) {
            this.m_block2.paintWeight(g, Color.magenta, m_pulley_x1 - 3 * ASim23.getPulleyRadius(), m_pulley_y1, 3 * ASim23.getPulleyRadius(), false);
        }
        this.m_block2.paint(g);
        this.paintWeight(2, g, 475 - this.m_block2.getSide() / 2, 161 - this.m_block2.getSide() / 2, this.m_block2.getSide(), this.m_weight_color);
        this.paintTension(2, g, 475 - this.m_block2.getSide() / 2, 161 - this.m_block2.getSide() / 2, this.m_block2.getSide(), this.m_tens_color);
        this.paintNormal(2, g, 475 - this.m_block2.getSide() / 2, 161 - this.m_block2.getSide() / 2, this.m_block2.getSide(), this.m_norm_color);
        this.paintStuff(g);
        g.drawString("Pulley Radius (cm)", 25, 347);
        g.drawString(String.valueOf(ASim23.getPulleyRadius()), 132, 347);
        g.drawString("Pulley Mass (kg)", 193, 347);
        g.drawString(String.valueOf(ASim23.getPulleyMass()), 290, 347);
        g.drawString("Blue Block Mass (kg)", 357, 347);
        g.drawString(String.valueOf(this.getMass2()), 476, 347);
    }

    public void setBlockDimensions(int block, int mass) {
        int dim = 0;
        switch (mass) {
            case 0: {
                dim = 0;
                break;
            }
            case 1: {
                dim = 10;
                break;
            }
            case 2: {
                dim = 14;
                break;
            }
            case 3: {
                dim = 18;
                break;
            }
            case 4: {
                dim = 22;
                break;
            }
            case 5: {
                dim = 26;
                break;
            }
            case 6: {
                dim = 30;
                break;
            }
            case 7: {
                dim = 34;
                break;
            }
            case 8: {
                dim = 38;
                break;
            }
            case 9: {
                dim = 42;
                break;
            }
            case 10: {
                dim = 46;
                break;
            }
            default: {
                return;
            }
        }
        if (block == 1) {
            this.m_block1.setMass(mass);
            this.m_block1.setWidth(dim);
            this.m_block1.setHeight(dim);
            this.m_block1_mass = mass;
        } else if (block == 2) {
            this.m_block2.setMass(mass);
            this.m_block2.setWidth(dim);
            this.m_block2.setHeight(dim);
            this.m_block2_mass = mass;
        }
    }

    public void setTension(int block, double tension) {
        if (block == 1) {
            this.m_block1.setTension(tension);
        } else if (block == 2) {
            this.m_block2.setTension(tension);
        }
    }

    public boolean moveRope(int mode, int inc) {
        boolean result = true;
        if (mode == 2) {
            return false;
        }
        if (mode == 0) {
            result = this.m_block2.setRopeY(this.m_block2.getRopeY() + inc);
            if (result) {
                this.m_block1.setRopeY(this.m_block1.getRopeY() - inc);
            }
        } else {
            result = this.m_block1.setRopeY(this.m_block1.getRopeY() + inc);
            if (result) {
                this.m_block2.setRopeY(this.m_block2.getRopeY() - inc);
            }
        }
        this.m_can_move = result;
        return result;
    }

    public void startRope() {
        this.m_can_move = true;
    }

    public boolean canMove() {
        return this.m_can_move;
    }

    public int getMass1() {
        return this.m_block1_mass;
    }

    public int getMass2() {
        return this.m_block2_mass;
    }

    public int getInitY() {
        return this.m_init_y;
    }

    public int getRopeY() {
        if (this.m_block2_mass > this.m_block1_mass) {
            return this.m_block2.getRopeY();
        }
        return this.m_block1.getRopeY();
    }

    public int getOtherMass(ABlock23 block) {
        if (block.equals(this.m_block1)) {
            return this.getMass2();
        }
        return this.getMass1();
    }

    public void setOtherToInit(ABlock23 block) {
        if (block.equals(this.m_block1)) {
            this.m_block2.setRopeY(this.m_init_y);
        } else {
            this.m_block1.setRopeY(this.m_init_y);
        }
    }

    public void paintPulley(Graphics g, int x, int y) {
        int coeff = 3;
        if (ASim23.m_pulley_coeff == 0.5) {
            g.setColor(this.m_color_grey);
            g.fillOval(x - coeff * ASim23.getPulleyRadius() / 2, y - coeff * ASim23.getPulleyRadius() / 2, coeff * ASim23.getPulleyRadius(), coeff * ASim23.getPulleyRadius());
            g.setColor(this.m_color_black);
            g.drawOval(x - coeff * ASim23.getPulleyRadius() / 2, y - coeff * ASim23.getPulleyRadius() / 2, coeff * ASim23.getPulleyRadius(), coeff * ASim23.getPulleyRadius());
            g.fillOval(x - 5, y - 5, 10, 10);
            g.drawOval(x - 5, y - 5, 10, 10);
        }
        if (ASim23.m_pulley_coeff == 1.0) {
            g.setColor(this.m_color_grey);
            g.fillOval(x - coeff * ASim23.getPulleyRadius() / 2, y - coeff * ASim23.getPulleyRadius() / 2, coeff * ASim23.getPulleyRadius(), coeff * ASim23.getPulleyRadius());
            g.setColor(this.m_color_black);
            g.drawOval(x - coeff * ASim23.getPulleyRadius() / 2, y - coeff * ASim23.getPulleyRadius() / 2, coeff * ASim23.getPulleyRadius(), coeff * ASim23.getPulleyRadius());
            g.setColor(this.m_color_white);
            g.fillOval(x - coeff * ASim23.getPulleyRadius() / 2 + 2, y - coeff * ASim23.getPulleyRadius() / 2 + 2, coeff * ASim23.getPulleyRadius() - 4, coeff * ASim23.getPulleyRadius() - 4);
            g.setColor(this.m_color_black);
            g.drawOval(x - coeff * ASim23.getPulleyRadius() / 2 + 2, y - coeff * ASim23.getPulleyRadius() / 2 + 2, coeff * ASim23.getPulleyRadius() - 4, coeff * ASim23.getPulleyRadius() - 4);
        }
        if (ASim23.m_pulley_coeff == 0.4) {
            zUtil.drawImage((Graphics)g, (Image)this.m_image, (int)(x - coeff * ASim23.getPulleyRadius() / 2), (int)(y - coeff * ASim23.getPulleyRadius() / 2), (int)(x + coeff * ASim23.getPulleyRadius() / 2), (int)(y + coeff * ASim23.getPulleyRadius() / 2), (int)0, (int)0, (int)40, (int)40, null);
        }
    }

    protected void paintRadius(Graphics g) {
        if (ASim23.m_pulley_coeff == 0.4) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        int y2 = this.m_block2.getY();
        double d = 3 * ASim23.getPulleyRadius();
        double angle = 0.5235987755982988 - (double)(2 * y2) / d;
        int X = (int)((double)m_pulley_x + d / (double)2 * Math.cos(angle));
        int Y = (int)((double)m_pulley_y - d / (double)2 * Math.sin(angle));
        g.drawLine(m_pulley_x, m_pulley_y, X, Y);
    }

    public boolean positionBlocks() {
        if (this.m_regime == 1) {
            return false;
        }
        boolean result = true;
        if (!this.m_block1.setY(this.m_init_y - (int)(this.m_acceleration * this.m_time * this.m_time * this.m_coef / (double)2))) {
            result = false;
        }
        if (!this.m_block2.setY(this.m_init_y + (int)(this.m_acceleration * this.m_time * this.m_time * this.m_coef / (double)2))) {
            result = false;
        }
        return result;
    }

    public void move(boolean mode, double step) {
        if (!this.m_move) {
            return;
        }
        double old_time = this.m_time;
        if (mode) {
            this.m_time += step;
        } else {
            this.m_time -= step;
            if (this.m_time < 0.0) {
                this.m_time = 0.0;
                this.m_applet.setButton(3, 3);
                if (this.m_latch2) {
                    this.m_regime = 2;
                    this.setAcceleration();
                    this.m_applet.setButton(0, 0);
                    this.m_applet.setButton(4, 0);
                    this.m_latch2 = false;
                }
                return;
            }
        }
        if (!this.positionBlocks()) {
            this.m_time = old_time;
            this.m_applet.setButton(0, 3);
            this.m_applet.setButton(4, 3);
            if (this.m_latch1) {
                this.m_regime = 1;
                this.setAcceleration();
                this.m_applet.setButton(3, 0);
                this.m_latch1 = false;
            }
            return;
        }
        this.m_latch1 = true;
        this.m_latch2 = true;
    }

    public void setAcceleration() {
        double g = 9.8;
        int M = ASim23.getPulleyMass();
        int m1 = this.m_block1.getMass();
        int m2 = this.m_block2.getMass();
        this.m_mg1 = (double)m1 * 9.8;
        this.m_mg2 = (double)m2 * 9.8;
        if (this.m_regime == 2) {
            this.m_acceleration = 0.0;
            if (m2 > m1) {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m2;
                this.m_normal1 = -(this.m_mg1 - this.m_tension2);
                this.m_normal2 = 0.0;
            } else {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m1;
                this.m_normal2 = -(this.m_mg2 - this.m_tension1);
                this.m_normal1 = 0.0;
            }
        }
        if (this.m_regime == 1) {
            this.m_acceleration = 0.0;
            if (m2 < m1) {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m2;
                this.m_normal1 = -(this.m_mg1 - this.m_tension2);
                this.m_normal2 = 0.0;
            } else {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m1;
                this.m_normal2 = -(this.m_mg2 - this.m_tension1);
                this.m_normal1 = 0.0;
            }
        }
        double c = ASim23.getPulleyCoef();
        double r = (double)ASim23.getPulleyRadius() / 100.0;
        if (this.m_regime == 0) {
            this.m_acceleration = (double)m2 * g / ((double)m2 + c * (double)M);
            this.m_tension1 = (double)m1 * (9.8 + this.m_acceleration);
            this.m_tension2 = (double)m2 * (9.8 - this.m_acceleration);
            this.m_normal2 = 0.0;
            this.m_normal1 = 0.0;
        }
        this.m_aa = this.m_acceleration / r;
        this.m_mi = c * (double)ASim23.getPulleyMass() * r * r;
        this.m_nt = c * (double)ASim23.getPulleyMass() * r * this.m_acceleration;
    }

    public void start() {
        this.m_move = true;
        this.m_regime = 0;
        this.setAcceleration();
    }

    public void stop() {
        this.m_move = false;
        this.setAcceleration();
    }

    public void toggle() {
        if (this.m_move) {
            this.stop();
        } else {
            this.start();
        }
    }

    protected void paintTension(int which, Graphics g, int x, int y, int s_width, Color color) {
        double m_tension = which == 1 ? this.m_tension1 : this.m_tension2;
        if (m_tension == 0.0) {
            return;
        }
        g.setColor(color);
        int length = (int)m_tension;
        g.fillRect(x + s_width / 2 - 2, y + s_width / 2 - length, 4, length);
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        this.m_arrowY[0] = y + s_width / 2 - length;
        this.m_arrowY[1] = y + s_width / 2 - length;
        this.m_arrowY[2] = y + s_width / 2 - length - 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(Color.white);
        g.fillOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(Color.black);
        g.drawOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
    }

    public void paintWeight(int which, Graphics g, int x, int y, int s_width, Color color) {
        g.setColor(color);
        double m_mass = which == 1 ? this.m_mg1 : this.m_mg2;
        int length = (int)m_mass;
        g.fillRect(x + s_width / 2 - 2, y + s_width / 2, 4, length);
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        this.m_arrowY[0] = y + s_width / 2 + length;
        this.m_arrowY[1] = y + s_width / 2 + length;
        this.m_arrowY[2] = y + s_width / 2 + length + 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(Color.white);
        g.fillOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(Color.black);
        g.drawOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
    }

    public double getAcceleration() {
        return this.m_acceleration;
    }

    public void paintNormal(int which, Graphics g, int x, int y, int s_width, Color color) {
        if (which == 1) {
            if (this.m_normal1 > 0.0) {
                double old = this.m_mg1;
                this.m_mg1 = this.m_normal1;
                this.paintWeight(which, g, x, y, s_width, color);
                this.m_mg1 = old;
                if (this.m_mg1 < this.m_normal1) {
                    this.paintWeight(which, g, x, y, s_width, this.m_weight_color);
                }
            } else if (this.m_normal1 < 0.0) {
                double old = this.m_tension1;
                this.m_tension1 = -this.m_normal1;
                this.paintTension(which, g, x, y, s_width, color);
                this.m_tension1 = old;
                if (this.m_tension1 < Math.abs(this.m_normal1)) {
                    this.paintTension(which, g, x, y, s_width, this.m_tens_color);
                }
            }
        } else if (this.m_normal2 > 0.0) {
            double old = this.m_mg2;
            this.m_mg2 = this.m_normal2;
            this.paintWeight(which, g, x, y, s_width, color);
            this.m_mg2 = old;
            if (this.m_mg2 < this.m_normal2) {
                this.paintWeight(which, g, x, y, s_width, this.m_weight_color);
            }
        } else if (this.m_normal2 < 0.0) {
            double old = this.m_tension2;
            this.m_tension2 = -this.m_normal2;
            this.paintTension(which, g, x, y, s_width, color);
            this.m_tension2 = old;
            if (this.m_tension2 < Math.abs(this.m_normal2)) {
                this.paintTension(which, g, x, y, s_width, this.m_tens_color);
            }
        }
    }

    public void setBlockMass(int mass) {
        this.m_block2.setMass(mass);
        this.m_block2_mass = mass;
        this.setBlockDimensions(2, mass);
        this.setAcceleration();
    }

    public void paintStuff(Graphics g) {
        g.setColor(Color.black);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_acceleration)), 416, 41);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_tension2)), 250, 141);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_mg2)), 250, 164);
        if (this.m_normal2 != 0.0) {
            g.drawString(ASim23.cutDouble(String.valueOf(Math.abs(this.m_normal2))), 250, 187);
        } else {
            g.drawString("n/a", 250, 187);
        }
        g.setColor(Color.blue);
        double rad = (double)ASim23.getPulleyRadius() / 100.0;
        g.drawString(ASim23.cutDouble(String.valueOf(rad)), 270, 221);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_aa)), 285, 238);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_mi)), 280, 255);
        g.drawString(ASim23.cutDouble(String.valueOf(this.m_nt)), 265, 272);
        g.setColor(Color.black);
    }

    public double getTension() {
        return this.m_tension2;
    }

    public void reset() {
        this.m_time = 0.0;
        this.m_regime = 2;
        this.m_block1.setY(this.m_init_y);
        this.m_block2.setY(this.m_init_y);
        this.m_move = false;
        this.setAcceleration();
    }
}

