/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AAtom {
    protected int m_x;
    protected int m_y;
    protected int m_el_x;
    protected int m_el_y;
    protected int m_mode = 1;
    protected int m_old_mode;
    protected int[] m_radius = new int[]{30, 66, 120};
    protected int m_el_radius = 4;
    protected int m_kernel_radius = 7;
    protected Color m_orbit_color = new Color(150, 150, 150);
    protected Color m_el_color = Color.green;
    protected Color m_kernel_color = Color.red;
    protected double m_angle = 0.0;
    protected boolean m_transfer = false;
    protected boolean m_blink = true;
    protected int m_transfer_radius;
    protected Color m_color_green = new Color(0, 150, 0);

    public AAtom(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.setElPosition();
    }

    public void paint(Graphics g) {
        g.setColor(this.m_kernel_color);
        g.fillOval(this.m_x - this.m_kernel_radius, this.m_y - this.m_kernel_radius, 2 * this.m_kernel_radius, 2 * this.m_kernel_radius);
        g.setColor(Color.white);
        g.drawLine(this.m_x, this.m_y - 3, this.m_x, this.m_y + 3);
        g.drawLine(this.m_x - 3, this.m_y, this.m_x + 3, this.m_y);
        g.setColor(Color.black);
        g.drawOval(this.m_x - this.m_kernel_radius, this.m_y - this.m_kernel_radius, 2 * this.m_kernel_radius, 2 * this.m_kernel_radius);
        g.setColor(this.m_orbit_color);
        for (int count = 0; count < 3; ++count) {
            g.drawOval(this.m_x - this.m_radius[count], this.m_y - this.m_radius[count], 2 * this.m_radius[count], 2 * this.m_radius[count]);
        }
        g.setColor(this.m_el_color);
        g.fillOval(this.m_el_x - this.m_el_radius, this.m_el_y - this.m_el_radius, 2 * this.m_el_radius, 2 * this.m_el_radius);
        g.setColor(Color.black);
        g.drawOval(this.m_el_x - this.m_el_radius, this.m_el_y - this.m_el_radius, 2 * this.m_el_radius, 2 * this.m_el_radius);
        if (this.m_transfer && this.m_blink) {
            this.paintPhoton(g);
        }
    }

    public void setElPosition() {
        this.m_el_x = (int)((double)this.m_x + (double)this.m_radius[this.m_mode] * Math.cos(this.m_angle));
        this.m_el_y = (int)((double)this.m_y - (double)this.m_radius[this.m_mode] * Math.sin(this.m_angle));
    }

    public void setElPosition(int radius) {
        this.m_el_x = (int)((double)this.m_x + (double)radius * Math.cos(this.m_angle));
        this.m_el_y = (int)((double)this.m_y - (double)radius * Math.sin(this.m_angle));
    }

    public void setElMode(int mode) {
        if (mode < 0 || mode > 2) {
            return;
        }
        this.m_old_mode = this.m_mode;
        this.m_transfer_radius = this.m_radius[this.m_mode];
        this.m_mode = mode;
        this.m_transfer = true;
    }

    public void moveEl(double angle) {
        if (!this.m_transfer) {
            if (this.m_mode == 1) {
                angle /= (double)5;
            }
            if (this.m_mode == 2) {
                angle /= (double)16;
            }
            this.m_angle += angle;
            this.setElPosition();
        } else {
            if (this.m_transfer_radius > this.m_radius[this.m_mode]) {
                this.m_transfer_radius -= 4;
                if (this.m_transfer_radius < this.m_radius[this.m_mode]) {
                    this.m_transfer = false;
                    return;
                }
                this.setElPosition(this.m_transfer_radius);
            } else {
                this.m_transfer_radius += 4;
                if (this.m_transfer_radius > this.m_radius[this.m_mode]) {
                    this.m_transfer = false;
                    return;
                }
                this.setElPosition(this.m_transfer_radius);
            }
            this.m_blink = !this.m_blink;
        }
    }

    public int getElMode() {
        return this.m_mode;
    }

    public void paintPhoton(Graphics g) {
        double angle = this.m_angle + 1.5707963267948966;
        if (this.m_old_mode < this.m_mode) {
            angle -= Math.PI;
            g.setColor(Color.blue);
        } else {
            g.setColor(Color.blue);
        }
        int x1 = (int)((double)this.m_el_x + (double)15 * Math.cos(angle));
        int y1 = (int)((double)this.m_el_y - (double)15 * Math.sin(angle));
        g.drawLine(this.m_el_x, this.m_el_y, x1, y1);
        int x2 = (int)((double)x1 + (double)7 * Math.cos(angle -= 1.1780972450961724));
        int y2 = (int)((double)y1 - (double)7 * Math.sin(angle));
        g.drawLine(x1, y1, x2, y2);
        int x3 = (int)((double)x2 + (double)14 * Math.cos(angle += 2.356194490192345));
        int y3 = (int)((double)y2 - (double)14 * Math.sin(angle));
        g.drawLine(x2, y2, x3, y3);
        int x4 = (int)((double)x3 + (double)14 * Math.cos(angle -= 2.356194490192345));
        int y4 = (int)((double)y3 - (double)14 * Math.sin(angle));
        g.drawLine(x3, y3, x4, y4);
        int x5 = (int)((double)x4 + (double)7 * Math.cos(angle += 2.356194490192345));
        int y5 = (int)((double)y4 - (double)7 * Math.sin(angle));
        g.drawLine(x4, y4, x5, y5);
        int x6 = (int)((double)x5 + (double)15 * Math.cos(angle -= 1.1780972450961724));
        int y6 = (int)((double)y5 - (double)15 * Math.sin(angle));
        g.drawLine(x6, y6, x5, y5);
        if (this.m_old_mode < this.m_mode) {
            int x7 = (int)((double)this.m_el_x + (double)10 * Math.cos(angle += 0.39269908169872414));
            int y7 = (int)((double)this.m_el_y - (double)10 * Math.sin(angle));
            int x8 = (int)((double)this.m_el_x + (double)10 * Math.cos(angle -= 0.7853981633974483));
            int y8 = (int)((double)this.m_el_y - (double)10 * Math.sin(angle));
            g.drawLine(this.m_el_x, this.m_el_y, x7, y7);
            g.drawLine(this.m_el_x, this.m_el_y, x8, y8);
        } else {
            int x7 = (int)((double)x6 + (double)7 * Math.cos(angle += 2.748893571891069));
            int y7 = (int)((double)y6 - (double)7 * Math.sin(angle));
            int x8 = (int)((double)x6 + (double)7 * Math.cos(angle -= 5.497787143782138));
            int y8 = (int)((double)y6 - (double)7 * Math.sin(angle));
            g.drawLine(x6, y6, x7, y7);
            g.drawLine(x6, y6, x8, y8);
        }
    }

    public void calcPhoton() {
    }
}

