/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class ABoat {
    protected int m_x;
    protected int m_y;
    protected int m_x0;
    protected int m_y0;
    protected int m_width = 16;
    protected int m_height = 32;
    protected double[] m_Xd;
    protected double[] m_Yd;
    protected double m_speed;
    protected double m_speedX;
    protected double m_speedY;
    protected double m_magnitude = 10.0;
    protected double m_angle;
    protected double m_magnitude_c = 0.0;
    protected double m_angle_c = 0.0;
    protected double m_magnitude_r;
    protected double m_angle_r;
    protected int m_arrow_side = 12;
    protected double m_arrow_angle = 1.0471975511965976;
    protected int m_arrow_shift = 4;
    protected int[] m_X = new int[7];
    protected int[] m_Y = new int[7];
    protected int[] m_Xc = new int[7];
    protected int[] m_Yc = new int[7];
    protected int[] m_Xr = new int[7];
    protected int[] m_Yr = new int[7];
    protected int[] m_Xb = new int[5];
    protected int[] m_Yb = new int[5];
    protected Color m_boat_color = new Color(220, 200, 0);
    protected Color m_color_green = new Color(0, 100, 0);
    double boat_base = 32.0;
    double boat_width = 16.0;
    double boat_angle = 2.0943951023931953;
    protected double m_x_counter = 0.0;
    protected double m_y_counter = 0.0;

    public ABoat(int x, int y) {
        this.m_x = this.m_x0 = x;
        this.m_y = this.m_y0 = y;
    }

    public void paint(Graphics g) {
        this.paintBoat(g);
        if (this.m_magnitude > 0.0 && this.m_magnitude_c > 0.0) {
            g.setColor(Color.white);
            g.drawLine(this.m_X[3], this.m_Y[3], this.m_Xr[3], this.m_Yr[3]);
            g.drawLine(this.m_Xc[3], this.m_Yc[3], this.m_Xr[3], this.m_Yr[3]);
        }
        if (this.m_magnitude > 0.0) {
            g.setColor(Color.red);
            g.fillPolygon(this.m_X, this.m_Y, 7);
            g.setColor(Color.black);
            g.drawPolygon(this.m_X, this.m_Y, 7);
        }
        if (this.m_magnitude_c > 0.0) {
            g.setColor(Color.blue);
            g.fillPolygon(this.m_Xc, this.m_Yc, 7);
            g.setColor(Color.black);
            g.drawPolygon(this.m_Xc, this.m_Yc, 7);
        }
        if (this.m_magnitude_r > 0.0) {
            g.setColor(this.m_color_green);
            g.fillPolygon(this.m_Xr, this.m_Yr, 7);
            g.setColor(Color.black);
            g.drawPolygon(this.m_Xr, this.m_Yr, 7);
        }
        g.setColor(Color.green);
        g.fillOval(this.m_x - 3, this.m_y - 3, 6, 6);
        g.setColor(Color.black);
        g.drawOval(this.m_x - 3, this.m_y - 3, 6, 6);
    }

    public void updateBoat() {
        this.m_magnitude = ASim44.getBoatVelocity();
        this.m_magnitude_c = ASim44.getRiverVelocity();
        this.m_angle = this.toRadians(ASim44.getBoatAngle());
        double mag_cos_r = this.m_magnitude_c + this.m_magnitude * Math.cos(this.m_angle);
        double mag_sin_r = this.m_magnitude * Math.sin(this.m_angle);
        this.m_magnitude_r = Math.sqrt(Math.pow(mag_sin_r, 2.0) + Math.pow(mag_cos_r, 2.0));
        this.m_angle_r = Math.atan(mag_sin_r / mag_cos_r);
        if (this.m_angle_r < 0.0) {
            this.m_angle_r += Math.PI;
        }
        this.updateForce();
        this.updateForceC();
        this.updateForceR();
    }

    public void updateForce() {
        this.m_magnitude *= (double)10;
        double arrow_height = (double)this.m_arrow_side * Math.cos(this.m_arrow_angle / (double)2);
        double arrow_width = (double)2 * ((double)this.m_arrow_side * Math.sin(this.m_arrow_angle / (double)2) - (double)this.m_arrow_shift);
        double arrow_length = this.m_magnitude + arrow_height;
        int xa = (int)((double)this.m_x - arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle));
        int ya = (int)((double)this.m_y - arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle));
        int xb = xa + (int)(this.m_magnitude * Math.cos(this.m_angle));
        int yb = ya - (int)(this.m_magnitude * Math.sin(this.m_angle));
        int xc = xb - (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle));
        int yc = yb - (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle));
        int xd = (int)((double)this.m_x + arrow_length * Math.cos(this.m_angle));
        int yd = (int)((double)this.m_y - arrow_length * Math.sin(this.m_angle));
        int xg = (int)((double)this.m_x + arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle));
        int yg = (int)((double)this.m_y + arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle));
        int xf = xg + (int)(this.m_magnitude * Math.cos(this.m_angle));
        int yf = yg - (int)(this.m_magnitude * Math.sin(this.m_angle));
        int xe = xf + (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle));
        int ye = yf + (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle));
        this.m_X[0] = xa;
        this.m_X[1] = xb;
        this.m_X[2] = xc;
        this.m_X[3] = xd;
        this.m_X[4] = xe;
        this.m_X[5] = xf;
        this.m_X[6] = xg;
        this.m_Y[0] = ya;
        this.m_Y[1] = yb;
        this.m_Y[2] = yc;
        this.m_Y[3] = yd;
        this.m_Y[4] = ye;
        this.m_Y[5] = yf;
        this.m_Y[6] = yg;
        double b_arr_height = this.boat_width / (double)2 * 1.0 / Math.atan(this.boat_angle / (double)2);
        double boat_length = this.boat_base / (double)2 + b_arr_height;
        double x1 = (double)this.m_x - this.boat_base / (double)2 * Math.cos(this.m_angle);
        double y1 = (double)this.m_y + this.boat_base / (double)2 * Math.sin(this.m_angle);
        this.m_Xb[0] = (int)(x1 - this.boat_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle));
        this.m_Yb[0] = (int)(y1 - this.boat_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle));
        this.m_Xb[1] = (int)((double)this.m_Xb[0] + this.boat_base * Math.cos(this.m_angle));
        this.m_Yb[1] = (int)((double)this.m_Yb[0] - this.boat_base * Math.sin(this.m_angle));
        this.m_Xb[2] = (int)((double)this.m_x + boat_length * Math.cos(this.m_angle));
        this.m_Yb[2] = (int)((double)this.m_y - boat_length * Math.sin(this.m_angle));
        this.m_Xb[4] = (int)(x1 + this.boat_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle));
        this.m_Yb[4] = (int)(y1 + this.boat_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle));
        this.m_Xb[3] = (int)((double)this.m_Xb[4] + this.boat_base * Math.cos(this.m_angle));
        this.m_Yb[3] = (int)((double)this.m_Yb[4] - this.boat_base * Math.sin(this.m_angle));
        this.m_magnitude /= (double)10;
    }

    public void updateForceC() {
        this.m_magnitude_c *= (double)10;
        double arrow_height = (double)this.m_arrow_side * Math.cos(this.m_arrow_angle / (double)2);
        double arrow_width = (double)2 * ((double)this.m_arrow_side * Math.sin(this.m_arrow_angle / (double)2) - (double)this.m_arrow_shift);
        double arrow_length = this.m_magnitude_c + arrow_height;
        int xa = (int)((double)this.m_x - arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_c));
        int ya = (int)((double)this.m_y - arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_c));
        int xb = xa + (int)(this.m_magnitude_c * Math.cos(this.m_angle_c));
        int yb = ya - (int)(this.m_magnitude_c * Math.sin(this.m_angle_c));
        int xc = xb - (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle_c));
        int yc = yb - (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle_c));
        int xd = (int)((double)this.m_x + arrow_length * Math.cos(this.m_angle_c));
        int yd = (int)((double)this.m_y - arrow_length * Math.sin(this.m_angle_c));
        int xg = (int)((double)this.m_x + arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_c));
        int yg = (int)((double)this.m_y + arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_c));
        int xf = xg + (int)(this.m_magnitude_c * Math.cos(this.m_angle_c));
        int yf = yg - (int)(this.m_magnitude_c * Math.sin(this.m_angle_c));
        int xe = xf + (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle_c));
        int ye = yf + (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle_c));
        this.m_Xc[0] = xa;
        this.m_Xc[1] = xb;
        this.m_Xc[2] = xc;
        this.m_Xc[3] = xd;
        this.m_Xc[4] = xe;
        this.m_Xc[5] = xf;
        this.m_Xc[6] = xg;
        this.m_Yc[0] = ya;
        this.m_Yc[1] = yb;
        this.m_Yc[2] = yc;
        this.m_Yc[3] = yd;
        this.m_Yc[4] = ye;
        this.m_Yc[5] = yf;
        this.m_Yc[6] = yg;
        this.m_magnitude_c /= (double)10;
    }

    public void updateForceR() {
        this.m_magnitude_r *= (double)10;
        double arrow_height = (double)this.m_arrow_side * Math.cos(this.m_arrow_angle / (double)2);
        double arrow_width = (double)2 * ((double)this.m_arrow_side * Math.sin(this.m_arrow_angle / (double)2) - (double)this.m_arrow_shift);
        double arrow_length = this.m_magnitude_r + arrow_height;
        int xa = (int)((double)this.m_x - arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_r));
        int ya = (int)((double)this.m_y - arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_r));
        int xb = xa + (int)(this.m_magnitude_r * Math.cos(this.m_angle_r));
        int yb = ya - (int)(this.m_magnitude_r * Math.sin(this.m_angle_r));
        int xc = xb - (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle_r));
        int yc = yb - (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle_r));
        int xd = (int)((double)this.m_x + arrow_length * Math.cos(this.m_angle_r));
        int yd = (int)((double)this.m_y - arrow_length * Math.sin(this.m_angle_r));
        int xg = (int)((double)this.m_x + arrow_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_r));
        int yg = (int)((double)this.m_y + arrow_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_r));
        int xf = xg + (int)(this.m_magnitude_r * Math.cos(this.m_angle_r));
        int yf = yg - (int)(this.m_magnitude_r * Math.sin(this.m_angle_r));
        int xe = xf + (int)((double)this.m_arrow_shift * Math.cos(1.5707963267948966 - this.m_angle_r));
        int ye = yf + (int)((double)this.m_arrow_shift * Math.sin(1.5707963267948966 - this.m_angle_r));
        this.m_Xr[0] = xa;
        this.m_Xr[1] = xb;
        this.m_Xr[2] = xc;
        this.m_Xr[3] = xd;
        this.m_Xr[4] = xe;
        this.m_Xr[5] = xf;
        this.m_Xr[6] = xg;
        this.m_Yr[0] = ya;
        this.m_Yr[1] = yb;
        this.m_Yr[2] = yc;
        this.m_Yr[3] = yd;
        this.m_Yr[4] = ye;
        this.m_Yr[5] = yf;
        this.m_Yr[6] = yg;
        if (this.m_magnitude == 0.0) {
            double b_arr_height = this.boat_width / (double)2 * 1.0 / Math.atan(this.boat_angle / (double)2);
            double boat_length = this.boat_base / (double)2 + b_arr_height;
            double x1 = (double)this.m_x - this.boat_base / (double)2 * Math.cos(this.m_angle_r);
            double y1 = (double)this.m_y + this.boat_base / (double)2 * Math.sin(this.m_angle_r);
            this.m_Xb[0] = (int)(x1 - this.boat_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_r));
            this.m_Yb[0] = (int)(y1 - this.boat_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_r));
            this.m_Xb[1] = (int)((double)this.m_Xb[0] + this.boat_base * Math.cos(this.m_angle_r));
            this.m_Yb[1] = (int)((double)this.m_Yb[0] - this.boat_base * Math.sin(this.m_angle_r));
            this.m_Xb[2] = (int)((double)this.m_x + boat_length * Math.cos(this.m_angle_r));
            this.m_Yb[2] = (int)((double)this.m_y - boat_length * Math.sin(this.m_angle_r));
            this.m_Xb[4] = (int)(x1 + this.boat_width / (double)2 * Math.cos(1.5707963267948966 - this.m_angle_r));
            this.m_Yb[4] = (int)(y1 + this.boat_width / (double)2 * Math.sin(1.5707963267948966 - this.m_angle_r));
            this.m_Xb[3] = (int)((double)this.m_Xb[4] + this.boat_base * Math.cos(this.m_angle_r));
            this.m_Yb[3] = (int)((double)this.m_Yb[4] - this.boat_base * Math.sin(this.m_angle_r));
        }
        this.m_magnitude_r /= (double)10;
    }

    protected double toRadians(double angle) {
        return angle * (double)2 * Math.PI / (double)360;
    }

    public boolean moveBoat(boolean mode) {
        boolean result = true;
        int coeff = 1;
        if (!mode) {
            coeff = -1;
        }
        this.m_x_counter += (double)coeff * this.m_magnitude_r * Math.cos(this.m_angle_r) / (double)10;
        this.m_x = this.m_x0 + (int)this.m_x_counter;
        this.m_y_counter += (double)coeff * this.m_magnitude_r * Math.sin(this.m_angle_r) / (double)10;
        this.m_y = this.m_y0 - (int)this.m_y_counter;
        if (this.m_x < 10 + this.m_width / 2 || this.m_x > 497 - this.m_width / 2 || this.m_y < 10 + this.m_height / 2 || this.m_y > 230 - this.m_height / 2) {
            result = false;
            this.m_x_counter -= (double)coeff * this.m_magnitude_r * Math.cos(this.m_angle_r) / (double)10;
            this.m_x = this.m_x0 + (int)this.m_x_counter;
            this.m_y_counter -= (double)coeff * this.m_magnitude_r * Math.sin(this.m_angle_r) / (double)10;
            this.m_y = this.m_y0 - (int)this.m_y_counter;
        }
        if (result) {
            this.updateBoat();
        }
        return result;
    }

    protected int correctX(int x) {
        if (x < 10) {
            return 10;
        }
        if (x > 497) {
            return 497;
        }
        return x;
    }

    protected int correctY(int y) {
        if (y < 10) {
            return 10;
        }
        if (y > 230) {
            return 230;
        }
        return y;
    }

    public double getBoatSpeed() {
        return this.m_magnitude_r;
    }

    protected void paintBoat(Graphics g) {
        g.setColor(this.m_boat_color);
        g.fillPolygon(this.m_Xb, this.m_Yb, 5);
        g.setColor(Color.black);
        g.drawPolygon(this.m_Xb, this.m_Yb, 5);
    }
}

