/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ASlider;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim31
extends Applet
implements Runnable {
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Image m_sliderImage = null;
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    int voltage = 50;
    int xTest;
    int yTest;
    int xMouse;
    int yMouse;
    int x1;
    int y1;
    int Lx;
    int Ly;
    int separation = 40;
    int plateLength;
    double V;
    double Ex;
    double Ey;
    double E;
    double rSq;
    double sep;
    double r;
    double vectorLength;
    double Q;
    int[][][][] LenX = new int[20][14][21][7];
    int[][][][] LenY = new int[20][14][21][7];
    Color[][][][] m_color = new Color[20][14][21][7];
    double[][][][] m_B = new double[20][14][21][7];
    Color m_color_black = new Color(0, 0, 0);
    Color m_color_white = new Color(255, 255, 255);
    Color m_color_green = new Color(0, 255, 0);
    double Bmax = -1.0E10;
    double Bmin = 1.0E10;
    double Bcur;
    protected boolean m_progress = true;
    protected int m_percent = 0;
    protected int m_ticker = 0;
    int mX;
    int mY;
    protected int m_mouse_x;
    protected int m_mouse_y;
    protected int[] m_x_array = new int[]{0, 0, 0};
    protected int[] m_y_array = new int[]{0, 0, 0};
    protected int S1 = 0;
    protected int S2 = 0;
    protected int S3 = 0;
    protected int S4 = 0;
    protected int S5 = 0;
    protected int S6 = 0;
    protected int S7 = 0;
    protected double Bx_save = 0.0;
    protected double By_save = 0.0;
    double Ex_save = 0.0;
    double Ey_save = 0.0;
    boolean[] flag = new boolean[]{true, true, true, true, true, true, true, true};

    public void init() {
        this.separation = 10;
        this.x1 = 200;
        this.y1 = 300;
        this.xMouse = -1;
        this.yMouse = -1;
        this.vectorLength = 9.0;
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_sliderImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_sliderImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_sliderImage, 1);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_slider1 = new ASlider(this.m_sliderImage, 4, 386, 149, 12, -10, 10, 5);
        this.m_slider2 = new ASlider(this.m_sliderImage, 172, 386, 149, 12, 2, 8, 2);
    }

    public void run() {
        while (true) {
            if (this.m_progress) {
                this.calculateA();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        }
    }

    public void paint(Graphics g) {
        if (this.m_progress) {
            this.paintProgress(g, this.m_percent);
            return;
        }
        g.drawImage(this.m_bkImage, 0, 0, null);
        this.paintMagneticLines(g);
        g.setColor(Color.blue);
        int plateWidth = 4;
        g.fillRect(251 - this.plateLength / 2, 183 - plateWidth - this.separation / 2, this.plateLength, plateWidth);
        g.fillRect(251 - this.plateLength / 2, 183 + this.separation / 2, this.plateLength, plateWidth);
        g.setColor(this.m_color_black);
        this.m_slider1.paint(g);
        this.m_slider2.paint(g);
        g.drawString(String.valueOf(10 * this.m_slider1.getCurrentValue()), this.m_slider1.getX() + 4, 379);
        g.drawString(String.valueOf(20 * this.m_slider2.getCurrentValue()), this.m_slider2.getX() + 4, 379);
        g.drawRect(40, 20, 418, 310);
        g.drawString("Voltage (V)", 10, 363);
        g.drawString("Separation (cm)", 175, 363);
    }

    public boolean mouseUp(Event event, int x, int y) {
        if (this.m_progress) {
            return false;
        }
        this.m_slider1.onMouseUp(x, y);
        this.m_slider2.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        if (this.m_progress) {
            return false;
        }
        this.m_slider1.onMouseDown(x, y);
        this.m_slider2.onMouseDown(x, y);
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        this.mX = x;
        this.mY = y;
        if (this.m_progress) {
            return false;
        }
        this.m_mouse_x = x;
        this.m_mouse_y = y;
        this.xMouse = x - 50;
        this.yMouse = y + 120;
        this.m_slider1.onMouseMove(x, y);
        this.m_slider2.onMouseMove(x, y);
        this.calcMouse();
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        if (this.m_progress) {
            return false;
        }
        if (this.m_slider1.onMouseDrag(x, y)) {
            this.voltage = 10 * this.m_slider1.getCurrentValue();
        }
        if (this.m_slider2.onMouseDrag(x, y)) {
            this.separation = 20 * this.m_slider2.getCurrentValue();
        }
        return false;
    }

    public static String cutDouble(String value, int num) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + num) {
            return value.substring(0, index + num + 1);
        }
        return value;
    }

    protected void paintMagneticLines(Graphics g) {
        for (int indexI = 0; indexI < 20; ++indexI) {
            this.xTest = 10 + 20 * indexI;
            for (int indexJ = 0; indexJ < 14; ++indexJ) {
                this.yTest = 170 + 20 * indexJ;
                int v = this.voltage / 10 + 10;
                int s = (this.separation - 40) / 20;
                if (this.m_color[indexI][indexJ] == null) continue;
                this.paintArrow(g, this.m_color[indexI][indexJ][v][s], this.xTest - this.LenX[indexI][indexJ][v][s] + 50, this.yTest + this.LenY[indexI][indexJ][v][s] - 120, this.xTest + this.LenX[indexI][indexJ][v][s] + 50, this.yTest - this.LenY[indexI][indexJ][v][s] - 120);
            }
        }
        g.setColor(this.m_color_black);
        if (this.m_mouse_x > 40 && this.m_mouse_x < 438 && this.m_mouse_y > 20 && this.m_mouse_y < 320) {
            g.drawString(String.valueOf(String.valueOf("X = ").concat(String.valueOf(ASim31.cutDouble(String.valueOf(0.01 * (double)(this.mX - 251)), 3)))).concat(String.valueOf(" m")), 380, 350);
            g.drawString(String.valueOf(String.valueOf("Y = ").concat(String.valueOf(ASim31.cutDouble(String.valueOf(0.01 * (double)(183 - this.mY)), 3)))).concat(String.valueOf(" m")), 380, 370);
            g.drawString(String.valueOf(String.valueOf("E = ").concat(String.valueOf(ASim31.cutDouble(String.valueOf(this.E), 3)))).concat(String.valueOf(" V/m")), 380, 390);
        }
    }

    protected void paintArrow(Graphics g, Color color, int X1, int Y1, int X2, int Y2) {
        int y2;
        int y1;
        int x2;
        int x1;
        g.setColor(color);
        double angle = Math.atan((double)Math.abs(Y2 - Y1) / (double)Math.abs(X2 - X1));
        if (angle < 0.0) {
            // empty if block
        }
        int r = 9;
        if (X2 > X1) {
            x1 = X2 - (int)((double)r * Math.cos(angle - 0.5235987755982988));
            x2 = X2 - (int)((double)r * Math.cos(angle + 0.5235987755982988));
        } else {
            x1 = X2 + (int)((double)r * Math.cos(angle - 0.5235987755982988));
            x2 = X2 + (int)((double)r * Math.cos(angle + 0.5235987755982988));
        }
        if (Y2 > Y1) {
            y1 = Y2 - (int)((double)r * Math.sin(angle - 0.5235987755982988));
            y2 = Y2 - (int)((double)r * Math.sin(angle + 0.5235987755982988));
        } else {
            y1 = Y2 + (int)((double)r * Math.sin(angle - 0.5235987755982988));
            y2 = Y2 + (int)((double)r * Math.sin(angle + 0.5235987755982988));
        }
        this.m_x_array[0] = x1;
        this.m_x_array[1] = x2;
        this.m_x_array[2] = X2;
        this.m_y_array[0] = y1;
        this.m_y_array[1] = y2;
        this.m_y_array[2] = Y2;
        g.fillPolygon(this.m_x_array, this.m_y_array, 3);
        g.drawLine(X1, Y1, X2, Y2);
    }

    public Color calcColor(double arg) {
        double coef = 3.0;
        Color color = null;
        double max = this.Bmax / coef;
        double min = this.Bmin / coef;
        if (arg > max) {
            arg = max;
        }
        if (arg < min) {
            arg = min;
        }
        double step = (max - min) / (double)255;
        int d = (int)((max - arg) / step);
        color = new Color(d, d, d);
        return color;
    }

    public void calcMouse() {
        block4: {
            int indexK = 0;
            boolean indexKa = false;
            this.plateLength = 200;
            int N = 20;
            int NSq = N * N;
            int intLength = this.plateLength / N;
            this.Q = (double)(this.voltage * this.plateLength * this.plateLength) * 8.85E-14 / (double)this.separation;
            this.Q /= (double)NSq;
            if (this.xMouse > -1 && this.yMouse > -1) {
                this.Ey = 0.0;
                this.Ex = 0.0;
                for (int indexL = 0; indexL < N; ++indexL) {
                    int zVal;
                    int xVal = this.x1 + intLength * (N / 2 - indexL) - intLength / 2;
                    int yVal = this.y1 - this.separation / 2;
                    for (indexK = 0; indexK < N; ++indexK) {
                        zVal = intLength * (N / 2 - indexK) - intLength / 2;
                        this.rSq = 1.0E-4 * (double)(this.xMouse - xVal) * (double)(this.xMouse - xVal) + 1.0E-4 * (double)(this.yMouse - yVal) * (double)(this.yMouse - yVal) + 1.0E-4 * (double)zVal * (double)zVal;
                        this.r = Math.sqrt(this.rSq);
                        this.Ex += this.Q / (this.r * this.rSq) * (double)(this.xMouse - xVal);
                        this.Ey += this.Q / (this.r * this.rSq) * (double)(yVal - this.yMouse);
                    }
                    yVal = this.y1 + this.separation / 2;
                    for (indexK = 0; indexK < N; ++indexK) {
                        zVal = intLength * (N / 2 - indexK) - intLength / 2;
                        this.rSq = 1.0E-4 * (double)(this.xMouse - xVal) * (double)(this.xMouse - xVal) + 1.0E-4 * (double)(this.yMouse - yVal) * (double)(this.yMouse - yVal) + 1.0E-4 * (double)zVal * (double)zVal;
                        this.r = Math.sqrt(this.rSq);
                        this.Ex -= this.Q / (this.r * this.rSq) * (double)(this.xMouse - xVal);
                        this.Ey -= this.Q / (this.r * this.rSq) * (double)(yVal - this.yMouse);
                    }
                }
                this.Ex = 8.99E7 * this.Ex;
                this.Ey = 8.99E7 * this.Ey;
                this.E = Math.sqrt(this.Ex * this.Ex + this.Ey * this.Ey);
            }
            if (this.voltage != 0) break block4;
            this.E = 0.0;
        }
    }

    public void paintProgress(Graphics g, int percent) {
        String message = "Precalculating, please wait...";
        int m_length = ASim31.calculateNameLength(g, message);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.m_width, this.m_height);
        g.setColor(Color.lightGray);
        g.fillRect(170 - (206 - m_length) / 2, 187, 226, 60);
        g.setColor(Color.black);
        g.drawRect(170 - (206 - m_length) / 2, 187, 226, 60);
        g.setColor(Color.white);
        g.fillRect(180 - (206 - m_length) / 2, 207, 206, 20);
        g.setColor(Color.black);
        g.drawRect(180 - (206 - m_length) / 2, 207, 206, 20);
        g.setColor(Color.blue);
        g.fillRect(183 - (206 - m_length) / 2, 210, this.m_percent * 2, 15);
        g.setColor(Color.black);
        g.drawString(message, 180, 200);
        if (this.m_percent >= 15) {
            g.setColor(Color.white);
            g.drawString(String.valueOf(String.valueOf(this.m_percent)).concat(String.valueOf(" %")), 186 - (206 - m_length) / 2 + this.m_percent - 14, 222);
        }
    }

    protected static int calculateNameLength(Graphics g, String name) {
        Font font = g.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        return fm.stringWidth(name);
    }

    public void calculateA() {
        int indexJ;
        int indexI;
        int indexK = 0;
        int indexKa = 0;
        this.x1 = 200;
        this.y1 = 300;
        this.plateLength = 200;
        int N = 20;
        int NSq = N * N;
        int intLength = this.plateLength / N;
        this.xMouse = -1;
        this.yMouse = -1;
        this.vectorLength = 9.0;
        double TOTAL = 10290.0;
        int c1 = 0;
        int c2 = 0;
        for (c1 = this.S1; c1 < 21; ++c1) {
            this.voltage = c1 * 10 - 100;
            this.V = this.voltage;
            for (c2 = this.S2; c2 < 7; ++c2) {
                this.separation = 40 + c2 * 20;
                this.sep = this.separation;
                this.Q = this.V * (double)this.plateLength * (double)this.plateLength * 8.85E-14 / this.sep;
                this.Q /= (double)NSq;
                for (indexI = this.S3; indexI < 10; ++indexI) {
                    this.xTest = 10 + 20 * indexI;
                    for (indexJ = this.S4; indexJ < 7; ++indexJ) {
                        int indexL;
                        this.yTest = 170 + 20 * indexJ;
                        this.Ey = 0.0;
                        this.Ex = 0.0;
                        for (indexL = this.S5; indexL < N; ++indexL) {
                            int zVal;
                            int xVal = this.x1 + intLength * (N / 2 - indexL) - intLength / 2;
                            int yVal = this.y1 - this.separation / 2;
                            for (indexK = this.S6; indexK < N; ++indexK) {
                                zVal = intLength * (N / 2 - indexK) - intLength / 2;
                                this.rSq = 1.0E-4 * (double)(this.xTest - xVal) * (double)(this.xTest - xVal) + 1.0E-4 * (double)(this.yTest - yVal) * (double)(this.yTest - yVal) + 1.0E-4 * (double)zVal * (double)zVal;
                                this.r = Math.sqrt(this.rSq);
                                this.Ex += this.Q / (this.r * this.rSq) * (double)(this.xTest - xVal);
                                this.Ey += this.Q / (this.r * this.rSq) * (double)(yVal - this.yTest);
                            }
                            this.S6 = 0;
                            this.flag[6] = false;
                            yVal = this.y1 + this.separation / 2;
                            for (indexKa = this.S7; indexKa < N; ++indexKa) {
                                zVal = intLength * (N / 2 - indexKa) - intLength / 2;
                                this.rSq = 1.0E-4 * (double)(this.xTest - xVal) * (double)(this.xTest - xVal) + 1.0E-4 * (double)(this.yTest - yVal) * (double)(this.yTest - yVal) + 1.0E-4 * (double)zVal * (double)zVal;
                                this.r = Math.sqrt(this.rSq);
                                this.Ex -= this.Q / (this.r * this.rSq) * (double)(this.xTest - xVal);
                                this.Ey -= this.Q / (this.r * this.rSq) * (double)(yVal - this.yTest);
                            }
                            this.S7 = 0;
                            this.flag[7] = false;
                        }
                        this.S5 = 0;
                        this.flag[5] = false;
                        this.Ex = 8.99E7 * this.Ex;
                        this.Ey = 8.99E7 * this.Ey;
                        this.E = Math.sqrt(this.Ex * this.Ex + this.Ey * this.Ey);
                        if (this.E > this.Bmax) {
                            this.Bmax = this.E;
                        }
                        if (this.E < this.Bmin) {
                            this.Bmin = this.E;
                        }
                        this.LenX[indexI][indexJ][c1][c2] = (int)(this.Ex * this.vectorLength / this.E);
                        this.LenY[indexI][indexJ][c1][c2] = (int)(this.Ey * this.vectorLength / this.E);
                        this.m_B[indexI][indexJ][c1][c2] = this.E;
                        this.LenX[19 - indexI][indexJ][c1][c2] = -((int)(this.Ex * this.vectorLength / this.E));
                        this.LenY[19 - indexI][indexJ][c1][c2] = (int)(this.Ey * this.vectorLength / this.E);
                        this.m_B[indexI][indexJ][c1][c2] = this.E;
                        this.LenX[indexI][13 - indexJ][c1][c2] = -((int)(this.Ex * this.vectorLength / this.E));
                        this.LenY[indexI][13 - indexJ][c1][c2] = (int)(this.Ey * this.vectorLength / this.E);
                        this.m_B[indexI][indexJ][c1][c2] = this.E;
                        this.LenX[19 - indexI][13 - indexJ][c1][c2] = (int)(this.Ex * this.vectorLength / this.E);
                        this.LenY[19 - indexI][13 - indexJ][c1][c2] = (int)(this.Ey * this.vectorLength / this.E);
                        this.m_B[indexI][indexJ][c1][c2] = this.E;
                        ++this.m_ticker;
                        int a = this.m_percent;
                        this.m_percent = (int)((double)100 * ((double)this.m_ticker / TOTAL));
                        if (a == this.m_percent) continue;
                        this.S1 = c1;
                        this.S2 = c2;
                        this.S3 = indexI;
                        this.S4 = indexJ;
                        if (this.flag[5]) {
                            this.S5 = indexL;
                        }
                        if (this.flag[6]) {
                            this.S6 = indexK;
                        }
                        if (this.flag[7]) {
                            this.S7 = indexKa;
                        }
                        for (int count = 0; count < 8; ++count) {
                            this.flag[count] = true;
                        }
                        return;
                    }
                    this.S4 = 0;
                }
                this.S3 = 0;
            }
            this.S2 = 0;
        }
        for (c1 = 0; c1 < 21; ++c1) {
            for (c2 = 0; c2 < 7; ++c2) {
                for (indexI = 0; indexI < 10; ++indexI) {
                    for (indexJ = 0; indexJ < 7; ++indexJ) {
                        this.m_color[indexI][indexJ][c1][c2] = this.calcColor(this.m_B[indexI][indexJ][c1][c2]);
                        this.m_color[19 - indexI][indexJ][c1][c2] = this.calcColor(this.m_B[indexI][indexJ][c1][c2]);
                        this.m_color[indexI][13 - indexJ][c1][c2] = this.calcColor(this.m_B[indexI][indexJ][c1][c2]);
                        this.m_color[19 - indexI][13 - indexJ][c1][c2] = this.calcColor(this.m_B[indexI][indexJ][c1][c2]);
                    }
                }
            }
        }
        this.m_progress = false;
        this.m_percent = 0;
        this.m_ticker = 0;
        this.S7 = 0;
        this.S6 = 0;
        this.S5 = 0;
        this.S4 = 0;
        this.S3 = 0;
        this.S2 = 0;
        this.S1 = 0;
        this.Bx_save = 0.0;
        this.By_save = 0.0;
        this.Bmax = -1.0E10;
        this.Bmin = 1.0E10;
        this.separation = 20 * this.m_slider2.getCurrentValue();
        this.voltage = 50;
        this.V = 50;
    }
}

