/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

class ALensC
extends AObject41 {
    protected AScene41 m_scene;
    protected double m_start_angle;
    protected double m_start_angle1;
    protected double m_angle;

    public ALensC(AScene41 scene, int x, int y, int height, int focal_length) {
        this.m_scene = scene;
        this.m_center_x = x;
        this.m_center_y = y;
        this.m_height = height;
        this.m_focal_length = focal_length;
        this.setLensC();
    }

    public void paint(Graphics g) {
        this.paintLens(g);
        this.paintFocalPoints(g);
        this.paintOriginPoint(g);
    }

    protected void paintLens(Graphics g) {
        g.setColor(this.m_lens_color);
        g.drawArc(this.m_center_x, (int)((double)this.m_center_y - this.m_focal_length), (int)((double)2 * this.m_focal_length), (int)((double)2 * this.m_focal_length), this.toDegrees(this.m_start_angle), this.toDegrees(this.m_angle));
        g.drawArc((int)((double)this.m_center_x - (double)2 * this.m_focal_length + (double)2 * this.m_shift), (int)((double)this.m_center_y - this.m_focal_length), (int)((double)2 * this.m_focal_length), (int)((double)2 * this.m_focal_length), this.toDegrees(this.m_start_angle1), -this.toDegrees(this.m_angle));
        g.drawLine(this.m_origin_x, AScene41.getUpperY(), this.m_origin_x, AScene41.getLowerY());
    }

    protected void paintFocalPoints(Graphics g) {
        g.setColor(this.m_color_red);
        g.fillOval(this.m_fp1_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.fillOval(this.m_fp2_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_fp1_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("F", this.m_fp1_x - this.m_fp_radius, this.m_center_y + 20);
        g.drawOval(this.m_fp2_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("F", this.m_fp2_x - this.m_fp_radius, this.m_center_y + 20);
        --this.m_fp_radius;
        g.setColor(this.m_color_blue);
        g.fillOval(this.m_fp3_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.fillOval(this.m_fp4_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_fp3_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("2F", this.m_fp3_x - this.m_fp_radius, this.m_center_y + 20);
        g.drawOval(this.m_fp4_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("2F", this.m_fp4_x - this.m_fp_radius, this.m_center_y + 20);
        ++this.m_fp_radius;
    }

    protected void paintOriginPoint(Graphics g) {
        g.setColor(this.m_color_green);
        g.fillOval(this.m_origin_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_origin_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
    }

    public boolean onMouseDown(int x, int y) {
        if (this.isFocalPoint(x, y)) {
            this.m_fp_hit = true;
        }
        if (this.isOriginPoint(x, y)) {
            this.m_op_hit = true;
        }
        return false;
    }

    public boolean onMouseUp(int x, int y) {
        this.m_fp_hit = false;
        this.m_op_hit = false;
        return false;
    }

    public boolean onMouseDrag(int x, int y) {
        double[] point;
        if (this.m_fp_hit && (double)Math.abs(x - this.m_origin_x) > this.m_height) {
            point = this.m_scene.getObjectPoint();
            int old_length = (int)this.getFocalLength();
            this.setFocalLength(Math.abs(x - this.m_origin_x));
            this.setLensC();
            if ((double)this.m_center_x < point[0]) {
                this.setFocalLength(old_length);
                this.setLensC();
            }
        }
        if (this.m_op_hit && (double)((int)((double)x - this.m_shift)) > (point = this.m_scene.getObjectPoint())[0]) {
            this.m_center_x = (int)((double)x - this.m_shift);
            this.setLensC();
        }
        return false;
    }

    public void setLensC() {
        this.m_start_angle = Math.PI + Math.asin(this.m_height / -this.m_focal_length);
        this.m_angle = (double)2 * Math.asin(this.m_height / this.m_focal_length);
        int s1 = (int)((double)this.m_center_x + this.m_shift);
        this.m_shift = this.m_focal_length + this.m_focal_length * Math.cos(this.m_start_angle);
        int s2 = (int)((double)this.m_center_x + this.m_shift);
        this.m_center_x -= s2 - s1;
        this.m_start_angle1 = Math.asin(this.m_height / this.m_focal_length);
        this.m_fp1_x = (int)((double)this.m_center_x - this.m_focal_length + this.m_shift);
        this.m_fp2_x = (int)((double)this.m_center_x + this.m_focal_length + this.m_shift);
        this.m_fp3_x = (int)((double)this.m_center_x - (double)2 * this.m_focal_length + this.m_shift);
        this.m_fp4_x = (int)((double)this.m_center_x + (double)2 * this.m_focal_length + this.m_shift);
        this.m_origin_x = (int)((double)this.m_center_x + this.m_shift);
    }

    public double[] getOrigin() {
        this.m_coord[0] = this.m_origin_x;
        this.m_coord[1] = this.m_center_y;
        return this.m_coord;
    }

    public double[] getFocalPoint(int which) {
        if (which == 0) {
            this.m_coord[0] = this.m_fp1_x;
            this.m_coord[1] = this.m_center_y;
        } else {
            this.m_coord[0] = this.m_fp2_x;
            this.m_coord[1] = this.m_center_y;
        }
        return this.m_coord;
    }

    public int getLensTop() {
        return (int)((double)this.m_center_y - this.m_height);
    }

    public int getLensBottom() {
        return (int)((double)this.m_center_y + this.m_height);
    }

    public int getLensStartX() {
        return this.m_center_x;
    }
}

