/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

class AMirrorP
extends AObject41 {
    protected AScene41 m_scene;
    protected double m_start_angle;
    protected double m_start_angle1;
    protected double m_angle;

    public AMirrorP(AScene41 scene, int x, int y, int height, int focal_length) {
        this.m_scene = scene;
        this.m_center_x = x;
        this.m_center_y = y;
        this.m_height = height;
        this.m_focal_length = focal_length;
        this.setMirrorP();
    }

    public void paint(Graphics g) {
        this.paintMirror(g);
        this.paintOriginPoint(g);
    }

    protected void paintMirror(Graphics g) {
        int y4;
        int y2;
        int x4;
        int x3;
        g.setColor(this.m_lens_color);
        int x1 = x3 = this.m_origin_x - 2;
        int x2 = x4 = this.m_origin_x + 2;
        int y1 = y2 = this.getLensTop();
        int y3 = y4 = this.getLensBottom();
        g.fillRect(x1, y1, x2 - x1, y3 - y1);
        g.drawLine(this.m_origin_x, y1, this.m_origin_x, AScene41.getUpperY());
        g.drawLine(this.m_origin_x, y3, this.m_origin_x, AScene41.getLowerY());
    }

    protected void paintFocalPoints(Graphics g) {
        g.setColor(this.m_color_red);
        g.fillOval(this.m_fp1_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_fp1_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("F", this.m_fp1_x - this.m_fp_radius, this.m_center_y + 20);
        --this.m_fp_radius;
        g.setColor(this.m_color_blue);
        g.fillOval(this.m_fp3_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_fp3_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.drawString("2F", this.m_fp3_x - this.m_fp_radius, this.m_center_y + 20);
        ++this.m_fp_radius;
    }

    protected void paintOriginPoint(Graphics g) {
        g.setColor(this.m_color_green);
        g.fillOval(this.m_origin_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_origin_x - this.m_fp_radius, this.m_center_y - this.m_fp_radius, 2 * this.m_fp_radius, 2 * this.m_fp_radius);
    }

    public boolean onMouseDown(int x, int y) {
        if (this.isFocalPoint(x, y)) {
            this.m_fp_hit = true;
        }
        if (this.isOriginPoint(x, y)) {
            this.m_op_hit = true;
        }
        return false;
    }

    public boolean onMouseUp(int x, int y) {
        this.m_fp_hit = false;
        this.m_op_hit = false;
        return false;
    }

    public boolean onMouseDrag(int x, int y) {
        double[] point;
        if (this.m_fp_hit && (double)Math.abs(x - this.m_origin_x) > this.m_height / (double)2) {
            point = this.m_scene.getObjectPoint();
            int old_length = (int)this.getFocalLength();
            this.setFocalLength(Math.abs(x - this.m_origin_x));
            this.setMirrorP();
            if ((double)this.m_center_x < point[0]) {
                this.setFocalLength(old_length);
                this.setMirrorP();
            }
        }
        if (this.m_op_hit && (double)((int)((double)x - this.m_shift)) > (point = this.m_scene.getObjectPoint())[0]) {
            this.m_center_x = (int)((double)x - this.m_shift);
            this.setMirrorP();
        }
        return false;
    }

    public void setMirrorP() {
        this.m_start_angle = Math.PI + Math.asin(this.m_height / ((double)-2 * this.m_focal_length));
        this.m_angle = (double)2 * Math.asin(this.m_height / ((double)2 * this.m_focal_length));
        int s1 = (int)((double)this.m_center_x + this.m_shift);
        this.m_shift = this.m_focal_length + this.m_focal_length * Math.cos(this.m_start_angle);
        int s2 = (int)((double)this.m_center_x + this.m_shift);
        this.m_center_x -= s2 - s1;
        this.m_start_angle1 = Math.asin(this.m_height / ((double)2 * this.m_focal_length));
        this.m_fp1_x = (int)((double)this.m_center_x - this.m_focal_length + this.m_shift);
        this.m_fp2_x = (int)((double)this.m_center_x + this.m_focal_length + this.m_shift);
        this.m_fp3_x = (int)((double)this.m_center_x - (double)2 * this.m_focal_length + this.m_shift);
        this.m_fp4_x = (int)((double)this.m_center_x + (double)2 * this.m_focal_length + this.m_shift);
        this.m_origin_x = (int)((double)this.m_center_x + this.m_shift);
    }

    public double[] getOrigin() {
        this.m_coord[0] = this.m_origin_x;
        this.m_coord[1] = this.m_center_y;
        return this.m_coord;
    }

    public double[] getFocalPoint(int which) {
        if (which == 0) {
            this.m_coord[0] = this.m_fp1_x;
            this.m_coord[1] = this.m_center_y;
        } else {
            this.m_coord[0] = this.m_fp2_x;
            this.m_coord[1] = this.m_center_y;
        }
        return this.m_coord;
    }

    public int getLensTop() {
        return (int)((double)this.m_center_y - this.m_height);
    }

    public int getLensBottom() {
        return (int)((double)this.m_center_y + this.m_height);
    }

    public int getLensStartX() {
        return this.m_center_x;
    }
}

