/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AObj41
extends AObject41 {
    protected AScene41 m_scene;
    protected int m_x;
    protected int m_y;
    protected int m_height;
    protected int m_arrow_height = 10;
    protected int m_width = 2;
    protected int[] m_arrowX = new int[]{0, 0, 0};
    protected int[] m_arrowY = new int[]{0, 0, 0};
    protected int m_point_radius = 3;

    public AObj41(AScene41 scene, int x, int y, int height) {
        this.m_scene = scene;
        this.m_x = x;
        this.m_y = y;
        this.m_height = height;
        this.setObject();
    }

    public void paint(Graphics g) {
        g.setColor(Color.blue);
        if (this.m_height >= 0) {
            g.fillRect(this.m_x - this.m_width, this.m_y - this.m_height + this.m_arrow_height, 2 * this.m_width, this.m_height - this.m_arrow_height);
        } else {
            g.fillRect(this.m_x - this.m_width, this.m_y, 2 * this.m_width, -this.m_height - this.m_arrow_height);
        }
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(this.m_color_black);
        if (this.m_height >= 0) {
            g.drawString("x", this.m_x - this.m_width, this.m_y + 20);
        } else {
            g.drawString("x", this.m_x - this.m_width, this.m_y - 10);
        }
        g.setColor(this.m_cyan_color);
        g.fillOval(this.m_arrowX[1] - this.m_point_radius, this.m_arrowY[1] - this.m_point_radius, 2 * this.m_point_radius, 2 * this.m_point_radius);
        g.setColor(this.m_color_black);
        g.drawOval(this.m_arrowX[1] - this.m_point_radius, this.m_arrowY[1] - this.m_point_radius, 2 * this.m_point_radius, 2 * this.m_point_radius);
    }

    public boolean onMouseDown(int x, int y) {
        if (this.isObjectPoint(x, y)) {
            this.m_op_hit = true;
        }
        return false;
    }

    public boolean onMouseUp(int x, int y) {
        this.m_op_hit = false;
        return false;
    }

    public boolean onMouseMove(int x, int y) {
        return this.isObjectPoint(x, y);
    }

    public boolean onMouseDrag(int x, int y) {
        if (this.m_op_hit) {
            if (x < this.m_scene.getOpticsStartX()) {
                if (x > AScene41.getLeftX()) {
                    this.m_x = x;
                }
            }
            if (y > AScene41.getUpperY()) {
                if (y < AScene41.getLowerY()) {
                    this.m_height = this.m_y - y;
                }
            }
            this.setObject();
        }
        return false;
    }

    public boolean isObjectPoint(int x, int y) {
        return Math.pow(x - this.m_x, 2.0) + Math.pow(y - (this.m_y - this.m_height), 2.0) <= (double)this.m_point_radius;
    }

    public void setX(int x) {
        this.m_x = x;
        this.setObject();
    }

    public int getX() {
        return this.m_x;
    }

    public void setHeight(int height) {
        this.m_height = height;
        this.setObject();
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setObject() {
        if (this.m_height >= 0) {
            this.m_arrowX[0] = this.m_x - this.m_width - 3;
            this.m_arrowX[1] = this.m_x;
            this.m_arrowX[2] = this.m_x + this.m_width + 3;
            this.m_arrowY[0] = this.m_y - this.m_height + this.m_arrow_height;
            this.m_arrowY[1] = this.m_y - this.m_height;
            this.m_arrowY[2] = this.m_y - this.m_height + this.m_arrow_height;
        } else {
            this.m_arrowX[0] = this.m_x - this.m_width - 3;
            this.m_arrowX[1] = this.m_x;
            this.m_arrowX[2] = this.m_x + this.m_width + 3;
            this.m_arrowY[0] = this.m_y - this.m_height - this.m_arrow_height;
            this.m_arrowY[1] = this.m_y - this.m_height;
            this.m_arrowY[2] = this.m_y - this.m_height - this.m_arrow_height;
        }
    }

    public double[] getObjectPoint() {
        this.m_coord[0] = this.m_x;
        this.m_coord[1] = this.m_y - this.m_height;
        return this.m_coord;
    }
}

