/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ARbGroup;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim41
extends Applet
implements Runnable {
    final int LENSE_C = 0;
    final int LENSE_D = 1;
    final int MIRROR_C = 2;
    final int MIRROR_D = 3;
    final int MIRROR_P = 4;
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Color m_color_white = new Color(255, 255, 255);
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_red = new Color(255, 0, 0);
    protected Color m_color_green = new Color(0, 100, 0);
    protected Image m_rbImage = null;
    protected ARbGroup m_rb_group;
    protected AScene41 m_scene;

    public void init() {
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_rbImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_rbImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_rbImage, 7);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_rb_group = new ARbGroup(this.m_rbImage, 40, 280, 13, 20, 5, 0, 1);
        this.m_scene = new AScene41(2, 7, 501, 7, 256);
    }

    public void run() {
        while (this.m_thread == Thread.currentThread()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        } else {
            System.out.println("Null graphics");
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.m_bkImage, 0, 0, null);
        this.m_scene.paint(g);
        this.paintPatch(g, this.m_color_white, 7, 259, 495, 134);
        this.m_rb_group.paint(g);
        this.paintStuff(g);
    }

    public boolean mouseUp(Event event, int x, int y) {
        this.m_scene.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        this.m_scene.onMouseDown(x, y);
        if (this.m_rb_group.onMouseDown(x, y)) {
            int result = this.m_rb_group.getActiveButton();
            switch (result) {
                case 0: {
                    this.m_scene = new AScene41(2, 7, 501, 7, 256);
                    break;
                }
                case 1: {
                    this.m_scene = new AScene41(3, 7, 501, 7, 256);
                    break;
                }
                case 2: {
                    this.m_scene = new AScene41(4, 7, 501, 7, 256);
                    break;
                }
                case 3: {
                    this.m_scene = new AScene41(0, 7, 501, 7, 256);
                    break;
                }
                case 4: {
                    this.m_scene = new AScene41(1, 7, 501, 7, 256);
                }
            }
        }
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        if (!this.m_scene.onMouseMove(x, y)) {
            // empty if block
        }
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        this.m_scene.onMouseDrag(x, y);
        return false;
    }

    public static String cutDouble(String value) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + 1) {
            return value.substring(0, index + 2);
        }
        return value;
    }

    protected void paintStuff(Graphics g) {
        g.setColor(this.m_color_black);
        g.drawString("Concave mirror", 60, 292);
        g.drawString("Convex mirror", 60, 312);
        g.drawString("Plane mirror", 60, 332);
        g.drawString("Converging lens", 60, 352);
        g.drawString("Diverging lens", 60, 372);
        g.drawString("Focal length (cm): ", 280, 292);
        g.drawString("Object distance, x(cm): ", 280, 312);
        g.drawString("Object height (cm): ", 280, 332);
        g.drawString("Image distance, x'(cm): ", 280, 352);
        g.drawString("Image height (cm): ", 280, 372);
        g.setColor(this.m_color_red);
        double length = this.m_scene.getFocalLengthA();
        if (length < (double)10000) {
            g.drawString(ASim41.cutDouble(this.m_scene.getFocalLength()), 420, 292);
        } else {
            g.drawString("Infinity", 420, 292);
        }
        g.setColor(Color.blue);
        g.drawString(ASim41.cutDouble(this.m_scene.getObjectDistance()), 420, 312);
        g.drawString(ASim41.cutDouble(this.m_scene.getObjectHeight()), 420, 332);
        g.setColor(this.m_color_black);
        g.drawString(ASim41.cutDouble(this.m_scene.getImageDistance()), 420, 352);
        g.drawString(ASim41.cutDouble(this.m_scene.getImageHeight()), 420, 372);
    }

    protected void paintPatch(Graphics g, Color color, int x, int y, int width, int height) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
        g.setColor(this.m_color_black);
        g.drawRect(x, y, width, height);
    }
}

