/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AGraph40 {
    protected int m_start_x;
    protected int m_start_y;
    protected double m_step_x;
    protected double m_step_y;
    protected double m_max_x;
    protected int m_x_axis_length;
    protected int m_bottom_line = 246;
    protected int m_down_shift = 120;
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_red = new Color(255, 0, 0);
    protected Color m_color_blue = new Color(0, 0, 255);
    protected Color m_color_green = new Color(0, 150, 0);
    protected Color m_color_yellow = new Color(255, 200, 0);
    protected double m_Vmax = 50.0;
    protected double m_f = 60.0;
    protected double m_w;
    protected double m_V;
    protected double m_C = 2.5E-4;
    protected double m_L = 0.02;
    protected double m_R = 10.0;
    protected double m_XC;
    protected double m_XL;
    protected double m_Z;
    protected double m_phase;
    protected double m_I;

    public AGraph40(int x, int y, double step_x, double step_y, double max_x) {
        this.m_start_x = x;
        this.m_start_y = y;
        this.m_step_x = step_x;
        this.m_step_y = step_y;
        this.m_max_x = max_x;
        this.m_x_axis_length = (int)(this.m_max_x / this.m_step_x);
    }

    public void paint(Graphics g) {
        this.paintGraph1(g);
        this.paintDiagram(g, 410, 120);
    }

    public void paintGraph1(Graphics g) {
        block8: {
            double arg1 = this.m_Vmax;
            double arg3 = 0.0;
            g.setColor(this.m_color_red);
            for (int count = 0; count < this.m_x_axis_length; ++count) {
                double arg2 = (double)count * this.m_step_x;
                arg1 = this.m_Vmax;
                arg3 = 0.0;
                g.setColor(this.m_color_red);
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 0.6666666666666666), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 0.6666666666666666));
                }
                arg1 = this.m_Vmax / this.m_Z;
                arg3 = -this.m_phase;
                g.setColor(this.m_color_blue);
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 3.0), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 3.0));
                }
                this.m_start_y += this.m_down_shift;
                arg1 = this.m_R * this.m_Vmax / this.m_Z;
                arg3 = -this.m_phase;
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 0.6666666666666666), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 0.6666666666666666));
                }
                arg1 = this.m_XL * this.m_Vmax / this.m_Z;
                arg3 = -this.m_phase + 1.5707963267948966;
                g.setColor(this.m_color_yellow);
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 0.6666666666666666), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 0.6666666666666666));
                }
                arg1 = this.m_XC * this.m_Vmax / this.m_Z;
                arg3 = -this.m_phase - 1.5707963267948966;
                g.setColor(this.m_color_green);
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 0.6666666666666666), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 0.6666666666666666));
                }
                arg1 = this.m_Vmax;
                arg3 = 0.0;
                g.setColor(this.m_color_red);
                if (count > 0) {
                    g.drawLine(this.m_start_x + count - 1, this.m_start_y - (int)this.getFunctionValue(arg1, arg2 - this.m_step_x, arg3, 0.6666666666666666), this.m_start_x + count, this.m_start_y - (int)this.getFunctionValue(arg1, arg2, arg3, 0.6666666666666666));
                }
                this.m_start_y -= this.m_down_shift;
            }
            g.setColor(this.m_color_black);
            if (this.m_phase > 0.0) {
                g.drawString("Voltage leads the current", this.m_start_x + 20, this.m_start_y + 60);
            }
            if (!(this.m_phase < 0.0)) break block8;
            g.drawString("Voltage lags the current", this.m_start_x + 20, this.m_start_y + 60);
        }
    }

    protected void paintDiagram(Graphics g, int x, int y) {
        g.setColor(this.m_color_yellow);
        g.drawLine(x, y, x, y - 4 * (int)this.m_XL);
        g.drawString("XL", x, y - 4 * (int)this.m_XL - 2);
        g.drawLine(x, y - 4 * (int)this.m_XL, x - 4, y - 4 * (int)this.m_XL + 8);
        g.drawLine(x, y - 4 * (int)this.m_XL, x + 4, y - 4 * (int)this.m_XL + 8);
        g.setColor(this.m_color_green);
        g.drawLine(x, y, x, y + 4 * (int)this.m_XC);
        g.drawString("XC", x, y + 4 * (int)this.m_XC + 12);
        g.drawLine(x, y + 4 * (int)this.m_XC, x - 4, y + 4 * (int)this.m_XC - 8);
        g.drawLine(x, y + 4 * (int)this.m_XC, x + 4, y + 4 * (int)this.m_XC - 8);
        g.setColor(this.m_color_blue);
        g.drawLine(x, y, x + 4 * (int)this.m_R, y);
        g.drawString("R", x + 4 * (int)this.m_R - 10, y - 5);
        g.drawLine(x + 4 * (int)this.m_R, y, x + 4 * (int)this.m_R - 8, y + 4);
        g.drawLine(x + 4 * (int)this.m_R, y, x + 4 * (int)this.m_R - 8, y - 4);
        g.setColor(this.m_color_black);
        g.drawLine(x, y, x + 4 * (int)this.m_R, y + 4 * (int)(this.m_XC - this.m_XL));
        double angle = Math.atan((this.m_XC - this.m_XL) / this.m_R);
        int x1 = x + 4 * (int)this.m_R;
        int y1 = y + 4 * (int)(this.m_XC - this.m_XL);
        int r = 9;
        int x2 = (int)((double)x1 - (double)r * Math.cos(angle - 0.5235987755982988));
        int x3 = (int)((double)x1 - (double)r * Math.cos(angle + 0.5235987755982988));
        int y2 = (int)((double)y1 - (double)r * Math.sin(angle - 0.5235987755982988));
        int y3 = (int)((double)y1 - (double)r * Math.sin(angle + 0.5235987755982988));
        if (angle > 0.0) {
            g.drawString("Z", x + 4 * (int)this.m_R - 10, y + 4 * (int)(this.m_XC - this.m_XL) + 12);
        } else {
            g.drawString("Z", x + 4 * (int)this.m_R - 10, y + 4 * (int)(this.m_XC - this.m_XL) - 8);
        }
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x1, y1, x3, y3);
    }

    public void setGraph() {
        this.m_w = Math.PI * 2 * this.m_f;
        this.m_XC = 1.0 / (this.m_w * this.m_C);
        this.m_XL = this.m_w * this.m_L;
        double a = Math.pow(this.m_XL - this.m_XC, 2.0);
        double b = Math.pow(this.m_R, 2.0);
        this.m_Z = Math.pow(a + b, 0.5);
        a = (this.m_XL - this.m_XC) / this.m_R;
        this.m_phase = Math.atan(a);
    }

    public void setFrequency(int freq) {
        this.m_f = freq;
    }

    public void setResistance(int res) {
        this.m_R = res;
    }

    public void setCapacity(int cap) {
        this.m_C = (double)cap / 1000000.0;
    }

    public void setInductance(int ind) {
        this.m_L = (double)ind / 1000.0;
    }

    protected double getFunctionValue(double arg1, double arg2, double arg3, double coef) {
        return arg1 * Math.sin(arg2 * this.m_w + arg3) * coef;
    }

    public double getMaxCurrent() {
        return this.m_Vmax / this.m_Z;
    }

    protected double getXC() {
        return this.m_XC;
    }

    protected double getXL() {
        return this.m_XL;
    }

    protected double getZ() {
        return this.m_Z;
    }

    protected double getPhaseAngle() {
        return this.m_phase;
    }
}

