/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ASlider;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim40
extends Applet
implements Runnable {
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Image m_sliderImage = null;
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_red = new Color(255, 0, 0);
    protected Color m_color_blue = new Color(0, 0, 255);
    protected Color m_color_green = new Color(0, 150, 0);
    protected Color m_color_yellow = new Color(255, 200, 0);
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    protected ASlider m_slider3;
    protected ASlider m_slider4;
    protected AGraph40 m_graph1;

    public void init() {
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_sliderImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_sliderImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_sliderImage, 1);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_slider1 = new ASlider(this.m_sliderImage, 10, 247, 250, 12, 40, 120, 60);
        this.m_slider2 = new ASlider(this.m_sliderImage, 10, 289, 250, 12, 3, 20, 10);
        this.m_slider3 = new ASlider(this.m_sliderImage, 10, 331, 250, 12, 150, 400, 250);
        this.m_slider4 = new ASlider(this.m_sliderImage, 10, 370, 250, 12, 10, 25, 20);
        this.m_graph1 = new AGraph40(170, 65, 2.0E-4, 2.0E-4, 0.04);
        this.m_graph1.setGraph();
    }

    public void run() {
        while (this.m_thread == Thread.currentThread()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        } else {
            System.out.println("Null graphics");
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.m_bkImage, 0, 0, null);
        this.m_graph1.paint(g);
        this.m_slider1.paint(g);
        this.m_slider2.paint(g);
        this.m_slider3.paint(g);
        this.m_slider4.paint(g);
        this.paintStuff(g);
    }

    public boolean mouseUp(Event event, int x, int y) {
        this.m_slider1.onMouseUp(x, y);
        this.m_slider2.onMouseUp(x, y);
        this.m_slider3.onMouseUp(x, y);
        this.m_slider4.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        this.m_slider1.onMouseDown(x, y);
        this.m_slider2.onMouseDown(x, y);
        this.m_slider3.onMouseDown(x, y);
        this.m_slider4.onMouseDown(x, y);
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        this.m_slider1.onMouseMove(x, y);
        this.m_slider2.onMouseMove(x, y);
        this.m_slider3.onMouseMove(x, y);
        this.m_slider4.onMouseMove(x, y);
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        if (this.m_slider1.onMouseDrag(x, y)) {
            this.m_graph1.setFrequency(this.m_slider1.getCurrentValue());
            this.m_graph1.setGraph();
        }
        if (this.m_slider2.onMouseDrag(x, y)) {
            this.m_graph1.setResistance(this.m_slider2.getCurrentValue());
            this.m_graph1.setGraph();
        }
        if (this.m_slider3.onMouseDrag(x, y)) {
            this.m_graph1.setCapacity(this.m_slider3.getCurrentValue());
            this.m_graph1.setGraph();
        }
        if (this.m_slider4.onMouseDrag(x, y)) {
            this.m_graph1.setInductance(this.m_slider4.getCurrentValue());
            this.m_graph1.setGraph();
        }
        return false;
    }

    public static String cutDouble(String value) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + 2) {
            return value.substring(0, index + 3);
        }
        return value;
    }

    protected void paintStuff(Graphics g) {
        g.setColor(this.m_color_black);
        g.drawString(String.valueOf(this.m_slider1.getCurrentValue()), this.m_slider1.getX(), 242);
        g.setColor(this.m_color_blue);
        g.drawString(String.valueOf(this.m_slider2.getCurrentValue()), this.m_slider2.getX(), 284);
        g.setColor(this.m_color_green);
        g.drawString(String.valueOf(this.m_slider3.getCurrentValue()), this.m_slider3.getX(), 326);
        g.setColor(this.m_color_yellow);
        g.drawString(String.valueOf(this.m_slider4.getCurrentValue()), this.m_slider4.getX(), 365);
        g.setColor(this.m_color_red);
        g.drawString("Maximum voltage = 50.0 V", 310, 268);
        g.setColor(this.m_color_blue);
        g.drawString(String.valueOf(String.valueOf("Maximum current = ").concat(String.valueOf(ASim40.cutDouble(String.valueOf(this.m_graph1.getMaxCurrent()))))).concat(String.valueOf(" A")), 310, 288);
        g.setColor(this.m_color_green);
        g.drawString(String.valueOf(String.valueOf("XC = ").concat(String.valueOf(ASim40.cutDouble(String.valueOf(this.m_graph1.getXC()))))).concat(String.valueOf(" ohms")), 310, 308);
        g.setColor(this.m_color_yellow);
        g.drawString(String.valueOf(String.valueOf("XL = ").concat(String.valueOf(ASim40.cutDouble(String.valueOf(this.m_graph1.getXL()))))).concat(String.valueOf(" ohms")), 310, 328);
        g.setColor(this.m_color_black);
        g.drawString(String.valueOf(String.valueOf("Z = ").concat(String.valueOf(ASim40.cutDouble(String.valueOf(this.m_graph1.getZ()))))).concat(String.valueOf(" ohms")), 310, 348);
        g.drawString(String.valueOf(String.valueOf("Phase angle = ").concat(String.valueOf(ASim40.cutDouble(String.valueOf(this.toDegrees(this.m_graph1.getPhaseAngle())))))).concat(String.valueOf(" degrees")), 310, 368);
    }

    public double toDegrees(double angle) {
        double coef = Math.PI / 180;
        return angle / coef;
    }
}

