/*
 * Decompiled with CFR 0.152.
 */
import com.maris.awt.RadioButtons;
import com.maris.awt.Slider;
import com.maris.awt.zImageButton;
import com.maris.util.AnimationImage;
import com.maris.util.zITimerListener;
import com.maris.util.zTimer;
import com.maris.util.zUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;

public class Sim39
extends Applet
implements Runnable,
zITimerListener {
    protected Color m_stringColor = null;
    protected Thread m_loadData = null;
    protected Graphics m_gr = null;
    private Graphics backGC = null;
    private Image backBuffer = null;
    protected int m_loadProgress = 0;
    private Image m_bgImage = null;
    private Image m_sliderImage = null;
    private Image m_rbImage = null;
    private Image m_animCapacImage = null;
    private Image m_animInducImage = null;
    private Image m_animbarImage = null;
    private Image m_cirelemsImage = null;
    private Slider m_sdFreq = null;
    private Slider m_sdElem = null;
    private RadioButtons m_rbElem = null;
    private Component m_btRes = null;
    private Component m_btCup = null;
    private Component m_btInd = null;
    private AnimationImage m_aiCapac = null;
    private AnimationImage m_aiInduc = null;
    private static final int T0 = 314;
    private static final int V0 = 76;
    private static final int I0 = 196;
    private static final int graphLen = 160;
    private static final double maxTime = 0.04;
    private static final double deltat = 2.5E-4;
    private static final double factorI = 4.0;
    private static final double factorU = 1.0;
    private static final Color m_colorV = new Color(255, 0, 0);
    private static final Color m_colorI = new Color(0, 0, 255);
    private int appWidth;
    private int appHeight;
    private Font font12 = null;
    private Font font10 = null;
    private int[] m_T = new int[160];
    private int[] m_V = new int[160];
    private int[] m_I = new int[160];
    private double m_freq = 60.0;
    private double m_res = 15.0;
    private double m_cap = 200.0;
    private double m_ind = 30.0;
    private static final Point barOrg = new Point(143, 206);
    private static final int barW = 26;
    private static final double barFactorV = 0.64;
    private static final double barFactorI = 3.2;
    private static final double timeStep = 0.1;
    private double m_currTime = 0.0;
    private double m_currVlt = 0.0;
    private double m_currCur = 0.0;
    private double m_currW = Math.PI * 2 * this.m_freq;
    private double m_maxI = 0.0;
    private zTimer timer = null;
    private String m_mediaBase = null;

    private synchronized void newBackBuffer() {
        this.backBuffer = this.getParent().createImage(this.appWidth, this.appHeight);
        if (zUtil.sysIsMacOS() && zUtil.sysIsNetscape()) {
            this.font12 = new Font("Arial", 0, 11);
            this.font10 = new Font("Arial", 0, 9);
        } else {
            this.font12 = new Font("Arial", 0, 12);
            this.font10 = new Font("Arial", 0, 10);
        }
        if (this.backBuffer != null) {
            this.backGC = this.backBuffer.getGraphics();
            return;
        }
        this.backGC = this.getGraphics();
    }

    public void paint(Graphics graphics) {
        if (this.backBuffer != null) {
            this.backGC.drawImage(this.m_bgImage, 0, 0, this);
            this.backGC.setFont(this.font12);
            this.backGC.setColor(Color.black);
            this.backGC.drawString(String.valueOf(Math.round(this.m_freq)), 264, 268);
            this.backGC.drawString(zUtil.formatDouble((double)this.m_maxI, (int)2), 212, 129);
            switch (this.m_rbElem.GetActiveIndex()) {
                case 0: {
                    zUtil.drawImage((Graphics)this.backGC, (Image)this.m_cirelemsImage, (int)106, (int)29, (int)131, (int)89, (int)0, (int)0, (int)25, (int)60);
                    this.backGC.drawString(String.valueOf(Math.round(this.m_res)), 432, 268);
                    this.backGC.drawString("Resistance", 358, 268);
                    this.backGC.drawString("ohms", 461, 268);
                    this.backGC.setFont(this.font10);
                    this.backGC.drawString("5", 343, 281);
                    this.backGC.drawString("30", 490, 281);
                    this.backGC.setColor(Color.white);
                    this.backGC.fillRect(204, 190, 54, 31);
                    break;
                }
                case 1: {
                    this.backGC.drawString(zUtil.formatDouble((double)this.m_currTime, (int)1), 207, 218);
                    zUtil.drawImage((Graphics)this.backGC, (Image)this.m_cirelemsImage, (int)106, (int)29, (int)131, (int)89, (int)25, (int)0, (int)50, (int)60);
                    this.backGC.drawString(String.valueOf(Math.round(this.m_ind)), 432, 268);
                    this.backGC.drawString("Inductance", 359, 268);
                    this.backGC.drawString("mH", 461, 268);
                    this.backGC.setFont(this.font10);
                    this.backGC.drawString("20", 340, 281);
                    this.backGC.drawString("40", 490, 281);
                    zUtil.drawImage((Graphics)this.backGC, (Image)this.m_animbarImage, (int)122, (int)173, (int)184, (int)239, (int)62, (int)0, (int)124, (int)66);
                    this.backGC.setColor(m_colorI);
                    this.drawBar(this.backGC, (int)Math.round(this.m_currCur * 3.2));
                    this.m_aiInduc.draw(this.backGC);
                    break;
                }
                case 2: {
                    this.backGC.drawString(zUtil.formatDouble((double)this.m_currTime, (int)1), 207, 218);
                    zUtil.drawImage((Graphics)this.backGC, (Image)this.m_cirelemsImage, (int)106, (int)29, (int)131, (int)89, (int)50, (int)0, (int)75, (int)60);
                    this.backGC.drawString(String.valueOf(Math.round(this.m_cap)), 428, 268);
                    this.backGC.drawString("Capacitance", 351, 268);
                    this.backGC.drawString("\u00b5F", 461, 268);
                    this.backGC.setFont(this.font10);
                    this.backGC.drawString("100", 339, 281);
                    this.backGC.drawString("300", 484, 281);
                    zUtil.drawImage((Graphics)this.backGC, (Image)this.m_animbarImage, (int)122, (int)173, (int)184, (int)239, (int)0, (int)0, (int)62, (int)66);
                    this.backGC.setColor(m_colorV);
                    this.drawBar(this.backGC, (int)Math.round(this.m_currVlt * 0.64));
                    this.m_aiCapac.draw(this.backGC);
                }
            }
            this.backGC.setColor(m_colorV);
            zUtil.drawPolyline((Graphics)this.backGC, (int[])this.m_T, (int[])this.m_V, (int)160);
            this.backGC.setColor(m_colorI);
            zUtil.drawPolyline((Graphics)this.backGC, (int[])this.m_T, (int[])this.m_I, (int)160);
            this.m_sdFreq.draw(this.backGC);
            this.m_sdElem.draw(this.backGC);
            graphics.drawImage(this.backBuffer, 0, 0, this);
            return;
        }
        graphics.setColor(this.m_stringColor);
        String string = "Loading media";
        int n = 0;
        while (n < this.m_loadProgress) {
            string = string + " .";
            ++n;
        }
        graphics.drawRect(0, 0, this.appWidth - 1, this.appHeight - 1);
        graphics.drawString(string, 20, 20);
    }

    protected void SetState() {
        double d = 0.0;
        switch (this.m_rbElem.GetActiveIndex()) {
            case 0: {
                this.m_maxI = 50.0 / this.m_res;
                int n = 0;
                do {
                    double d2 = this.m_currW * d;
                    this.m_V[n] = 76 - (int)Math.round(50.0 * Math.sin(d2) * 1.0);
                    this.m_I[n] = 196 - (int)Math.round(this.m_maxI * Math.sin(d2) * 4.0);
                    d += 2.5E-4;
                } while (++n < 160);
                return;
            }
            case 1: {
                this.m_maxI = 50.0 / (this.m_currW * this.m_ind * 0.001);
                int n = 0;
                do {
                    double d3 = this.m_currW * d;
                    this.m_V[n] = 76 - (int)Math.round(50.0 * Math.sin(d3) * 1.0);
                    this.m_I[n] = 196 - (int)Math.round(this.m_maxI * Math.sin(d3 - 1.5707963267948966) * 4.0);
                    d += 2.5E-4;
                } while (++n < 160);
                return;
            }
            case 2: {
                this.m_maxI = 50.0 * this.m_currW * this.m_cap * 1.0E-6;
                int n = 0;
                do {
                    double d4 = this.m_currW * d;
                    this.m_V[n] = 76 - (int)Math.round(50.0 * Math.sin(d4) * 1.0);
                    this.m_I[n] = 196 - (int)Math.round(this.m_maxI * Math.sin(d4 + 1.5707963267948966) * 4.0);
                    d += 2.5E-4;
                } while (++n < 160);
                return;
            }
        }
    }

    protected boolean IsChangeCursor(zImageButton zImageButton2, int n, int n2) {
        Point point = zImageButton2.location();
        return zImageButton2.isEnabled() && zImageButton2.inside(n - point.x, n2 - point.y);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return this.mouseMove(event, n, n2);
    }

    protected boolean IsChangeCursor(Slider slider, int n, int n2) {
        return slider.isEnabled() && slider.inside(n, n2);
    }

    protected boolean IsChangeCursor(RadioButtons radioButtons, int n, int n2) {
        return radioButtons.isEnabled() && radioButtons.inside();
    }

    public void destroy() {
        this.removeAll();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.m_loadData = null;
        this.m_stringColor = null;
        this.m_loadData = null;
        this.m_gr = null;
        this.backGC = null;
        this.backBuffer = null;
        this.m_bgImage = null;
        this.m_sliderImage = null;
        this.m_rbImage = null;
        this.m_animCapacImage = null;
        this.m_animInducImage = null;
        this.m_animbarImage = null;
        this.m_cirelemsImage = null;
        this.m_aiCapac = null;
        this.m_aiInduc = null;
        this.m_sdFreq = null;
        this.m_sdElem = null;
        this.m_rbElem = null;
        this.m_btRes = null;
        this.m_btCup = null;
        this.m_btInd = null;
        this.font12 = null;
        this.font10 = null;
        this.m_T = null;
        this.m_V = null;
        this.m_I = null;
        this.timer = null;
        this.m_mediaBase = null;
    }

    private void CalcStep() {
        double d = this.m_currW * this.m_currTime * 0.001;
        this.m_currVlt = 50.0 * Math.sin(d);
        this.m_currCur = this.m_maxI * Math.sin(d - 1.5707963267948966);
        this.m_aiCapac.setFrame((int)Math.round(18.0 * ((this.m_currVlt * this.m_cap - 15000.0) / -30000.0)));
        this.m_aiInduc.setFrame((int)Math.round(18.0 * ((this.m_currCur - 9.94) / -19.8)));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void timerAction(zTimer zTimer2) {
        this.m_currTime += 0.1;
        if (this.m_currTime > 99.9) {
            this.m_currTime = 0.0;
        }
        this.CalcStep();
        this.repaint();
    }

    public boolean action(Event event, Object object) {
        if (this.m_sdFreq == object) {
            this.m_freq = Math.round(((Slider)object).getAbsolutPosition());
            this.m_currW = Math.PI * 2 * this.m_freq;
            this.m_currTime = 0.0;
            this.SetState();
            this.CalcStep();
            this.repaint();
        } else if (this.m_sdElem == object) {
            switch (this.m_rbElem.GetActiveIndex()) {
                case 0: {
                    this.m_res = Math.round(((Slider)object).getAbsolutPosition());
                    break;
                }
                case 1: {
                    this.m_ind = Math.round(((Slider)object).getAbsolutPosition());
                    break;
                }
                case 2: {
                    this.m_cap = Math.round(((Slider)object).getAbsolutPosition());
                }
            }
            this.m_currTime = 0.0;
            this.SetState();
            this.CalcStep();
            this.repaint();
        } else if (this.m_btRes == object) {
            this.m_currTime = 0.0;
            this.m_sdElem.setRange(5.0, 30.0);
            this.m_sdElem.setNumberSteps(25L);
            this.m_sdElem.setAbsolutPosition(this.m_res);
            this.SetState();
            this.CalcStep();
            this.repaint();
        } else if (this.m_btCup == object) {
            this.m_currTime = 0.0;
            this.m_sdElem.setRange(100.0, 300.0);
            this.m_sdElem.setNumberSteps(100L);
            this.m_sdElem.setAbsolutPosition(this.m_cap);
            this.SetState();
            this.CalcStep();
            this.repaint();
        } else if (this.m_btInd == object) {
            this.m_currTime = 0.0;
            this.m_sdElem.setRange(20.0, 40.0);
            this.m_sdElem.setNumberSteps(20L);
            this.m_sdElem.setAbsolutPosition(this.m_ind);
            this.SetState();
            this.CalcStep();
            this.repaint();
        }
        return true;
    }

    private void drawBar(Graphics graphics, int n) {
        if (n > 0) {
            this.backGC.fillRect(Sim39.barOrg.x, Sim39.barOrg.y - n, 26, n);
            return;
        }
        this.backGC.fillRect(Sim39.barOrg.x, Sim39.barOrg.y, 26, -n);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdFreq.mouseDown(n, n2);
            this.m_sdElem.mouseDown(n, n2);
        }
        return true;
    }

    public void run() {
        this.m_loadProgress = 0;
        this.m_bgImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file1")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_sliderImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file2")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_rbImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file3")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_animCapacImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file4")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_aiCapac = new AnimationImage(this.m_animCapacImage, 66, (Container)this);
        this.m_aiCapac.setPosition(40, 173);
        this.m_aiCapac.setFrame(9);
        this.m_animInducImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file5")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_aiInduc = new AnimationImage(this.m_animInducImage, 66, (Container)this);
        this.m_aiInduc.setPosition(40, 173);
        this.m_aiInduc.setFrame(9);
        this.m_animbarImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file6")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_cirelemsImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file7")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_sdFreq = new Slider(this.m_sliderImage, 178, 288, 328, 288, 60L, 40.0, 100.0, (Container)this);
        this.m_sdFreq.setAbsolutPosition(this.m_freq);
        this.m_sdFreq.show();
        this.m_sdElem = new Slider(this.m_sliderImage, 345, 288, 495, 288, 25L, 5.0, 30.0, (Container)this);
        this.m_sdElem.setAbsolutPosition(this.m_res);
        this.m_sdElem.show();
        this.m_rbElem = new RadioButtons();
        this.m_btRes = this.m_rbElem.Add(this.m_rbImage, 9, 252, (Container)this);
        this.m_btInd = this.m_rbElem.Add(this.m_rbImage, 9, 282, (Container)this);
        this.m_btCup = this.m_rbElem.Add(this.m_rbImage, 9, 267, (Container)this);
        this.m_rbElem.hide();
        this.m_rbElem.SetActive(this.m_btRes);
        this.SetState();
        this.newBackBuffer();
        if (zUtil.sysIsMacOS()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.repaint();
        this.m_rbElem.show();
        this.timer = new zTimer((zITimerListener)this, 100L);
        this.timer.start();
    }

    public void init() {
        Color color;
        this.setLayout(null);
        this.appHeight = this.size().height;
        this.appWidth = this.size().width;
        this.m_gr = this.getGraphics();
        String string = this.getParameter("background");
        if (string != null && (color = zUtil.parseHTMLColor((String)string)) != null) {
            this.setBackground(color);
            this.m_stringColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        this.m_mediaBase = this.getParameter("mediabase");
        if (this.m_mediaBase == null) {
            this.m_mediaBase = "";
        }
        int n = 0;
        do {
            this.m_T[n] = 314 + n;
        } while (++n < 160);
        this.m_loadData = new Thread(this);
        this.m_loadData.start();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdFreq.mouseDrag(n, n2);
            this.m_sdElem.mouseDrag(n, n2);
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdFreq.mouseMove(n, n2);
            this.m_sdElem.mouseMove(n, n2);
            Container container = this.getParent();
            if (container instanceof Frame) {
                if (this.IsChangeCursor(this.m_sdFreq, n, n2) || this.IsChangeCursor(this.m_sdElem, n, n2) || this.IsChangeCursor(this.m_rbElem, n, n2)) {
                    ((Frame)container).setCursor(12);
                } else {
                    ((Frame)container).setCursor(0);
                }
            }
        }
        return true;
    }
}

