/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class ABar {
    protected AScene21 m_scene;
    protected int m_x0;
    protected int m_y0;
    protected int m_x1;
    protected int m_y1;
    protected int m_x2;
    protected int m_y2;
    protected int X1;
    protected int X2;
    protected int X3;
    protected int X4;
    protected int Y1;
    protected int Y2;
    protected int Y3;
    protected int Y4;
    protected int[] m_x_array = new int[4];
    protected int[] m_y_array = new int[4];
    protected double m_time;
    protected int m_length;
    protected double m_radius1;
    protected double m_radius2;
    protected int m_coef = 25;
    protected int m_width = 5;
    protected double m_angle;
    protected double m_velocity;
    protected Color m_color = new Color(128, 128, 128);

    public ABar(AScene21 scene, int x, int y, int length, int radius1, int radius2) {
        this.m_scene = scene;
        this.m_time = 0.0;
        this.m_angle = 0.0;
        this.m_x0 = x;
        this.m_y0 = y;
        this.m_length = length;
        this.m_radius1 = radius1;
        this.m_radius2 = radius2;
    }

    public void paint(Graphics g) {
        g.setColor(this.m_color);
        g.fillPolygon(this.m_x_array, this.m_y_array, 4);
        g.setColor(Color.black);
        g.drawPolygon(this.m_x_array, this.m_y_array, 4);
        g.setColor(Color.yellow);
        g.fillOval(this.m_x0 - 3, this.m_y0 - 3, 6, 6);
        g.setColor(Color.black);
        g.drawOval(this.m_x0 - 3, this.m_y0 - 3, 6, 6);
        g.setColor(Color.green);
        g.fillOval(this.m_x1 - 3, this.m_y1 - 3, 6, 6);
        g.setColor(Color.black);
        g.drawOval(this.m_x1 - 3, this.m_y1 - 3, 6, 6);
        g.setColor(Color.green);
        g.fillOval(this.m_x2 - 3, this.m_y2 - 3, 6, 6);
        g.setColor(Color.black);
        g.drawOval(this.m_x2 - 3, this.m_y2 - 3, 6, 6);
    }

    public int getAngleDegree() {
        return (int)this.m_angle;
    }

    public double getAngleRad() {
        double return_value = this.m_angle * Math.PI / 180.0;
        if (return_value > 0.0 && return_value < 0.01 || return_value < 0.0 && return_value > -0.01) {
            return 0.0;
        }
        return return_value;
    }

    public void setRadius(int which, double radius) {
        if (which == 1) {
            this.m_radius1 = radius;
        }
        if (which == 2) {
            this.m_radius2 = radius;
        }
    }

    public boolean setBar() {
        boolean result = true;
        double rad1 = this.m_radius1;
        double rad2 = this.m_radius2;
        double old_angle = this.m_angle;
        this.m_radius1 /= (double)this.m_coef;
        this.m_radius2 /= (double)this.m_coef;
        this.m_angle = this.m_time * this.m_time;
        this.m_angle *= 0.5;
        double mult = this.m_scene.getForceMagnitude(1) * this.m_radius1;
        this.m_angle *= (mult += this.m_scene.getForceMagnitude(2) * Math.sin(this.m_scene.getForceAngle(2)) * this.m_radius2);
        this.m_angle *= (double)5;
        this.m_radius1 = rad1;
        this.m_radius2 = rad2;
        double angle = this.getAngleRad();
        if (this.m_angle >= (double)360 || this.m_angle <= (double)-360) {
            this.m_angle = old_angle;
            return false;
        }
        if (this.m_time <= 0.0) {
            angle = 0.0;
            this.m_angle = 0.0;
        }
        this.m_x1 = (int)((double)this.m_x0 + this.m_radius1 * Math.cos(angle));
        this.m_y1 = (int)((double)this.m_y0 - this.m_radius1 * Math.sin(angle));
        this.m_x2 = (int)((double)this.m_x0 + this.m_radius2 * Math.cos(angle));
        this.m_y2 = (int)((double)this.m_y0 - this.m_radius2 * Math.sin(angle));
        this.m_velocity = this.m_time == 0.0 ? 0.0 : angle * (double)2 / this.m_time;
        this.setBarPoints();
        return result;
    }

    public void resetTime() {
        this.m_time = 0.0;
        this.setBar();
    }

    public boolean increaseTime(boolean mode) {
        double old_time = this.m_time;
        this.m_time = mode ? (this.m_time += 0.02) : (this.m_time >= 0.02 ? (this.m_time -= 0.02) : 0.0);
        boolean result = this.setBar();
        if (!result) {
            this.m_time = old_time;
        }
        return result;
    }

    public int getForceX(int force) {
        if (force == 1) {
            return this.m_x1;
        }
        if (force == 2) {
            return this.m_x2;
        }
        return -1;
    }

    public int getForceY(int force) {
        if (force == 1) {
            return this.m_y1;
        }
        if (force == 2) {
            return this.m_y2;
        }
        return -1;
    }

    protected void setBarPoints() {
        double angle = this.getAngleRad();
        int xa = (int)((double)this.m_x0 + (double)this.m_length * Math.cos(angle));
        int ya = (int)((double)this.m_y0 - (double)this.m_length * Math.sin(angle));
        this.X1 = (int)((double)xa + (double)this.m_width * Math.cos(1.5707963267948966 - angle));
        this.Y1 = (int)((double)ya + (double)this.m_width * Math.sin(1.5707963267948966 - angle));
        this.X2 = (int)((double)xa - (double)this.m_width * Math.cos(1.5707963267948966 - angle));
        this.Y2 = (int)((double)ya - (double)this.m_width * Math.sin(1.5707963267948966 - angle));
        xa = (int)((double)this.m_x0 - (double)this.m_length * Math.cos(angle));
        ya = (int)((double)this.m_y0 + (double)this.m_length * Math.sin(angle));
        this.X4 = (int)((double)xa + (double)this.m_width * Math.cos(1.5707963267948966 - angle));
        this.Y4 = (int)((double)ya + (double)this.m_width * Math.sin(1.5707963267948966 - angle));
        this.X3 = (int)((double)xa - (double)this.m_width * Math.cos(1.5707963267948966 - angle));
        this.Y3 = (int)((double)ya - (double)this.m_width * Math.sin(1.5707963267948966 - angle));
        this.m_x_array[0] = this.X1;
        this.m_x_array[1] = this.X2;
        this.m_x_array[2] = this.X3;
        this.m_x_array[3] = this.X4;
        this.m_y_array[0] = this.Y1;
        this.m_y_array[1] = this.Y2;
        this.m_y_array[2] = this.Y3;
        this.m_y_array[3] = this.Y4;
    }

    public double getTime() {
        return this.m_time;
    }

    public double getRadius(int which) {
        if (which == 1) {
            return this.m_radius1;
        }
        return this.m_radius2;
    }

    public double getVelocity() {
        return this.m_velocity;
    }
}

