/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AForce {
    protected AScene21 m_scene;
    protected int m_id;
    protected int m_x;
    protected int m_y;
    protected double m_magnitude;
    protected double m_angle;
    protected int m_arrow_length = 30;
    protected Color m_color;
    protected double m_arrow_angle = 1.0471975511965976;
    protected int m_arrow_shift = 8;
    protected int[] m_X = new int[7];
    protected int[] m_Y = new int[7];

    public AForce(AScene21 scene, int id, double magnitude, double angle, Color color) {
        this.m_id = id;
        this.m_scene = scene;
        this.m_x = this.m_scene.getForceX(id);
        this.m_x = this.m_scene.getForceY(id);
        this.m_magnitude = magnitude;
        this.m_angle = angle;
        this.m_color = color;
        this.update();
    }

    public void paint(Graphics g) {
        if (this.m_magnitude == 0.0) {
            g.setColor(this.m_color);
            g.drawPolygon(this.m_X, this.m_Y, 7);
            return;
        }
        g.setColor(this.m_color);
        g.fillPolygon(this.m_X, this.m_Y, 7);
        g.setColor(Color.black);
        g.drawPolygon(this.m_X, this.m_Y, 7);
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
    }

    public void setMagnitude(double magnitude) {
        this.m_magnitude = magnitude;
    }

    public void setX(int x) {
        this.m_x = x;
    }

    public void setY(int y) {
        this.m_y = y;
    }

    public double getAngle() {
        return this.m_angle;
    }

    public double getMagnitude() {
        return this.m_magnitude;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public void update() {
        double bar_angle = this.m_scene.getBarAngleRad() + this.m_angle - 1.5707963267948966;
        int arrow_rad = (int)Math.sqrt(this.m_arrow_length * this.m_arrow_length + this.m_arrow_length * this.m_arrow_length / 4);
        int xa = this.m_scene.getForceX(this.m_id);
        int ya = this.m_scene.getForceY(this.m_id);
        double ang = bar_angle - this.m_arrow_angle / (double)2;
        int xb = (int)((double)xa + (double)arrow_rad * Math.sin(ang));
        int yb = (int)((double)ya + (double)arrow_rad * Math.cos(ang));
        int xc = (int)((double)xb + (double)this.m_arrow_shift * Math.cos(bar_angle));
        int yc = (int)((double)yb - (double)this.m_arrow_shift * Math.sin(bar_angle));
        int arrow_width = this.m_arrow_length - 2 * this.m_arrow_shift;
        int xf = (int)((double)xc + (double)arrow_width * Math.cos(bar_angle));
        int yf = (int)((double)yc - (double)arrow_width * Math.sin(bar_angle));
        int xg = (int)((double)xb + (double)this.m_arrow_length * Math.cos(bar_angle));
        int yg = (int)((double)yb - (double)this.m_arrow_length * Math.sin(bar_angle));
        int arrow_mag = (int)(this.m_magnitude * (double)5);
        ang = 1.5707963267948966 - bar_angle;
        int xd = (int)((double)xc + (double)arrow_mag * Math.cos(ang));
        int yd = (int)((double)yc + (double)arrow_mag * Math.sin(ang));
        int xe = (int)((double)xd + (double)arrow_width * Math.cos(bar_angle));
        int ye = (int)((double)yd - (double)arrow_width * Math.sin(bar_angle));
        this.m_X[0] = xa;
        this.m_X[1] = xb;
        this.m_X[2] = xc;
        this.m_X[3] = xd;
        this.m_X[4] = xe;
        this.m_X[5] = xf;
        this.m_X[6] = xg;
        this.m_Y[0] = ya;
        this.m_Y[1] = yb;
        this.m_Y[2] = yc;
        this.m_Y[3] = yd;
        this.m_Y[4] = ye;
        this.m_Y[5] = yf;
        this.m_Y[6] = yg;
    }
}

