/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AGraph21 {
    protected AScene21 m_scene;
    protected int m_start_x;
    protected int m_start_y;
    protected double m_step_x;
    protected double m_step_y;
    protected double m_max_x;
    protected int m_x_axis_length;
    protected int m_down_shift = 260;
    protected Color m_color_black = new Color(0, 0, 0);
    protected Color m_color_red = new Color(255, 0, 0);
    protected Color m_color_blue = new Color(0, 0, 255);
    protected Color m_color_green = new Color(0, 150, 0);
    protected Color m_color_yellow = new Color(255, 200, 0);
    protected double[] m_y_value;
    protected double[] m_y_value1;
    protected int m_prevX = 0;
    protected int m_prevY = 0;
    protected int m_prevX1 = 0;
    protected int m_prevY1 = 0;
    protected boolean m_check = true;

    public AGraph21(AScene21 scene, int x, int y, double step_x, double step_y, double max_x) {
        this.m_scene = scene;
        this.m_start_x = x;
        this.m_start_y = y;
        this.m_step_x = step_x;
        this.m_step_y = step_y;
        this.m_max_x = max_x;
        this.m_x_axis_length = (int)(this.m_max_x / this.m_step_x);
        this.m_y_value = new double[this.m_x_axis_length];
        this.m_y_value1 = new double[this.m_x_axis_length];
    }

    public void paint(Graphics g, Graphics g1) {
        this.paintAxes(g, g1);
        this.paintGraph1(g, g1);
    }

    public void paintAxes(Graphics g, Graphics g1) {
        int count;
        g.setColor(this.m_color_black);
        g1.setColor(this.m_color_black);
        if (this.m_check) {
            g.drawLine(this.m_start_x, this.m_start_y, this.m_start_x + this.m_x_axis_length, this.m_start_y);
            g.drawLine(this.m_start_x + this.m_x_axis_length, this.m_start_y, this.m_start_x + this.m_x_axis_length - 6, this.m_start_y - 3);
            g.drawLine(this.m_start_x + this.m_x_axis_length, this.m_start_y, this.m_start_x + this.m_x_axis_length - 6, this.m_start_y + 3);
            g.drawString("t", this.m_start_x + this.m_x_axis_length, this.m_start_y + 12);
            g.drawLine(this.m_start_x, this.m_start_y + 50, this.m_start_x, this.m_start_y - 50);
            g.drawLine(this.m_start_x, this.m_start_y - 50, this.m_start_x - 3, this.m_start_y - 44);
            g.drawLine(this.m_start_x, this.m_start_y - 50, this.m_start_x + 3, this.m_start_y - 44);
            for (count = 0; count < this.m_x_axis_length; ++count) {
                if (count == 0 || count % 20 != 0) continue;
                g.drawLine(this.m_start_x + count, this.m_start_y, this.m_start_x + count, this.m_start_y - 3);
                if (count % 40 != 0) continue;
                g.drawString(String.valueOf(count), this.m_start_x + count - 5, this.m_start_y + 15);
            }
            g.drawLine(this.m_start_x, this.m_start_y - 27, this.m_start_x + 3, this.m_start_y - 27);
            g.drawString("5", this.m_start_x - 10, this.m_start_y - 22);
            g.drawLine(this.m_start_x, this.m_start_y + 27, this.m_start_x + 3, this.m_start_y + 27);
            g.drawString("-5", this.m_start_x - 15, this.m_start_y + 32);
        }
        g1.drawString(String.valueOf("Angular velocity (rad/s): ").concat(String.valueOf(ASim21.cutDouble(String.valueOf(this.m_scene.getVelocity())))), this.m_start_x, this.m_start_y - 50 - 2);
        this.m_start_x -= this.m_down_shift;
        if (this.m_check) {
            g.drawLine(this.m_start_x, this.m_start_y, this.m_start_x + this.m_x_axis_length, this.m_start_y);
            g.drawLine(this.m_start_x + this.m_x_axis_length, this.m_start_y, this.m_start_x + this.m_x_axis_length - 6, this.m_start_y - 3);
            g.drawLine(this.m_start_x + this.m_x_axis_length, this.m_start_y, this.m_start_x + this.m_x_axis_length - 6, this.m_start_y + 3);
            g.drawString("t", this.m_start_x + this.m_x_axis_length, this.m_start_y + 12);
            g.drawLine(this.m_start_x, this.m_start_y + 50, this.m_start_x, this.m_start_y - 50);
            g.drawLine(this.m_start_x, this.m_start_y - 50, this.m_start_x - 3, this.m_start_y - 44);
            g.drawLine(this.m_start_x, this.m_start_y - 50, this.m_start_x + 3, this.m_start_y - 44);
            for (count = 0; count < this.m_x_axis_length; ++count) {
                if (count == 0 || count % 20 != 0) continue;
                g.drawLine(this.m_start_x + count, this.m_start_y, this.m_start_x + count, this.m_start_y - 3);
                if (count % 40 != 0) continue;
                g.drawString(String.valueOf(count), this.m_start_x + count - 5, this.m_start_y + 15);
            }
            g.drawLine(this.m_start_x, this.m_start_y - 27, this.m_start_x + 3, this.m_start_y - 27);
            g.drawString("7", this.m_start_x - 10, this.m_start_y - 22);
            g.drawLine(this.m_start_x, this.m_start_y + 27, this.m_start_x + 3, this.m_start_y + 27);
            g.drawString("-7", this.m_start_x - 12, this.m_start_y + 32);
        }
        g1.drawString(String.valueOf("Angular position (rad): ").concat(String.valueOf(ASim21.cutDouble(String.valueOf(this.m_scene.getBarAngleRad())))), this.m_start_x, this.m_start_y - 50 - 2);
        this.m_start_x += this.m_down_shift;
    }

    public void paintGraph1(Graphics g, Graphics g1) {
        double arg = 0.0;
        g.setColor(this.m_color_red);
        int index = (int)(this.m_scene.getTime() * (double)10);
        if (index < this.m_x_axis_length && this.m_start_y - (int)this.m_y_value1[index] < 150) {
            if (this.m_prevX1 != 0) {
                g.drawLine(this.m_prevX1, this.m_prevY1, this.m_start_x + index, this.m_start_y - (int)this.m_y_value1[index]);
                this.m_check = false;
            }
            g1.setColor(Color.cyan);
            g1.fillOval(this.m_start_x + index - 3, this.m_start_y - (int)this.m_y_value1[index] - 3, 6, 6);
            g1.setColor(Color.black);
            g1.drawOval(this.m_start_x + index - 3, this.m_start_y - (int)this.m_y_value1[index] - 3, 6, 6);
            this.m_prevX1 = this.m_start_x + index;
            this.m_prevY1 = this.m_start_y - (int)this.m_y_value1[index];
        }
        this.m_start_x -= this.m_down_shift;
        if (index < this.m_x_axis_length && this.m_start_y - (int)this.m_y_value[index] < 150) {
            if (this.m_prevX != 0) {
                g.drawLine(this.m_prevX, this.m_prevY, this.m_start_x + index, this.m_start_y - (int)this.m_y_value[index]);
                this.m_check = false;
            }
            g1.setColor(Color.cyan);
            g1.fillOval(this.m_start_x + index - 3, this.m_start_y - (int)this.m_y_value[index] - 3, 6, 6);
            g1.setColor(Color.black);
            g1.drawOval(this.m_start_x + index - 3, this.m_start_y - (int)this.m_y_value[index] - 3, 6, 6);
            this.m_prevX = this.m_start_x + index;
            this.m_prevY = this.m_start_y - (int)this.m_y_value[index];
        }
        this.m_start_x += this.m_down_shift;
    }

    public void setGraph() {
        for (int count = 0; count < this.m_x_axis_length; ++count) {
            this.m_y_value[count] = this.getFunctionValue(count, 10000.0);
            this.m_y_value1[count] = this.getFunctionValue1(count, 100.0);
        }
    }

    protected double getFunctionValue(double arg, double coef) {
        double rad1 = this.m_scene.m_bar.getRadius(1);
        double rad2 = this.m_scene.m_bar.getRadius(2);
        double mag1 = this.m_scene.getForceMagnitude(1);
        double mag2 = this.m_scene.getForceMagnitude(2);
        double time = arg;
        double angle = time * time;
        angle *= 0.5;
        double mult = mag1 * (rad1 /= (double)25);
        angle *= (mult += mag2 * Math.sin(this.m_scene.getForceAngle(2)) * (rad2 /= (double)25));
        return (double)7 * (angle *= (double)5) / coef;
    }

    protected double getFunctionValue1(double arg, double coef) {
        double rad1 = this.m_scene.m_bar.getRadius(1);
        double rad2 = this.m_scene.m_bar.getRadius(2);
        double mag1 = this.m_scene.getForceMagnitude(1);
        double mag2 = this.m_scene.getForceMagnitude(2);
        double time = arg;
        double angle = time;
        double mult = mag1 * (rad1 /= (double)25);
        angle *= (mult += mag2 * Math.sin(this.m_scene.getForceAngle(2)) * (rad2 /= (double)25));
        return (angle *= (double)5) / coef;
    }

    public void uncheck() {
        this.m_check = true;
    }
}

