/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class AScene21 {
    protected ABar m_bar = new ABar(this, 380, 230, 100, -50, 25);
    protected AForce m_force1 = new AForce(this, 1, 0.0, 1.5707963267948966, Color.red);
    protected AForce m_force2 = new AForce(this, 2, 5.0, 1.5707963267948966, Color.blue);
    protected double m_torque;

    public AScene21() {
        this.m_bar.setBar();
        this.m_force1.update();
        this.m_force2.update();
    }

    public void paint(Graphics g) {
        this.m_bar.paint(g);
        this.m_force1.paint(g);
        this.m_force2.paint(g);
    }

    public int getForceX(int force) {
        return this.m_bar.getForceX(force);
    }

    public int getForceY(int force) {
        return this.m_bar.getForceY(force);
    }

    public double getForceAngle(int force) {
        if (force == 1) {
            return this.m_force1.getAngle();
        }
        if (force == 2) {
            return this.m_force2.getAngle();
        }
        return 0.0;
    }

    public double getForceMagnitude(int force) {
        if (force == 1) {
            return this.m_force1.getMagnitude();
        }
        if (force == 2) {
            return this.m_force2.getMagnitude();
        }
        return 0.0;
    }

    public void resetTime() {
        this.m_bar.resetTime();
        this.m_force1.update();
        this.m_force2.update();
    }

    public boolean increaseTime(boolean mode) {
        boolean result = this.m_bar.increaseTime(mode);
        if (result) {
            this.m_force1.update();
            this.m_force2.update();
        }
        return result;
    }

    public void updateForces() {
        this.m_force1.update();
        this.m_force2.update();
        this.updateTorque();
    }

    public double getBarAngle() {
        return this.m_bar.getAngleDegree();
    }

    public double getBarAngleRad() {
        return this.m_bar.getAngleRad();
    }

    public void setMagnitude(int force, double magnitude) {
        if (force == 1) {
            this.m_force1.setMagnitude(magnitude);
        }
        if (force == 2) {
            this.m_force2.setMagnitude(magnitude);
        }
    }

    public void setAngle(int force, double angle) {
        angle = this.toRadians(angle);
        if (force == 1) {
            this.m_force1.setAngle(angle);
        }
        if (force == 2) {
            this.m_force2.setAngle(angle);
        }
    }

    public void setRadius(int which, double radius) {
        this.m_bar.setRadius(which, radius);
    }

    public void setBar() {
        this.m_bar.setBar();
    }

    protected double toRadians(double angle) {
        return angle * (double)2 * Math.PI / (double)360;
    }

    public double getTime() {
        return this.m_bar.getTime();
    }

    public double getVelocity() {
        return this.m_bar.getVelocity();
    }

    protected void updateTorque() {
        double rad1 = this.m_bar.getRadius(1);
        double rad2 = this.m_bar.getRadius(2);
        double mag1 = this.getForceMagnitude(1);
        double mag2 = this.getForceMagnitude(2);
        this.m_torque = mag1 * (rad1 /= (double)25);
        this.m_torque += mag2 * Math.sin(this.getForceAngle(2)) * (rad2 /= (double)25);
    }

    public double getTorque() {
        return this.m_torque;
    }
}

