/*
 * Decompiled with CFR 0.152.
 */
package com.maris.ACommon;

import com.maris.util.zUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class ASlider {
    protected int m_x;
    protected int m_y;
    protected int m_y_shaft;
    protected int m_x_start;
    protected int m_length;
    protected int m_shaft_height = 4;
    protected int m_radius;
    protected int m_low_limit;
    protected int m_high_limit;
    protected int m_current_value;
    protected Color m_slider_color = new Color(168, 176, 101);
    protected Color m_shaft_color = new Color(108, 116, 41);
    protected Color m_line_color = new Color(0, 0, 0);
    protected Image m_image;
    protected static boolean m_active = true;
    protected boolean m_slider_hit = false;
    protected int m_x_shift = 0;

    public ASlider(Image image, int x, int y, int length, int radius, int low_limit, int high_limit, int value) {
        this.m_image = image;
        this.m_x_start = x;
        this.m_y_shaft = y;
        this.m_length = length;
        this.m_radius = radius;
        this.m_low_limit = low_limit;
        this.m_high_limit = high_limit;
        this.m_current_value = value;
        this.m_y = this.m_y_shaft - (this.m_radius - this.m_shaft_height) / 2;
        this.positionToValue(this.m_current_value);
    }

    public void paint(Graphics g) {
        this.paintSlider(g);
    }

    protected void paintShaft(Graphics g) {
        g.setColor(this.m_shaft_color);
        g.fillRoundRect(this.m_x_start, this.m_y_shaft, this.m_length + this.m_radius, this.m_shaft_height, 4, 4);
        g.setColor(this.m_line_color);
        g.drawRoundRect(this.m_x_start, this.m_y_shaft, this.m_length + this.m_radius, this.m_shaft_height, 4, 4);
    }

    protected void paintSlider(Graphics g) {
        if (!m_active) {
            zUtil.drawImage(g, this.m_image, this.m_x, this.m_y - 1, this.m_x + this.m_radius, this.m_y + this.m_radius - 1, 0, this.m_radius + 1, this.m_radius, 2 * this.m_radius, null);
        } else {
            zUtil.drawImage(g, this.m_image, this.m_x, this.m_y, this.m_x + this.m_radius, this.m_y + this.m_radius, 0, 0, this.m_radius, this.m_radius, null);
        }
    }

    public void setX(int x) {
        this.m_x = x;
    }

    public int getX() {
        return this.m_x;
    }

    public int getCurrentValue() {
        return this.m_current_value;
    }

    public void setCurrentValue(int value) {
        this.m_current_value = value;
    }

    protected void estimateValue(int x) {
        double range = this.m_high_limit - this.m_low_limit;
        double x_pos = x - this.m_x_start;
        double coeff = x_pos / (double)this.m_length;
        this.m_current_value = (int)(range * coeff) + this.m_low_limit;
        if (this.m_current_value > this.m_high_limit) {
            this.m_current_value = this.m_high_limit;
        }
    }

    public void positionToValue(int value) {
        double range = this.m_high_limit - this.m_low_limit;
        double step = (double)this.m_length / range;
        int x = (int)((double)value * step - (double)this.m_low_limit * step);
        this.setX(this.m_x_start + x);
    }

    public boolean onMouseMove(int x, int y) {
        return false;
    }

    public boolean onMouseDown(int x, int y) {
        if (!m_active) {
            return false;
        }
        if (this.isSlider(x, y)) {
            this.m_slider_hit = true;
            this.m_x_shift = x - this.m_x;
        }
        return false;
    }

    public boolean onMouseUp(int x, int y) {
        if (!m_active) {
            return false;
        }
        this.m_slider_hit = false;
        return false;
    }

    public boolean onMouseDrag(int x, int y) {
        if (!m_active) {
            return false;
        }
        if (!this.m_slider_hit) {
            return false;
        }
        if (x - this.m_x_shift >= this.m_x_start && x - this.m_x_shift < this.m_x_start + this.m_length) {
            this.setX(x - this.m_x_shift);
            this.estimateValue(x);
        }
        if (x - this.m_x_shift < this.m_x_start) {
            this.setX(this.m_x_start);
            this.estimateValue(this.m_x_start);
        }
        if (x - this.m_x_shift >= this.m_x_start + this.m_length) {
            this.setX(this.m_x_start + this.m_length);
            this.estimateValue(this.m_x_start + this.m_length);
        }
        return true;
    }

    protected boolean isSlider(int x, int y) {
        if (x < this.m_x_start || x > this.m_x_start + this.m_length + this.m_radius) {
            return false;
        }
        return x > this.m_x && x < this.m_x + this.m_radius && y > this.m_y && y < this.m_y + this.m_radius;
    }

    public void setActive(boolean mode) {
        m_active = mode;
    }

    public static boolean getActive() {
        return m_active;
    }
}

