/*
 * Decompiled with CFR 0.152.
 */
package com.maris.awt;

import com.maris.util.zUtil;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;

public final class Slider {
    private static final int TYPE1 = 1;
    private static final int TYPE2 = 2;
    private static final int TYPE3 = 3;
    private Image m_img = null;
    private Point m_p1 = new Point(0, 0);
    private Point m_p2 = new Point(0, 0);
    private Point m_offset = new Point(0, 0);
    private boolean m_insideSlider = false;
    private Point m_max = new Point(0, 0);
    private Point m_min = new Point(0, 0);
    private double m_minValue;
    private double m_maxValue;
    private int m_sw = 0;
    private int m_sh = 0;
    private int m_w = 0;
    private int m_h = 0;
    private Polygon m_hotSpot = new Polygon();
    private int m_type = 0;
    private double m_k = 0.0;
    private double m_d = 0.0;
    private double m_len = 0.0;
    private double m_pos = 0.0;
    private long m_nSteps = 100L;
    private double m_step = 0.0;
    private boolean m_show = true;
    private boolean m_enable = true;
    private Container m_parent = null;

    public void setRange(double d, double d2) {
        this.m_minValue = d;
        this.m_maxValue = d2;
    }

    public double getMinValue() {
        return this.m_minValue;
    }

    public boolean isEnabled() {
        return this.m_enable;
    }

    public void draw(Graphics graphics) {
        if (this.m_show) {
            if (this.m_enable) {
                zUtil.drawImage(graphics, this.m_img, this.m_hotSpot.xpoints[0], this.m_hotSpot.ypoints[0], this.m_hotSpot.xpoints[2], this.m_hotSpot.ypoints[2], 0, 0, this.m_w, this.m_h);
                return;
            }
            zUtil.drawImage(graphics, this.m_img, this.m_hotSpot.xpoints[0], this.m_hotSpot.ypoints[0], this.m_hotSpot.xpoints[2], this.m_hotSpot.ypoints[2], 0, this.m_h, this.m_w, this.m_h + this.m_h);
        }
    }

    public Slider(Image image, int n, int n2, int n3, int n4, Container container) {
        this(image, n, n2, n3, n4, 100L, 0.0, 100.0, container);
    }

    public Slider(Image image, int n, int n2, int n3, int n4, long l, Container container) {
        this(image, n, n2, n3, n4, l, 0.0, 100.0, container);
    }

    public Slider(Image image, int n, int n2, int n3, int n4, long l, double d, double d2, Container container) {
        this.m_img = image;
        this.m_parent = container;
        this.setRange(d, d2);
        this.m_p1.x = n;
        this.m_p1.y = n2;
        this.m_p2.x = n3;
        this.m_p2.y = n4;
        this.m_w = image.getWidth(container);
        this.m_h = image.getHeight(container) >>> 1;
        this.m_sw = this.m_w >>> 1;
        this.m_sh = this.m_h >>> 1;
        this.m_hotSpot.addPoint(this.m_p1.x - this.m_sw, this.m_p1.y - this.m_sh);
        this.m_hotSpot.addPoint(this.m_hotSpot.xpoints[0] + this.m_w, this.m_hotSpot.ypoints[0]);
        this.m_hotSpot.addPoint(this.m_hotSpot.xpoints[1], this.m_hotSpot.ypoints[0] + this.m_h);
        this.m_hotSpot.addPoint(this.m_hotSpot.xpoints[0], this.m_hotSpot.ypoints[2]);
        this.CalcParams();
        this.setNumberSteps(l);
    }

    public boolean inside(int n, int n2) {
        return this.m_hotSpot.inside(n, n2);
    }

    public void hide() {
        this.m_show = false;
    }

    public boolean mouseUp(int n, int n2) {
        this.m_insideSlider = this.m_hotSpot.inside(n, n2);
        return true;
    }

    public final double getAbsolutPosition() {
        return this.m_minValue + (this.m_maxValue - this.m_minValue) * this.m_pos;
    }

    public final void setAbsolutPosition(double d) {
        this.setPosition((d - this.m_minValue) / (this.m_maxValue - this.m_minValue));
    }

    public double getMaxValue() {
        return this.m_maxValue;
    }

    public boolean isVisible() {
        return this.m_show;
    }

    public void enable() {
        this.m_enable = true;
    }

    public void disable() {
        this.m_enable = false;
    }

    public void enable(boolean bl) {
        this.m_enable = bl;
    }

    public void show() {
        this.m_show = true;
    }

    public final double getPosition() {
        return this.m_pos;
    }

    public final void setPosition(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.m_enable) {
            this.m_pos = (double)Math.round(d / this.m_step) * this.m_step;
            switch (this.m_type) {
                case 1: {
                    this.m_hotSpot.translate((int)(this.m_pos * this.m_len - (double)this.m_sw + (double)this.m_p1.x - (double)this.m_hotSpot.xpoints[0]), 0);
                    return;
                }
                case 2: {
                    this.m_hotSpot.translate(0, (int)(this.m_pos * this.m_len - (double)this.m_sh + (double)this.m_p1.y - (double)this.m_hotSpot.ypoints[0]));
                    return;
                }
                case 3: {
                    this.m_hotSpot.translate((int)(this.m_pos * (double)(this.m_p2.x - this.m_p1.x) - (double)this.m_sw + (double)this.m_p1.x - (double)this.m_hotSpot.xpoints[0]), (int)(this.m_pos * (double)(this.m_p2.y - this.m_p1.y) - (double)this.m_sh + (double)this.m_p1.y - (double)this.m_hotSpot.ypoints[0]));
                    return;
                }
            }
        }
    }

    public boolean mouseDown(int n, int n2) {
        if (this.m_insideSlider && this.m_enable && this.m_show) {
            this.m_offset.x = n - this.m_hotSpot.xpoints[0];
            this.m_offset.y = n2 - this.m_hotSpot.ypoints[0];
        }
        return true;
    }

    public void setNumberSteps(long l) {
        this.m_nSteps = l;
        this.m_step = 1.0 / (double)l;
    }

    public long getNumberSteps() {
        return this.m_nSteps;
    }

    protected final void CalcParams() {
        if (this.m_p2.x > this.m_p1.x) {
            this.m_max.x = this.m_p2.x;
            this.m_min.x = this.m_p1.x;
        } else {
            this.m_max.x = this.m_p1.x;
            this.m_min.x = this.m_p2.x;
        }
        if (this.m_p2.y > this.m_p1.y) {
            this.m_max.y = this.m_p2.y;
            this.m_min.y = this.m_p1.y;
        } else {
            this.m_max.y = this.m_p1.y;
            this.m_min.y = this.m_p2.y;
        }
        int n = this.m_p2.y - this.m_p1.y;
        int n2 = this.m_p2.x - this.m_p1.x;
        if (n == 0) {
            this.m_type = 1;
            this.m_len = n2;
            return;
        }
        if (n2 == 0) {
            this.m_type = 2;
            this.m_len = n;
            return;
        }
        this.m_type = 3;
        this.m_k = n / n2;
        this.m_d = (double)this.m_p1.y - this.m_k * (double)this.m_p1.x;
        this.m_len = Math.sqrt(n * n + n2 * n2);
    }

    public boolean mouseDrag(int n, int n2) {
        if (this.m_insideSlider && this.m_enable && this.m_show) {
            n -= this.m_offset.x;
            n2 -= this.m_offset.y;
            switch (this.m_type) {
                case 1: {
                    int n3;
                    if (n + this.m_sw > this.m_max.x) {
                        n3 = this.m_max.x - this.m_sw;
                        if (this.m_hotSpot.xpoints[0] == n3) {
                            return true;
                        }
                        n = n3;
                    }
                    if (n + this.m_sw < this.m_min.x) {
                        n3 = this.m_min.x - this.m_sw;
                        if (this.m_hotSpot.xpoints[0] == n3) {
                            return true;
                        }
                        n = n3;
                    }
                    this.setPosition((double)(n + this.m_sw - this.m_p1.x) / this.m_len);
                    break;
                }
                case 2: {
                    int n4;
                    if (n2 + this.m_sh > this.m_max.y) {
                        n4 = this.m_max.y - this.m_sh;
                        if (this.m_hotSpot.ypoints[0] == n4) {
                            return true;
                        }
                        n2 = n4;
                    }
                    if (n2 + this.m_sh < this.m_min.y) {
                        n4 = this.m_min.y - this.m_sh;
                        if (this.m_hotSpot.ypoints[0] == n4) {
                            return true;
                        }
                        n2 = n4;
                    }
                    this.setPosition((double)(n2 + this.m_sh - this.m_p1.y) / this.m_len);
                    break;
                }
                case 3: {
                    int n5;
                    if (n > n2) {
                        if (n + this.m_sw > this.m_max.x) {
                            n5 = this.m_max.x - this.m_sw;
                            if (this.m_hotSpot.xpoints[0] == n5) {
                                return true;
                            }
                            n = n5;
                        }
                        if (n + this.m_sw < this.m_min.x) {
                            n5 = this.m_min.x - this.m_sw;
                            if (this.m_hotSpot.xpoints[0] == n5) {
                                return true;
                            }
                            n = n5;
                        }
                        n2 = (int)(this.m_k * (double)n + this.m_d);
                    } else {
                        if (n2 + this.m_sh > this.m_max.y) {
                            n5 = this.m_max.y - this.m_sh;
                            if (this.m_hotSpot.ypoints[0] == n5) {
                                return true;
                            }
                            n2 = n5;
                        }
                        if (n2 + this.m_sh < this.m_min.y) {
                            n5 = this.m_min.y - this.m_sh;
                            if (this.m_hotSpot.ypoints[0] == n5) {
                                return true;
                            }
                            n2 = n5;
                        }
                        n = (int)(((double)n2 - this.m_d) / this.m_k);
                    }
                    n5 = n + this.m_sw - this.m_p1.x;
                    int n6 = n2 + this.m_sh - this.m_p1.y;
                    this.setPosition(Math.sqrt(n5 * n5 + n6 * n6) / this.m_len);
                }
            }
            this.m_parent.postEvent(new Event(this, 1001, this));
        }
        return true;
    }

    public boolean mouseMove(int n, int n2) {
        this.m_insideSlider = this.m_hotSpot.inside(n, n2);
        return true;
    }
}

