/*
 * Decompiled with CFR 0.152.
 */
package com.maris.awt;

import com.maris.awt.zButtonBaseClassic;
import com.maris.awt.zIButtonBase;
import java.awt.Canvas;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class zGenericButton
extends Canvas {
    public static final int MODE_PUSH = 0;
    public static final int MODE_TOGGLE = 1;
    protected int mode = 0;
    public static final int STATE_DISABLED = 0;
    public static final int STATE_NORMAL = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_PRESSED = 3;
    public static final int STATE_PRESSED_DISABLED = 4;
    private static final int NUM_STATES = 5;
    protected int state = 0;
    private zIButtonBase[] buttonBase = new zIButtonBase[5];
    static final zIButtonBase defButtonBase = new zButtonBaseClassic();
    protected Image[] images = new Image[5];
    protected int width = 0;
    protected int height = 0;
    protected int bbX = 0;
    protected int bbY = 0;
    protected int bbW = 0;
    protected int bbH = 0;
    private boolean bbRect = false;
    private boolean needRebuild = true;
    private boolean toggleIsOn = false;

    public void rebuild() {
        this.needRebuild = true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        switch (this.state) {
            case 1: {
                this.state = 2;
                this.repaint();
            }
        }
        return true;
    }

    public final Rectangle getButtonBaseRect() {
        return new Rectangle(this.bbX, this.bbY, this.bbW, this.bbH);
    }

    public final void setButtonBaseRect(Rectangle rectangle) {
        this.setButtonBaseRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void setButtonBaseRect(int n, int n2, int n3, int n4) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height && n3 > 0 && n3 <= this.width && n4 > 0 && n4 <= this.height) {
            this.bbX = n;
            this.bbY = n2;
            this.bbW = n3;
            this.bbH = n4;
            int n5 = this.bbX + this.bbW;
            int n6 = this.bbY + this.bbH;
            if (n5 >= this.width) {
                this.bbW = this.width - this.bbX;
            }
            if (n6 >= this.height) {
                this.bbH = this.height - this.bbY;
            }
            this.bbRect = true;
            this.needRebuild = true;
        }
    }

    public boolean mouseExit(Event event, int n, int n2) {
        switch (this.state) {
            case 2: 
            case 3: {
                this.state = 1;
                this.repaint();
            }
        }
        return true;
    }

    public final boolean isEnabled() {
        return this.state != 0 && this.state != 4;
    }

    protected abstract void configState(zIButtonBase var1, int var2);

    public void paint(Graphics graphics) {
        if (this.needRebuild) {
            this.configBBase();
            int n = 0;
            while (n < this.images.length) {
                if (this.images[n] == null) {
                    this.images[n] = this.createImage(this.width, this.height);
                    if (this.images[n] == null) {
                        return;
                    }
                }
                Graphics graphics2 = this.images[n].getGraphics();
                this.buttonBase[n].drawImage(graphics2, this.bbX, this.bbY, this.bbW, this.bbH);
                graphics2.dispose();
                this.drawButton(this.images[n], n);
                ++n;
            }
            this.needRebuild = false;
        }
        graphics.drawImage(this.images[this.state], 0, 0, this);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        switch (this.state) {
            case 3: {
                this.state = 2;
                if (this.getParent() != null) {
                    this.getParent().postEvent(new Event(this, 1001, this));
                }
                this.repaint();
            }
        }
        return true;
    }

    private void configBBase() {
        int n = 0;
        while (n < this.buttonBase.length) {
            if (this.buttonBase[n] != null) {
                this.buttonBase[n].clearParameters();
                this.configState(this.buttonBase[n], n);
            }
            ++n;
        }
    }

    public final void setButtonBase(zIButtonBase zIButtonBase2) {
        if (zIButtonBase2 != null) {
            int n = 0;
            while (n < this.buttonBase.length) {
                this.buttonBase[n] = (zIButtonBase)zIButtonBase2.clone();
                ++n;
            }
            this.needRebuild = true;
        }
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void enable() {
        this.enable(true);
    }

    public final void disable() {
        this.enable(false);
    }

    public void enable(boolean bl) {
        if (bl) {
            if (this.state == 0 || this.state == 4) {
                this.state = 1;
                super.enable();
                this.repaint();
                return;
            }
        } else if (this.state != 0 && this.state != 4) {
            this.state = 0;
            super.disable();
            this.repaint();
        }
    }

    protected abstract void drawButton(Image var1, int var2);

    public boolean mouseDown(Event event, int n, int n2) {
        switch (this.state) {
            case 2: {
                this.state = 3;
                this.repaint();
            }
        }
        return true;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 != this.width || n4 != this.height) {
            if (this.bbRect) {
                if (this.width != 0 && this.height != 0) {
                    this.bbX = this.bbX * n3 / this.width;
                    this.bbY = this.bbY * n4 / this.height;
                    this.bbW = this.bbW * n3 / this.width;
                    this.bbH = this.bbH * n4 / this.height;
                } else {
                    this.bbX = 0;
                    this.bbY = 0;
                    this.bbW = n3;
                    this.bbH = n4;
                    this.bbRect = false;
                }
            } else {
                this.bbX = 0;
                this.bbY = 0;
                this.bbW = n3;
                this.bbH = n4;
            }
            this.width = n3;
            this.height = n4;
            this.needRebuild = true;
        }
        super.reshape(n, n2, n3, n4);
    }
}

