/*
 * Decompiled with CFR 0.152.
 */
package com.maris.util;

import com.maris.util.MMath;
import com.maris.util.zITimerListener;
import com.maris.util.zTimer;
import com.maris.util.zUtil;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class AnimationImage
implements zITimerListener {
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    protected Image m_img = null;
    protected Container m_parent = null;
    protected int m_wFrame = 0;
    protected int m_hFrame = 0;
    protected int m_x = 0;
    protected int m_y = 0;
    protected int m_nFrames = 0;
    protected int m_currFrame = 0;
    protected zTimer m_timer = null;
    protected boolean m_direct = true;
    protected boolean m_show = true;
    protected boolean m_start = false;
    protected boolean m_pause = false;

    public void stop() {
        if (this.m_start) {
            this.m_timer.removeListener(this);
            this.m_start = false;
        }
        this.pauseOff();
    }

    public void pauseOff() {
        this.m_pause = false;
    }

    public final int getNumFrames() {
        return this.m_nFrames;
    }

    public final void setDirect(boolean bl) {
        this.m_direct = bl;
    }

    public void draw(Graphics graphics) {
        if (this.m_show) {
            int n = this.m_currFrame * this.m_hFrame;
            zUtil.drawImage(graphics, this.m_img, this.m_x, this.m_y, this.m_x + this.m_wFrame, this.m_y + this.m_hFrame, 0, n, this.m_wFrame, n + this.m_hFrame);
        }
    }

    public AnimationImage(Image image, int n, Container container) {
        this.m_img = image;
        this.m_parent = container;
        this.m_hFrame = n;
        this.m_wFrame = image.getWidth(container);
        this.m_nFrames = image.getHeight(container) / n;
        this.m_timer = new zTimer();
        this.m_timer.start();
    }

    public void hide() {
        this.m_show = false;
    }

    public final void setFPS(double d) {
        if (!MMath.isZero(d, 1.0E-4)) {
            this.m_timer.setResolution((long)(1000.0 / d));
        } else {
            this.m_timer.setResolution(1000000000L);
        }
        this.m_timer.interrupt();
    }

    public final int getFrame() {
        return this.m_currFrame;
    }

    public boolean isPlay() {
        return this.m_start;
    }

    public final void setFrame(int n) {
        if (n < 0) {
            this.m_currFrame = 0;
            return;
        }
        if (n >= this.m_nFrames) {
            this.m_currFrame = this.m_nFrames - 1;
            return;
        }
        this.m_currFrame = n;
    }

    public final void nextFrame() {
        if (this.m_direct) {
            ++this.m_currFrame;
            if (this.m_currFrame >= this.m_nFrames) {
                this.m_currFrame = 0;
                return;
            }
        } else {
            this.m_currFrame += -1;
            if (this.m_currFrame < 0) {
                this.m_currFrame = this.m_nFrames - 1;
            }
        }
    }

    public void start() {
        if (!this.m_start) {
            this.m_timer.addListener(this);
            this.m_start = true;
        }
        this.pauseOff();
    }

    public boolean isVisible() {
        return this.m_show;
    }

    public void show() {
        this.m_show = true;
    }

    public void timerAction(zTimer zTimer2) {
        if (!this.m_pause) {
            this.nextFrame();
            this.m_parent.postEvent(new Event(this, 1001, this));
        }
    }

    public final void setPosition(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void pauseOn() {
        this.m_pause = true;
    }

    public boolean isPause() {
        return this.m_pause;
    }
}

