/*
 * Decompiled with CFR 0.152.
 */
package com.maris.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public final class Primitive {
    public static void thickVectorDraw(Graphics graphics, Point point, Point point2, Dimension dimension, int n) {
        int n2 = point2.x - point.x;
        int n3 = point2.y - point.y;
        int n4 = (int)Math.round(Math.sqrt(n2 * n2 + n3 * n3));
        if (n4 == 0) {
            return;
        }
        int n5 = dimension.height >>> 1;
        int n6 = n >>> 1;
        Point[] pointArray = new Point[6];
        if (n4 > dimension.width) {
            pointArray[0] = new Point(point.x + n4 - dimension.width, point.y + n5);
            pointArray[1] = new Point(point.x + n4 - dimension.width, point.y + n6);
            pointArray[2] = new Point(point.x, point.y + n6);
            pointArray[3] = new Point(point.x, point.y - n6);
            pointArray[4] = new Point(point.x + n4 - dimension.width, point.y - n6);
            pointArray[5] = new Point(point.x + n4 - dimension.width, point.y - n5);
        } else {
            pointArray[0] = new Point(point.x, point.y + n5);
            pointArray[1] = new Point(point.x, point.y + n6);
            pointArray[2] = new Point(point.x, point.y + n6);
            pointArray[3] = new Point(point.x, point.y - n6);
            pointArray[4] = new Point(point.x, point.y - n6);
            pointArray[5] = new Point(point.x, point.y - n5);
        }
        if (n2 > 0) {
            Primitive.RotatePoints(point, Math.atan((double)n3 / (double)n2), pointArray);
        } else if (n2 < 0) {
            Primitive.RotatePoints(point, Math.PI + Math.atan((double)n3 / (double)n2), pointArray);
        } else if (n3 > 0) {
            Primitive.RotatePoints(point, 1.5707963267948966, pointArray);
        } else {
            Primitive.RotatePoints(point, -1.5707963267948966, pointArray);
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(pointArray[0].x, pointArray[0].y);
        polygon.addPoint(pointArray[1].x, pointArray[1].y);
        polygon.addPoint(pointArray[2].x, pointArray[2].y);
        polygon.addPoint(pointArray[3].x, pointArray[3].y);
        polygon.addPoint(pointArray[4].x, pointArray[4].y);
        polygon.addPoint(pointArray[5].x, pointArray[5].y);
        graphics.fillPolygon(polygon);
    }

    public static void OffsetPoints(Point[] pointArray, int n, int n2) {
        int n3 = 0;
        while (n3 < pointArray.length) {
            pointArray[n3].translate(n, n2);
            ++n3;
        }
    }

    public static void OffsetPoints(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4;
            nArray[n5] = nArray[n5] + n2;
            int n6 = n4++;
            nArray2[n6] = nArray2[n6] + n3;
        }
    }

    public static void vectorDraw(Graphics graphics, Point point, Point point2, Dimension dimension, int n) {
        int n2 = point2.x - point.x;
        int n3 = point2.y - point.y;
        int n4 = (int)Math.round(Math.sqrt(n2 * n2 + n3 * n3));
        if (n4 == 0) {
            return;
        }
        Point[] pointArray = new Point[]{new Point(n4 - n + point.x, point.y), new Point(n4 - dimension.width + point.x, (dimension.height >>> 1) + point.y), new Point(n4 - dimension.width + point.x, -(dimension.height >>> 1) + point.y)};
        if (n2 > 0) {
            Primitive.RotatePoints(point, Math.atan((double)n3 / (double)n2), pointArray);
        } else if (n2 < 0) {
            Primitive.RotatePoints(point, Math.PI + Math.atan((double)n3 / (double)n2), pointArray);
        } else if (n3 > 0) {
            Primitive.RotatePoints(point, 1.5707963267948966, pointArray);
        } else {
            Primitive.RotatePoints(point, -1.5707963267948966, pointArray);
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(pointArray[1].x, pointArray[1].y);
        polygon.addPoint(pointArray[0].x, pointArray[0].y);
        polygon.addPoint(pointArray[2].x, pointArray[2].y);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.fillPolygon(polygon);
    }

    public static void vectorDraw(Graphics graphics, Point point, Point point2, Dimension dimension) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        int n3 = (int)Math.round(Math.sqrt(n * n + n2 * n2));
        if (n3 == 0) {
            return;
        }
        Point[] pointArray = new Point[]{new Point(n3 - dimension.width + point.x, (dimension.height >>> 1) + point.y), new Point(n3 - dimension.width + point.x, -(dimension.height >>> 1) + point.y)};
        if (n > 0) {
            Primitive.RotatePoints(point, Math.atan((double)n2 / (double)n), pointArray);
        } else if (n < 0) {
            Primitive.RotatePoints(point, Math.PI + Math.atan((double)n2 / (double)n), pointArray);
        } else if (n2 > 0) {
            Primitive.RotatePoints(point, 1.5707963267948966, pointArray);
        } else {
            Primitive.RotatePoints(point, -1.5707963267948966, pointArray);
        }
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.drawLine(pointArray[0].x, pointArray[0].y, point2.x, point2.y);
        graphics.drawLine(pointArray[1].x, pointArray[1].y, point2.x, point2.y);
    }

    public static void RotatePoints(Point point, double d, Point[] pointArray) {
        Point point2 = new Point(0, 0);
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n].translate(-point.x, -point.y);
            point2.x = (int)Math.round(d3 * (double)pointArray[n].x - d2 * (double)pointArray[n].y);
            point2.y = (int)Math.round(d2 * (double)pointArray[n].x + d3 * (double)pointArray[n].y);
            pointArray[n].x = point2.x;
            pointArray[n].y = point2.y;
            pointArray[n].translate(point.x, point.y);
            ++n;
        }
    }

    public static void RotatePoints(int n, int n2, double d, int[] nArray, int[] nArray2, int n3) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4;
            nArray[n5] = nArray[n5] - n;
            int n6 = n4;
            nArray2[n6] = nArray2[n6] - n2;
            int n7 = (int)Math.round(d3 * (double)nArray[n4] - d2 * (double)nArray2[n4]);
            int n8 = (int)Math.round(d2 * (double)nArray[n4] + d3 * (double)nArray2[n4]);
            nArray[n4] = n7 + n;
            nArray2[n4] = n8 + n2;
            ++n4;
        }
    }
}

