/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.AButton;
import com.maris.ACommon.AButtonPanel;
import com.maris.ACommon.ASlider;
import com.maris.util.zUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim35
extends Applet
implements Runnable {
    final int NORMAL = 0;
    final int MOUSE_OVER = 1;
    final int PRESSED = 2;
    final int DISABLED = 3;
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected Graphics m_offscreen_graphics1 = null;
    protected Image m_offscreen_image1 = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Image m_sliderImage = null;
    protected Image m_buttonImage0 = null;
    protected Image m_buttonImage1 = null;
    protected Image m_buttonImage2 = null;
    protected Image m_buttonImage3 = null;
    protected Image m_buttonImage4 = null;
    protected Image m_buttonImage5 = null;
    protected Image m_buttonImageCT = null;
    protected AButtonPanel m_button_panel;
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    protected AButton m_ct_button;
    final boolean CHARGE = true;
    final boolean DISCHARGE = false;
    protected boolean m_charge = true;
    final int UP = 0;
    final int DOWN = 1;
    final int FORWARD = 0;
    final int BACK = 1;
    protected int m_direct = 0;
    protected boolean[] m_charge_array = new boolean[201];
    double[] cVoltage = new double[201];
    double[] rCurrent = new double[201];
    int R = 4;
    int C = 2;
    int graphX;
    int index;
    int maxIndex;
    double battVoltage;
    double capVoltage;
    double current;
    double tEff;
    double t;
    double RC;
    double maxCurrent;
    double graphMaxCurrent;
    boolean chargeFlag;
    boolean startFlag;
    protected AGraph35 m_graph1;
    protected Color m_color_green = new Color(0, 153, 51);

    public void init() {
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_offscreen_image1 = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        this.m_offscreen_graphics1 = this.m_offscreen_image1.getGraphics();
        this.m_offscreen_graphics1.setColor(Color.white);
        this.m_offscreen_graphics1.fillRect(0, 0, this.m_width, this.m_height);
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_sliderImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_sliderImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage0 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file3"))));
        if (this.m_buttonImage0 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage5 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file4"))));
        if (this.m_buttonImage5 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage1 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file5"))));
        if (this.m_buttonImage1 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage2 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file6"))));
        if (this.m_buttonImage2 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage3 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file7"))));
        if (this.m_buttonImage3 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage4 = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file8"))));
        if (this.m_buttonImage4 == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImageCT = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file9"))));
        if (this.m_buttonImageCT == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_sliderImage, 1);
        this.m_tracker.addImage(this.m_buttonImage0, 2);
        this.m_tracker.addImage(this.m_buttonImage1, 3);
        this.m_tracker.addImage(this.m_buttonImage2, 4);
        this.m_tracker.addImage(this.m_buttonImage3, 5);
        this.m_tracker.addImage(this.m_buttonImage4, 6);
        this.m_tracker.addImage(this.m_buttonImage5, 7);
        this.m_tracker.addImage(this.m_buttonImageCT, 8);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_slider1 = new ASlider(this.m_sliderImage, 4, 355, 149, 12, 2, 6, 4);
        this.m_slider2 = new ASlider(this.m_sliderImage, 172, 355, 149, 12, 1, 3, 2);
        this.m_ct_button = new AButton(this.m_buttonImageCT, 380, 330, 85, 16);
        this.m_button_panel = new AButtonPanel(10, 367, 98, 28, this.m_buttonImage0, this.m_buttonImage1, this.m_buttonImage2, this.m_buttonImage3, this.m_buttonImage4);
        this.handleButtons(2, 0);
        this.m_graph1 = new AGraph35(280, 140, 2.0E-4, 2.0E-4, 0.04);
    }

    public void run() {
        double deltat = 0.25;
        this.battVoltage = 10.0;
        this.graphMaxCurrent = this.battVoltage / 2.0;
        this.maxIndex = 200;
        this.graphX = 280;
        this.index = 0;
        this.capVoltage = 0.0;
        this.t = 0.0;
        this.current = 0.0;
        this.cVoltage[0] = 0.0;
        this.rCurrent[0] = 0.0;
        while (this.m_thread == Thread.currentThread()) {
            this.RC = this.R * this.C;
            this.maxCurrent = this.battVoltage / (double)this.R;
            while (this.startFlag) {
                double xFactor;
                double totalt;
                if (this.m_direct == 0) {
                    ++this.index;
                }
                if (this.index <= 0) {
                    this.startFlag = false;
                    this.index = 0;
                    this.current = 0.0;
                    break;
                }
                if (this.m_direct == 1) {
                    --this.index;
                    this.t -= deltat;
                    if (this.t < 0.0) {
                        this.t = 0.0;
                    }
                    if (this.m_charge_array[this.index]) {
                        totalt = this.t + this.tEff;
                        xFactor = Math.exp(-totalt / this.RC);
                        this.capVoltage = this.battVoltage * (1.0 - xFactor);
                        this.current = this.maxCurrent * xFactor;
                        break;
                    }
                    totalt = this.t + this.tEff;
                    xFactor = Math.exp(-totalt / this.RC);
                    this.capVoltage = this.battVoltage * xFactor;
                    this.current = -this.maxCurrent * xFactor;
                    break;
                }
                if (this.index >= this.maxIndex) {
                    this.startFlag = false;
                    this.index = this.maxIndex - 1;
                    this.handleButtons(-2, 0);
                }
                if (this.chargeFlag) {
                    this.t += deltat;
                    totalt = this.t + this.tEff;
                    xFactor = Math.exp(-totalt / this.RC);
                    this.capVoltage = this.battVoltage * (1.0 - xFactor);
                    this.current = this.maxCurrent * xFactor;
                } else {
                    this.t += deltat;
                    totalt = this.t + this.tEff;
                    xFactor = Math.exp(-totalt / this.RC);
                    this.capVoltage = this.battVoltage * xFactor;
                    this.current = -this.maxCurrent * xFactor;
                }
                this.cVoltage[this.index] = this.capVoltage;
                this.rCurrent[this.index] = this.current;
                this.m_charge_array[this.index] = this.chargeFlag;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        } else {
            System.out.println("Null graphics");
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.m_bkImage, 0, 0, null);
        if (this.m_direct != 1) {
            this.m_graph1.paint(this.m_offscreen_graphics1);
            this.paintSim(this.m_offscreen_graphics1);
            zUtil.drawImage((Graphics)g, (Image)this.m_offscreen_image1, (int)260, (int)4, (int)504, (int)320, (int)260, (int)4, (int)504, (int)320);
        } else {
            this.m_graph1.paint(g);
            this.paintSim(g);
        }
        g.setColor(Color.black);
        g.drawString(String.valueOf(String.valueOf("Current = ").concat(String.valueOf(ASim35.cutDouble(String.valueOf(this.current), 2)))).concat(String.valueOf(" A")), 40, 260);
        g.drawString(String.valueOf(String.valueOf("Capacitor voltage = ").concat(String.valueOf(ASim35.cutDouble(String.valueOf(this.capVoltage), 2)))).concat(String.valueOf(" V")), 40, 275);
        g.drawString(String.valueOf(String.valueOf("Time = ").concat(String.valueOf(ASim35.cutDouble(String.valueOf(this.t), 1)))).concat(String.valueOf(" s")), 40, 290);
        g.drawString(String.valueOf(String.valueOf("Time constant = ").concat(String.valueOf(this.RC))).concat(String.valueOf(" s")), 40, 305);
        g.drawString("Resistance (ohms)", 10, 330);
        g.drawString("Capacitance (F)", 178, 330);
        this.paintSwitch(g, this.m_charge);
        this.m_ct_button.paint(g);
        this.m_button_panel.paint(g);
        this.m_slider1.paint(g);
        g.drawString(String.valueOf(this.m_slider1.getCurrentValue()), this.m_slider1.getX() + 4, 345);
        this.m_slider2.paint(g);
        g.drawString(String.valueOf(this.m_slider2.getCurrentValue()), this.m_slider2.getX() + 4, 345);
    }

    public boolean mouseUp(Event event, int x, int y) {
        int result = this.m_button_panel.onMouseUp(x, y);
        this.takeAction(result);
        this.handleButtons(result, 0);
        if (this.m_ct_button.onMouseUp(x, y)) {
            this.m_offscreen_graphics1.setColor(Color.white);
            this.m_offscreen_graphics1.fillRect(0, 0, this.m_width, this.m_height);
        }
        this.m_slider1.onMouseUp(x, y);
        this.m_slider2.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        int result = this.m_button_panel.onMouseDown(x, y);
        this.m_ct_button.onMouseDown(x, y);
        this.handleButtons(result, 1);
        this.m_slider1.onMouseDown(x, y);
        this.m_slider2.onMouseDown(x, y);
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        this.m_ct_button.onMouseMove(x, y);
        this.m_button_panel.onMouseMove(x, y);
        this.m_slider1.onMouseMove(x, y);
        this.m_slider2.onMouseMove(x, y);
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        if (this.m_slider1.onMouseDrag(x, y)) {
            this.R = this.m_slider1.getCurrentValue();
        }
        if (this.m_slider2.onMouseDrag(x, y)) {
            this.C = this.m_slider2.getCurrentValue();
        }
        return false;
    }

    public static String cutDouble(String value, int num) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + num) {
            return value.substring(0, index + num + 1);
        }
        return value;
    }

    public void paintSim(Graphics g) {
        int i;
        g.setColor(Color.blue);
        for (i = 0; i < this.index; ++i) {
            g.drawLine(this.graphX + i, 260 - (int)(40.0 * this.rCurrent[i] / this.graphMaxCurrent), this.graphX + i + 1, 260 - (int)(40.0 * this.rCurrent[i + 1] / this.graphMaxCurrent));
        }
        g.setColor(this.m_color_green);
        for (i = 0; i < this.index; ++i) {
            g.drawLine(this.graphX + i, 140 - (int)(80.0 * this.cVoltage[i] / this.battVoltage), this.graphX + i + 1, 140 - (int)(80.0 * this.cVoltage[i + 1] / this.battVoltage));
        }
    }

    public boolean takeAction(int button_id) {
        if (button_id == 0) {
            this.t = 0.0;
            if (!this.m_charge) {
                this.chargeFlag = false;
                if (this.startFlag) {
                    this.tEff = this.RC * Math.log(this.battVoltage / this.capVoltage);
                } else {
                    this.startFlag = true;
                    this.tEff = 0.0;
                }
            } else {
                this.chargeFlag = true;
                if (this.startFlag) {
                    this.tEff = this.RC * Math.log(this.battVoltage / (this.battVoltage - this.capVoltage));
                } else {
                    this.startFlag = true;
                    this.tEff = 0.0;
                }
            }
            this.m_charge = !this.m_charge;
        } else if (button_id == 2) {
            this.startFlag = false;
            this.chargeFlag = false;
            this.tEff = 0.0;
            this.index = 0;
            this.capVoltage = 0.0;
            this.t = 0.0;
            this.current = 0.0;
            this.cVoltage[0] = 0.0;
            this.rCurrent[0] = 0.0;
            this.m_charge = true;
        }
        if (button_id == 1) {
            this.startFlag = !this.startFlag;
        }
        return true;
    }

    protected void handleButtons(int button_id, int action) {
        switch (button_id) {
            case -2: {
                this.m_button_panel.setButtonState(0, 3);
                this.m_button_panel.setButtonState(1, 3);
                this.m_button_panel.setButtonState(3, 3);
                this.m_button_panel.setButtonState(4, 3);
                break;
            }
            case 0: {
                if (action != 0) break;
                this.m_button_panel.setButtonState(1, 0);
                if (!this.m_charge) {
                    this.m_button_panel.setButtonImage(0, this.m_buttonImage5);
                } else {
                    this.m_button_panel.setButtonImage(0, this.m_buttonImage0);
                }
                this.m_slider1.setActive(false);
                this.m_slider2.setActive(false);
                break;
            }
            case 1: {
                if (action != 0) break;
                if (!this.startFlag) {
                    this.m_button_panel.setButtonState(0, 3);
                    this.m_button_panel.setButtonState(3, 0);
                    this.m_button_panel.setButtonState(4, 0);
                    break;
                }
                this.m_button_panel.setButtonState(0, 0);
                this.m_button_panel.setButtonState(3, 3);
                this.m_button_panel.setButtonState(4, 3);
                break;
            }
            case 2: {
                if (action != 0) break;
                this.m_charge = true;
                this.m_button_panel.setButtonState(0, 0);
                this.m_button_panel.setButtonState(1, 3);
                this.m_button_panel.setButtonState(3, 3);
                this.m_button_panel.setButtonState(4, 3);
                this.m_button_panel.setButtonImage(0, this.m_buttonImage0);
                this.m_slider1.setActive(true);
                this.m_slider2.setActive(true);
                break;
            }
            case 3: {
                if (action == 1) {
                    this.m_direct = 1;
                    this.startFlag = true;
                }
                if (action != 0) break;
                this.m_direct = 0;
                this.startFlag = false;
                break;
            }
            case 4: {
                if (action == 1) {
                    this.startFlag = true;
                }
                if (action != 0) break;
                this.startFlag = false;
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void paintSwitch(Graphics g, boolean mode) {
        g.setColor(Color.red);
        if (!mode) {
            g.drawLine(89, 221, 60, 221);
            g.drawLine(89, 222, 60, 222);
        } else {
            g.drawLine(89, 221, 73, 195);
            g.drawLine(88, 221, 72, 195);
        }
        g.setColor(Color.yellow);
        g.fillOval(87, 219, 4, 4);
        g.setColor(Color.black);
        g.drawOval(87, 219, 4, 4);
    }

    public static void drawImageSpec(Graphics _gr, Image _img, Color color, int _dstL, int _dstT, int _dstR, int _dstB, int _srcL, int _srcT, int _srcR, int _srcB) {
        try {
            _gr.drawImage(_img, _dstL, _dstT, _dstR, _dstB, _srcL, _srcT, _srcR, _srcB, color, null);
        }
        catch (NoSuchMethodError err) {
            int dw = _dstR - _dstL;
            int dh = _dstB - _dstT;
            int sw = _srcR - _srcL;
            int sh = _srcB - _srcT;
            Graphics gr = _gr.create(_dstL, _dstT, dw, dh);
            if (dw == sw && dh == sh) {
                gr.drawImage(_img, -_srcL, -_srcT, color, null);
            } else {
                double kx = (double)dw / (double)sw;
                double ky = (double)dh / (double)sh;
                gr.drawImage(_img, (int)((double)(-_srcL) * kx), (int)((double)(-_srcT) * ky), (int)((double)_img.getWidth(null) * kx), (int)((double)_img.getHeight(null) * ky), color, null);
            }
            gr.dispose();
        }
    }
}

