/*
 * Decompiled with CFR 0.152.
 */
import com.maris.awt.RadioButtons;
import com.maris.awt.Slider;
import com.maris.awt.advImageButton;
import com.maris.awt.zImageButton;
import com.maris.util.zUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import java.util.Vector;

public class Sim28
extends Applet
implements Runnable {
    protected Color m_stringColor = null;
    protected Color m_cylColor = new Color(140, 198, 239);
    protected Thread m_loadData = null;
    protected Thread m_showWarning = null;
    protected Graphics m_gr = null;
    private Graphics backGC = null;
    private Image backBuffer = null;
    protected int m_loadProgress = 0;
    private Image m_bgImage = null;
    private Image m_rbImage = null;
    private Image m_sdImage = null;
    private Image m_resetImage = null;
    private Image m_fwImage = null;
    private Image m_bwImage = null;
    private Image m_pressImage = null;
    private Image m_cleartraceImage = null;
    private Slider m_sdHeat = null;
    private zImageButton m_reset = null;
    private zImageButton m_cleartrace = null;
    private advImageButton m_fw = null;
    private advImageButton m_bw = null;
    private RadioButtons m_rbHeat = null;
    private RadioButtons m_rbConstant = null;
    private Component m_btAddHeat = null;
    private Component m_btRemHeat = null;
    private Component m_btPresConst = null;
    private Component m_btVolConst = null;
    private Component m_btTempConst = null;
    private int appWidth;
    private int appHeight;
    private Font font12 = null;
    private static final int xS0 = 244;
    private static final int yS0 = 24;
    private static final int xSMin = 236;
    private static final int xSMax = 252;
    private static final int cacheLen = 200;
    private static final int xOrigin = 22;
    private static final int yOrigin = 203;
    private static final int Paxis = 190;
    private static final int Vaxis = 190;
    private static final int xCylinder = 221;
    private static final int yCylinder = 254;
    private static final int wCylinder = 45;
    private static final double initP = 200000.0;
    private static final double initV = 4.0E-4;
    private static final double initT = 273.0;
    private static final double maxP = 600000.0;
    private static final double maxV = 0.002;
    private static final double nR = 0.29304029304029305;
    private static final double factorV = 95000.0;
    private static final double factorP = 3.1666666666666665E-4;
    private static final double factorCld = 100000.0;
    protected Vector m_stepList = new Vector();
    private int heat = 50;
    private int[] pPoint = new int[200];
    private int[] vPoint = new int[200];
    private int index = 0;
    private int maxIndex = 199;
    boolean m_warning = false;
    private String m_mediaBase = null;

    private synchronized void newBackBuffer() {
        this.backBuffer = this.getParent().createImage(this.appWidth, this.appHeight);
        this.font12 = zUtil.sysIsMacOS() && zUtil.sysIsNetscape() ? new Font("Arial", 0, 11) : new Font("Arial", 0, 12);
        if (this.backBuffer != null) {
            this.backGC = this.backBuffer.getGraphics();
            this.backGC.setFont(this.font12);
        } else {
            this.backGC = this.getGraphics();
        }
        this.backGC.setColor(Color.yellow);
    }

    public void DrawSpring(int n) {
        this.backGC.setColor(Color.black);
        double d = (double)(n - 24) * 0.05;
        double d2 = 24.0;
        double d3 = d2 + d;
        this.backGC.drawLine(244, (int)d2, 252, (int)d3);
        int n2 = 0;
        do {
            d2 = d3 + d;
            this.backGC.drawLine(252, (int)d3, 236, (int)d2);
            d3 = d2 + d;
            this.backGC.drawLine(236, (int)d2, 252, (int)d3);
        } while (++n2 < 9);
        this.backGC.drawLine(252, (int)d3, 244, (int)(d3 + d));
    }

    public void paint(Graphics graphics) {
        if (this.backBuffer != null) {
            StepData stepData = (StepData)this.m_stepList.lastElement();
            double d = stepData.m_V;
            double d2 = stepData.m_P;
            double d3 = stepData.m_T;
            double d4 = stepData.m_U;
            double d5 = stepData.m_Q;
            double d6 = stepData.m_W;
            double d7 = stepData.m_dU;
            this.backGC.drawImage(this.m_bgImage, 0, 0, this);
            int n = (int)(100000.0 * d);
            int n2 = 254 - n - 14;
            this.DrawSpring(n2);
            this.backGC.drawImage(this.m_pressImage, 220, n2, this);
            this.backGC.setColor(this.m_cylColor);
            this.backGC.fillRect(221, 254 - n, 45, n);
            this.backGC.setColor(Color.red);
            zUtil.drawPolyline((Graphics)this.backGC, (int[])this.vPoint, (int[])this.pPoint, (int)(this.index + 1));
            this.backGC.setColor(Color.black);
            this.backGC.fillRect(this.vPoint[this.index] - 2, this.pPoint[this.index] - 2, 4, 4);
            this.backGC.drawString(String.valueOf(this.heat), 396, 150);
            this.backGC.drawString(zUtil.formatDouble((double)(d2 * 0.001), (int)2), 364, 196);
            this.backGC.drawString(zUtil.formatDouble((double)(d * 100000.0), (int)2), 364, 216);
            this.backGC.drawString(zUtil.formatDouble((double)d3, (int)2), 364, 236);
            this.backGC.drawString(zUtil.formatDouble((double)d5, (int)2), 462, 196);
            this.backGC.drawString(zUtil.formatDouble((double)d6, (int)2), 462, 216);
            this.backGC.drawString(zUtil.formatDouble((double)d7, (int)2), 462, 236);
            this.backGC.drawString(zUtil.formatDouble((double)d4, (int)2), 418, 256);
            this.m_sdHeat.draw(this.backGC);
            if (this.m_warning) {
                this.backGC.setColor(Color.white);
                this.backGC.fillRect(10, 80, 205, 45);
                this.backGC.setColor(Color.black);
                this.backGC.drawRect(10, 80, 205, 45);
                this.backGC.setColor(Color.red);
                this.backGC.drawString("Sorry, step is out of graph!", 20, 100);
                this.backGC.drawString("Change parameters and try again.", 20, 115);
            }
            graphics.drawImage(this.backBuffer, 0, 0, this);
            return;
        }
        graphics.setColor(this.m_stringColor);
        String string = "Loading media";
        int n = 0;
        while (n < this.m_loadProgress) {
            string = string + " .";
            ++n;
        }
        graphics.drawRect(0, 0, this.appWidth - 1, this.appHeight - 1);
        graphics.drawString(string, 20, 20);
    }

    protected boolean IsChangeCursor(zImageButton zImageButton2, int n, int n2) {
        Point point = zImageButton2.location();
        return zImageButton2.isEnabled() && zImageButton2.inside(n - point.x, n2 - point.y);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.mouseMove(event, n, n2);
        return true;
    }

    protected boolean IsChangeCursor(Slider slider, int n, int n2) {
        return slider.isEnabled() && slider.inside(n, n2);
    }

    protected boolean IsChangeCursor(RadioButtons radioButtons, int n, int n2) {
        return radioButtons.isEnabled() && radioButtons.inside();
    }

    public void destroy() {
        this.removeAll();
        this.m_loadData = null;
        this.backGC = null;
        this.backBuffer = null;
        this.m_bgImage = null;
        this.m_sdImage = null;
        this.m_rbImage = null;
        this.m_resetImage = null;
        this.m_fwImage = null;
        this.m_bwImage = null;
        this.m_pressImage = null;
        this.m_cleartraceImage = null;
        this.m_reset = null;
        this.m_cleartrace = null;
        this.m_fw = null;
        this.m_bw = null;
        this.m_btAddHeat = null;
        this.m_btRemHeat = null;
        this.m_btPresConst = null;
        this.m_btVolConst = null;
        this.m_btTempConst = null;
        this.m_rbHeat = null;
        this.m_rbConstant = null;
    }

    protected boolean InitData() {
        this.m_stepList.removeAllElements();
        this.m_stepList.addElement(new StepData(200000.0, 4.0E-4, 273.0, 120.0, this.heat, 0.0, 0.0, 0));
        this.index = 0;
        this.vPoint[0] = 60;
        this.pPoint[0] = 140;
        this.m_warning = false;
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected Thread CreateWarningThread() {
        ShowWarning showWarning = new ShowWarning();
        showWarning.start();
        this.m_warning = true;
        return showWarning;
    }

    public void Forward() {
        StepData stepData = (StepData)this.m_stepList.lastElement();
        double d = this.m_rbHeat.GetActiveIndex() == 0 ? this.heat : -this.heat;
        double d2 = stepData.m_V;
        double d3 = stepData.m_P;
        double d4 = stepData.m_T;
        double d5 = stepData.m_U;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = 1;
        if (this.m_rbConstant.GetActiveIndex() == 0) {
            double d8 = 0.4 * d / 0.29304029304029305;
            d7 = 1.5 * (d6 += 0.29304029304029305 * d8);
            d5 += 0.43956043956043955 * d8;
            d2 = 0.29304029304029305 * (d4 += d8) / d3;
            this.IncIndex();
            this.vPoint[this.index] = 22 + (int)(95000.0 * d2);
            this.pPoint[this.index] = 203 - (int)(3.1666666666666665E-4 * d3);
            if (d2 <= 0.0 || d2 > 0.002) {
                this.index += -1;
                this.m_showWarning = this.CreateWarningThread();
                this.m_fw.stop();
                return;
            }
        } else if (this.m_rbConstant.GetActiveIndex() == 1) {
            d7 += d;
            d4 = 0.6666 * (d5 += d) / 0.29304029304029305;
            d3 = 0.6666 * d5 / d2;
            this.IncIndex();
            this.vPoint[this.index] = 22 + (int)(95000.0 * d2);
            this.pPoint[this.index] = 203 - (int)(3.1666666666666665E-4 * d3);
            if (d3 <= 0.0 || d3 > 600000.0) {
                this.index += -1;
                this.m_showWarning = this.CreateWarningThread();
                this.m_fw.stop();
                return;
            }
        } else if (this.m_rbConstant.GetActiveIndex() == 2) {
            double d9 = d2;
            int n2 = 0;
            do {
                d2 = d9 * Math.exp((d6 += 0.1 * d) / (0.29304029304029305 * d4));
                d3 = 0.29304029304029305 * d4 / d2;
                this.IncIndex();
                this.vPoint[this.index] = 22 + (int)(95000.0 * d2);
                this.pPoint[this.index] = 203 - (int)(3.1666666666666665E-4 * d3);
                if (!(d3 <= 0.0 || d3 > 600000.0 || d2 <= 0.0) && !(d2 > 0.002)) continue;
                this.index = this.index - n2 - 1;
                this.m_showWarning = this.CreateWarningThread();
                this.m_fw.stop();
                return;
            } while (++n2 < 10);
            n = 10;
        }
        this.m_stepList.addElement(new StepData(d3, d2, d4, d5, d, d6, d7, n));
    }

    public void Backward() {
        if (!this.isLimitStart()) {
            this.index -= ((StepData)this.m_stepList.lastElement()).m_dec;
            this.m_stepList.removeElementAt(this.m_stepList.size() - 1);
            this.heat = (int)Math.abs(((StepData)this.m_stepList.lastElement()).m_Q);
            this.m_sdHeat.setPosition(((double)this.heat - 1.0) / 99.0);
        }
    }

    public boolean action(Event event, Object object) {
        if (this.m_reset == object) {
            this.m_bw.disable();
            this.InitData();
            this.repaint();
        } else if (this.m_fw == object) {
            this.Forward();
            this.m_bw.enable();
            this.repaint();
        } else if (this.m_bw == object) {
            this.Backward();
            if (this.isLimitStart()) {
                this.m_bw.disable();
                this.m_bw.stop();
            }
            this.repaint();
        } else if (this.m_cleartrace == object) {
            this.m_bw.disable();
            StepData stepData = (StepData)this.m_stepList.lastElement();
            double d = stepData.m_V;
            double d2 = stepData.m_P;
            double d3 = stepData.m_T;
            double d4 = stepData.m_U;
            double d5 = stepData.m_Q;
            double d6 = stepData.m_W;
            double d7 = stepData.m_dU;
            this.m_stepList.removeAllElements();
            this.m_stepList.addElement(new StepData(d2, d, d3, d4, d5, d6, d7, 0));
            this.vPoint[0] = this.vPoint[this.index];
            this.pPoint[0] = this.pPoint[this.index];
            this.index = 0;
            this.m_warning = false;
            this.repaint();
        } else if (this.m_sdHeat == object) {
            this.heat = (int)Math.round(1.0 + 99.0 * ((Slider)object).getPosition());
            this.repaint();
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdHeat.mouseDown(n, n2);
        }
        return true;
    }

    public void run() {
        this.m_loadProgress = 0;
        this.m_bgImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file1")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_sdImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file2")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_rbImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file3")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_resetImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file4")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_fwImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file5")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_bwImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file6")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_pressImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file7")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_cleartraceImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file8")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_reset = new zImageButton(this.m_resetImage);
        this.add((Component)this.m_reset);
        this.m_reset.reshape(205, 268, this.m_resetImage.getWidth(this), this.m_resetImage.getHeight(this) >>> 2);
        this.m_reset.hide();
        this.m_cleartrace = new zImageButton(this.m_cleartraceImage);
        this.add((Component)this.m_cleartrace);
        this.m_cleartrace.reshape(75, 233, this.m_cleartraceImage.getWidth(this), this.m_cleartraceImage.getHeight(this) >>> 2);
        this.m_cleartrace.hide();
        this.m_fw = new advImageButton(this.m_fwImage, 500L, 50L);
        this.add((Component)this.m_fw);
        this.m_fw.reshape(403, 268, this.m_fwImage.getWidth(this), this.m_fwImage.getHeight(this) >>> 2);
        this.m_fw.hide();
        this.m_bw = new advImageButton(this.m_bwImage, 500L, 50L);
        this.add((Component)this.m_bw);
        this.m_bw.reshape(304, 268, this.m_bwImage.getWidth(this), this.m_bwImage.getHeight(this) >>> 2);
        this.m_bw.hide();
        this.m_sdHeat = new Slider(this.m_sdImage, 332, 162, 486, 162, (Container)this);
        this.m_sdHeat.setPosition(0.494949494949495);
        this.m_sdHeat.show();
        this.m_rbHeat = new RadioButtons();
        this.m_btAddHeat = this.m_rbHeat.Add(this.m_rbImage, 343, 75, (Container)this);
        this.m_btRemHeat = this.m_rbHeat.Add(this.m_rbImage, 343, 95, (Container)this);
        this.m_rbHeat.hide();
        this.m_rbHeat.SetActive(this.m_btAddHeat);
        this.m_rbConstant = new RadioButtons();
        this.m_btPresConst = this.m_rbConstant.Add(this.m_rbImage, 343, 7, (Container)this);
        this.m_btVolConst = this.m_rbConstant.Add(this.m_rbImage, 343, 27, (Container)this);
        this.m_btTempConst = this.m_rbConstant.Add(this.m_rbImage, 343, 47, (Container)this);
        this.m_rbConstant.hide();
        this.m_rbConstant.SetActive(this.m_btPresConst);
        this.InitData();
        this.newBackBuffer();
        if (zUtil.sysIsMacOS()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.repaint();
        this.m_reset.show();
        this.m_cleartrace.show();
        this.m_fw.show();
        this.m_bw.show();
        this.m_bw.disable();
        this.m_rbHeat.show();
        this.m_rbConstant.show();
    }

    public void init() {
        Color color;
        this.setLayout(null);
        this.appHeight = this.size().height;
        this.appWidth = this.size().width;
        this.m_gr = this.getGraphics();
        String string = this.getParameter("background");
        if (string != null && (color = zUtil.parseHTMLColor((String)string)) != null) {
            this.setBackground(color);
            this.m_stringColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        this.m_mediaBase = this.getParameter("mediabase");
        if (this.m_mediaBase == null) {
            this.m_mediaBase = "";
        }
        this.m_loadData = new Thread(this);
        this.m_loadData.start();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdHeat.mouseDrag(n, n2);
        }
        return true;
    }

    protected void IncIndex() {
        ++this.index;
        if (this.index > this.maxIndex) {
            int n = this.maxIndex + 1;
            int n2 = n + 200;
            int[] nArray = new int[n2];
            System.arraycopy(this.pPoint, 0, nArray, 0, n);
            int[] nArray2 = new int[n2];
            System.arraycopy(this.vPoint, 0, nArray2, 0, n);
            this.maxIndex += 200;
            this.pPoint = nArray;
            this.vPoint = nArray2;
        }
    }

    protected boolean isLimitStart() {
        return this.m_stepList.size() <= 1;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdHeat.mouseMove(n, n2);
            Container container = this.getParent();
            if (container instanceof Frame) {
                if (this.IsChangeCursor(this.m_sdHeat, n, n2) || this.IsChangeCursor(this.m_rbHeat, n, n2) || this.IsChangeCursor(this.m_rbConstant, n, n2) || this.IsChangeCursor(this.m_reset, n, n2) || this.IsChangeCursor(this.m_cleartrace, n, n2) || this.IsChangeCursor((zImageButton)this.m_bw, n, n2) || this.IsChangeCursor((zImageButton)this.m_fw, n, n2)) {
                    ((Frame)container).setCursor(12);
                } else {
                    ((Frame)container).setCursor(0);
                }
            }
        }
        return true;
    }

    class StepData {
        double m_P;
        double m_V;
        double m_T;
        double m_U;
        double m_Q;
        double m_W;
        double m_dU;
        int m_dec;

        StepData(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n) {
            Sim28.this.getClass();
            this.m_P = d;
            this.m_V = d2;
            this.m_T = d3;
            this.m_U = d4;
            this.m_Q = d5;
            this.m_W = d6;
            this.m_dU = d7;
            this.m_dec = n;
        }
    }

    protected class ShowWarning
    extends Thread {
        public ShowWarning() {
            Sim28.this.getClass();
        }

        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            Sim28.this.m_warning = false;
            Sim28.this.repaint();
        }
    }
}

