/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ARbGroup;
import com.maris.ACommon.ASlider;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim49
extends Applet
implements Runnable {
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Image m_sliderImage = null;
    protected Image[] m_buttonImage;
    protected Image m_rbImage = null;
    protected ABP49 m_button_panel;
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    protected ASlider m_slider3;
    protected ARbGroup m_rb_group;
    int frequency = 1;
    int intensity = 40;
    int voltage;
    int choice;
    double freq;
    double intense;
    double v;
    double h;
    double current;
    double KEmax;
    double vMax;
    double fMax;
    double[] W = new double[3];
    double[] slope = new double[3];
    double[] intercept = new double[3];
    double[] fThresh = new double[3];
    int[] index = new int[3];
    double[][] pointsX = new double[3][20];
    double[][] pointsY = new double[3][20];
    double[][] linesX = new double[3][2];
    double[][] linesY = new double[3][2];
    final int ALUMINIUM = 0;
    final int SILVER = 1;
    final int SODIUM = 2;
    protected int m_material = 0;
    protected AMessage m_message;
    protected int m_mess_counter = 0;

    public void init() {
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_buttonImage = new Image[4];
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_sliderImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_sliderImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_rbImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file3"))));
        if (this.m_rbImage == null) {
            System.out.println("Couldn't find radio button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage[0] = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file4"))));
        if (this.m_buttonImage[0] == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage[1] = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file5"))));
        if (this.m_buttonImage[1] == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage[2] = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file6"))));
        if (this.m_buttonImage[2] == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_buttonImage[3] = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file7"))));
        if (this.m_buttonImage[3] == null) {
            System.out.println("Couldn't find button image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_sliderImage, 1);
        this.m_tracker.addImage(this.m_buttonImage[0], 2);
        this.m_tracker.addImage(this.m_buttonImage[1], 3);
        this.m_tracker.addImage(this.m_buttonImage[2], 4);
        this.m_tracker.addImage(this.m_buttonImage[3], 5);
        this.m_tracker.addImage(this.m_rbImage, 7);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_button_panel = new ABP49(4, 367, this.m_buttonImage, ABP49.HOR);
        this.m_slider1 = new ASlider(this.m_sliderImage, 4, 355, 149, 12, 1, 20, 1);
        this.m_slider2 = new ASlider(this.m_sliderImage, 172, 355, 149, 12, 20, 60, 40);
        this.m_slider3 = new ASlider(this.m_sliderImage, 340, 355, 149, 12, 0, 60, 0);
        this.m_rb_group = new ARbGroup(this.m_rbImage, 30, 200, 13, 20, 3, 0, 1);
        this.m_message = new AMessage(175, 125, 200, 140);
    }

    public void run() {
        this.h = 4.13608E-15;
        this.vMax = 6.0;
        this.fMax = 2.0E15;
        this.W[0] = 4.08;
        this.W[1] = 4.73;
        this.W[2] = 2.28;
        this.choice = 0;
        for (int i = 0; i < 3; ++i) {
            this.fThresh[i] = this.W[i] / this.h;
            this.index[i] = -1;
            this.linesX[i][1] = 0.0;
            this.linesX[i][0] = 0.0;
            this.linesY[i][1] = 0.0;
            this.linesY[i][0] = 0.0;
        }
        while (this.m_thread == Thread.currentThread()) {
            this.freq = (double)this.frequency * 1.0E14;
            this.intense = this.intensity;
            this.v = 0.1 * (double)this.voltage;
            this.choice = this.m_material;
            if (this.freq > this.fThresh[this.choice]) {
                this.KEmax = this.h * this.freq - this.W[this.choice];
                this.current = this.intense * (this.KEmax - this.v) * (this.freq - this.fThresh[this.choice]) * 1.0E-16;
                if (this.current < 0.0) {
                    this.current = 0.0;
                }
            } else {
                this.current = 0.0;
            }
            this.turnOffMessage();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        } else {
            System.out.println("Null graphics");
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.m_bkImage, 0, 0, null);
        this.paintSim(g);
        this.m_button_panel.paint(g);
        this.m_slider1.paint(g);
        this.m_slider2.paint(g);
        this.m_slider3.paint(g);
        g.drawString(String.valueOf(this.m_slider1.getCurrentValue()), this.m_slider1.getX() + 4, 345);
        g.drawString(String.valueOf(this.m_slider2.getCurrentValue()), this.m_slider2.getX() + 4, 345);
        g.drawString(ASim49.cutDouble(String.valueOf((double)this.m_slider3.getCurrentValue() / 10.0)), this.m_slider3.getX() + 4, 345);
        this.m_rb_group.paint(g);
        this.m_message.paint(g);
    }

    public boolean mouseUp(Event event, int x, int y) {
        int result = this.m_button_panel.onMouseUp(x, y);
        this.takeAction(result);
        this.m_slider1.onMouseUp(x, y);
        this.m_slider2.onMouseUp(x, y);
        this.m_slider3.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        int result = this.m_button_panel.onMouseDown(x, y);
        this.m_slider1.onMouseDown(x, y);
        this.m_slider2.onMouseDown(x, y);
        this.m_slider3.onMouseDown(x, y);
        if (this.m_rb_group.onMouseDown(x, y)) {
            this.m_material = this.m_rb_group.getActiveButton();
        }
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        this.m_button_panel.onMouseMove(x, y);
        this.m_slider1.onMouseMove(x, y);
        this.m_slider2.onMouseMove(x, y);
        this.m_slider3.onMouseMove(x, y);
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        if (this.m_slider1.onMouseDrag(x, y)) {
            this.frequency = this.m_slider1.getCurrentValue();
        }
        if (this.m_slider2.onMouseDrag(x, y)) {
            this.intensity = this.m_slider2.getCurrentValue();
        }
        if (this.m_slider3.onMouseDrag(x, y)) {
            this.voltage = this.m_slider3.getCurrentValue();
        }
        return false;
    }

    public static String cutDouble(String value) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + 2) {
            return value.substring(0, index + 3);
        }
        return value;
    }

    public void paintSim(Graphics g) {
        int i;
        int xOrigin = 270;
        int xSpan = 180;
        int yOrigin = 150;
        int ySpan = 90;
        g.setColor(Color.red);
        for (i = 0; i <= this.index[0]; ++i) {
            g.fillRect(xOrigin + (int)((double)xSpan * this.pointsX[0][i] / this.fMax) - 3, yOrigin - (int)((double)ySpan * this.pointsY[0][i] / this.vMax) - 3, 6, 6);
        }
        g.drawLine(xOrigin + (int)((double)xSpan * this.linesX[0][0] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[0][0] / this.vMax), xOrigin + (int)((double)xSpan * this.linesX[0][1] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[0][1] / this.vMax));
        if (this.choice == 0 && this.linesX[0][1] > 0.0) {
            g.drawString(String.valueOf(String.valueOf("Slope = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.slope[this.choice]))))).concat(String.valueOf(" eV s")), xOrigin - 5, 270);
            g.drawString(String.valueOf(String.valueOf("Intercept = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.intercept[this.choice]))))).concat(String.valueOf(" eV")), xOrigin - 5, 285);
        }
        g.setColor(Color.blue);
        for (i = 0; i <= this.index[1]; ++i) {
            g.fillOval(xOrigin + (int)((double)xSpan * this.pointsX[1][i] / this.fMax) - 3, yOrigin - (int)((double)ySpan * this.pointsY[1][i] / this.vMax) - 3, 6, 6);
        }
        g.drawLine(xOrigin + (int)((double)xSpan * this.linesX[1][0] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[1][0] / this.vMax), xOrigin + (int)((double)xSpan * this.linesX[1][1] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[1][1] / this.vMax));
        if (this.choice == 1 && this.linesX[1][1] > 0.0) {
            g.drawString(String.valueOf(String.valueOf("Slope = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.slope[this.choice]))))).concat(String.valueOf(" eV s")), xOrigin - 5, 270);
            g.drawString(String.valueOf(String.valueOf("Intercept = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.intercept[this.choice]))))).concat(String.valueOf(" eV")), xOrigin - 5, 285);
        }
        g.setColor(Color.green);
        for (i = 0; i <= this.index[2]; ++i) {
            g.drawLine(xOrigin + (int)((double)xSpan * this.pointsX[2][i] / this.fMax) - 3, yOrigin - (int)((double)ySpan * this.pointsY[2][i] / this.vMax) - 3, xOrigin + (int)((double)xSpan * this.pointsX[2][i] / this.fMax) + 3, yOrigin - (int)((double)ySpan * this.pointsY[2][i] / this.vMax) + 3);
            g.drawLine(xOrigin + (int)((double)xSpan * this.pointsX[2][i] / this.fMax) - 3, yOrigin - (int)((double)ySpan * this.pointsY[2][i] / this.vMax) + 3, xOrigin + (int)((double)xSpan * this.pointsX[2][i] / this.fMax) + 3, yOrigin - (int)((double)ySpan * this.pointsY[2][i] / this.vMax) - 3);
        }
        g.drawLine(xOrigin + (int)((double)xSpan * this.linesX[2][0] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[2][0] / this.vMax), xOrigin + (int)((double)xSpan * this.linesX[2][1] / this.fMax), yOrigin - (int)((double)ySpan * this.linesY[2][1] / this.vMax));
        if (this.choice == 2 && this.linesX[2][1] > 0.0) {
            g.drawString(String.valueOf(String.valueOf("Slope = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.slope[this.choice]))))).concat(String.valueOf(" eV s")), xOrigin - 5, 270);
            g.drawString(String.valueOf(String.valueOf("Intercept = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.intercept[this.choice]))))).concat(String.valueOf(" eV")), xOrigin - 5, 285);
        }
        g.setColor(Color.black);
        g.drawString(String.valueOf(String.valueOf("Voltage = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.v))))).concat(String.valueOf(" V")), 25, 280);
        g.drawString(String.valueOf(String.valueOf("Current = ").concat(String.valueOf(ASim49.cutDouble(String.valueOf(this.current))))).concat(String.valueOf(" mA")), 25, 300);
        g.drawString("Aluminium plate", 55, 212);
        g.drawString("Silver plate", 55, 232);
        g.drawString("Sodium plate", 55, 252);
        switch (this.m_material) {
            case 0: {
                g.setColor(Color.red);
                break;
            }
            case 1: {
                g.setColor(Color.blue);
                break;
            }
            case 2: {
                g.setColor(Color.green);
            }
        }
        g.fillRect(16, 112, 33, 10);
        g.setColor(Color.black);
    }

    public boolean takeAction(int button) {
        block10: {
            if (button == 0) {
                if (this.current > 1.0) {
                    this.m_message.setActive(true, "Increase the voltage until the current drops to zero.");
                    return false;
                }
                if (this.index[this.choice] < 19) {
                    this.index[this.choice] = this.index[this.choice] + 1;
                    this.pointsX[this.choice][this.index[this.choice]] = this.freq;
                    this.pointsY[this.choice][this.index[this.choice]] = this.v;
                } else {
                    this.m_message.setActive(true, "The maximum number of points has been reached");
                }
            }
            if (button == 1) {
                if (this.index[this.choice] > -1) {
                    this.index[this.choice] = this.index[this.choice] - 1;
                }
                this.linesX[this.choice][1] = 0.0;
                this.linesX[this.choice][0] = 0.0;
                this.linesY[this.choice][1] = 0.0;
                this.linesY[this.choice][0] = 0.0;
            }
            if (button == 2) {
                double sumXsq = 0.0;
                double sumXY = 0.0;
                double sumY = 0.0;
                double sumX = 0.0;
                int N = 0;
                int check_num = 0;
                for (int i = 0; i <= this.index[this.choice]; ++i) {
                    if (this.pointsY[this.choice][i] > 0.0) {
                        ++N;
                        sumX += this.pointsX[this.choice][i];
                        sumY += this.pointsY[this.choice][i];
                        sumXY += this.pointsX[this.choice][i] * this.pointsY[this.choice][i];
                        sumXsq += this.pointsX[this.choice][i] * this.pointsX[this.choice][i];
                        ++check_num;
                    }
                    if (N <= 1) continue;
                    this.slope[this.choice] = ((double)N * sumXY - sumX * sumY) / ((double)N * sumXsq - sumX * sumX);
                    this.intercept[this.choice] = (sumXsq * sumY - sumX * sumXY) / ((double)N * sumXsq - sumX * sumX);
                    this.linesY[this.choice][0] = this.intercept[this.choice];
                    this.linesX[this.choice][1] = this.fMax;
                    this.linesY[this.choice][1] = this.slope[this.choice] * this.fMax + this.intercept[this.choice];
                }
                if (check_num < 2) {
                    this.m_message.setActive(true, "There are not enough points to do the fit");
                }
            }
            if (button != 3) break block10;
            this.clearGraph();
        }
        return true;
    }

    public void turnOffMessage() {
        if (!this.m_message.getActive()) {
            return;
        }
        ++this.m_mess_counter;
        if (this.m_mess_counter == 50) {
            this.m_mess_counter = 0;
            this.m_message.setActive(false, null);
        }
    }

    protected void clearGraph() {
        for (int count = 0; count < 3; ++count) {
            this.index[count] = -1;
        }
        for (int c = 0; c < 3; ++c) {
            for (int d = 0; d < 2; ++d) {
                this.linesX[c][d] = 0.0;
                this.linesY[c][d] = 0.0;
            }
        }
    }
}

