/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class ABlockPair20 {
    protected Color m_weight_color = new Color(51, 153, 102);
    protected Color m_tens_color = new Color(0, 204, 255);
    protected Color m_norm_color = new Color(255, 204, 0);
    final int NORMAL = 0;
    final int MOUSE_OVER = 1;
    final int PRESSED = 2;
    final int DISABLED = 3;
    final int STILL = 0;
    final int MOTION = 1;
    final int GROUND = 2;
    protected int m_regime = 0;
    protected ASim20 m_applet;
    protected ABlock20[] m_block = new ABlock20[2];
    protected double m_time = 0.0;
    protected double m_acceleration = 0.0;
    protected double m_tension1;
    protected double m_tension2;
    protected double m_normal1;
    protected double m_normal2;
    protected double m_mg1;
    protected double m_mg2;
    protected double m_coef = 300.0;
    protected int m_original_y = 210;
    protected int m_ground_y = 326;
    protected boolean m_move = false;
    protected boolean m_latch1 = true;
    protected boolean m_latch2 = true;
    protected double m_aa;
    protected double m_mi;
    protected double m_nt;
    protected int[] m_arrowX = new int[3];
    protected int[] m_arrowY = new int[3];

    public ABlockPair20(ASim20 applet) {
        this.m_applet = applet;
        this.m_block[0] = new ABlock20(56, this.m_original_y, 60, this.m_ground_y, 4, Color.red);
        this.m_block[1] = new ABlock20(118, this.m_original_y, 60, this.m_ground_y, 5, Color.blue);
        this.setAcceleration();
    }

    public void paint(Graphics g) {
        this.m_block[0].paint(g);
        this.m_block[1].paint(g);
        this.paintRadius(g);
        if (this.m_block[0].getMass() > 0) {
            this.paintWeight(1, g, 354 - this.m_block[0].getSide() / 2, 201 - this.m_block[0].getSide() / 2, this.m_block[0].getSide(), this.m_weight_color);
            this.paintTension(1, g, 354 - this.m_block[0].getSide() / 2, 201 - this.m_block[0].getSide() / 2, this.m_block[0].getSide(), this.m_tens_color);
            this.paintNormal(1, g, 354 - this.m_block[0].getSide() / 2, 201 - this.m_block[0].getSide() / 2, this.m_block[0].getSide(), this.m_norm_color);
        }
        if (this.m_block[1].getMass() > 0) {
            this.paintWeight(2, g, 455 - this.m_block[1].getSide() / 2, 201 - this.m_block[1].getSide() / 2, this.m_block[1].getSide(), this.m_weight_color);
            this.paintTension(2, g, 455 - this.m_block[1].getSide() / 2, 201 - this.m_block[1].getSide() / 2, this.m_block[1].getSide(), this.m_tens_color);
            this.paintNormal(2, g, 455 - this.m_block[1].getSide() / 2, 201 - this.m_block[1].getSide() / 2, this.m_block[1].getSide(), this.m_norm_color);
        }
        this.paintStuff(g);
    }

    public void setBlockMass(int block, int mass) {
        this.m_block[block].setMass(mass);
        this.setAcceleration();
    }

    public void setAcceleration() {
        double g = 9.8;
        int M = ASim20.getPulleyMass();
        int m1 = this.m_block[0].getMass();
        int m2 = this.m_block[1].getMass();
        this.m_mg1 = (double)m1 * 9.8;
        this.m_mg2 = (double)m2 * 9.8;
        if (this.m_regime == 0) {
            this.m_acceleration = 0.0;
            if (m2 > m1) {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m2;
                this.m_normal1 = -(this.m_mg1 - this.m_tension2);
                this.m_normal2 = 0.0;
            } else {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m1;
                this.m_normal2 = -(this.m_mg2 - this.m_tension1);
                this.m_normal1 = 0.0;
            }
        }
        if (this.m_regime == 2) {
            this.m_acceleration = 0.0;
            if (m2 < m1) {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m2;
                this.m_normal1 = -(this.m_mg1 - this.m_tension2);
                this.m_normal2 = 0.0;
            } else {
                this.m_tension1 = this.m_tension2 = 9.8 * (double)m1;
                this.m_normal2 = -(this.m_mg2 - this.m_tension1);
                this.m_normal1 = 0.0;
            }
        }
        if (this.m_regime == 1) {
            this.m_acceleration = ((double)m2 * g - (double)m1 * g) / ((double)(m1 + m2) + 0.5 * (double)M);
            this.m_tension1 = (double)m1 * (9.8 + this.m_acceleration);
            this.m_tension2 = (double)m2 * (9.8 - this.m_acceleration);
            this.m_normal2 = 0.0;
            this.m_normal1 = 0.0;
        }
        this.m_aa = this.m_acceleration / 0.1;
        this.m_mi = 0.5 * (double)ASim20.getPulleyMass() * 0.1 * 0.1;
        this.m_nt = 0.5 * (double)ASim20.getPulleyMass() * 0.1 * this.m_acceleration;
    }

    public boolean positionBlocks() {
        if (this.m_regime == 2) {
            return false;
        }
        boolean result = true;
        if (!this.m_block[0].setY(this.m_original_y - (int)(this.m_acceleration * this.m_time * this.m_time * this.m_coef / (double)2))) {
            result = false;
        }
        if (!this.m_block[1].setY(this.m_original_y + (int)(this.m_acceleration * this.m_time * this.m_time * this.m_coef / (double)2))) {
            result = false;
        }
        return result;
    }

    public void move(boolean mode, double step) {
        if (!this.m_move) {
            return;
        }
        double old_time = this.m_time;
        if (mode) {
            this.m_time += step;
        } else {
            this.m_time -= step;
            if (this.m_time < 0.0) {
                this.m_time = 0.0;
                this.m_applet.setButton(3, 3);
                if (this.m_latch2) {
                    this.m_regime = 0;
                    this.setAcceleration();
                    this.m_applet.setButton(0, 0);
                    this.m_applet.setButton(4, 0);
                    this.m_latch2 = false;
                }
                return;
            }
        }
        if (!this.positionBlocks()) {
            this.m_time = old_time;
            this.m_applet.setButton(0, 3);
            this.m_applet.setButton(4, 3);
            if (this.m_latch1) {
                this.m_regime = 2;
                this.setAcceleration();
                this.m_applet.setButton(3, 0);
                this.m_latch1 = false;
            }
            return;
        }
        this.m_latch1 = true;
        this.m_latch2 = true;
    }

    public void start() {
        this.m_move = true;
        this.m_regime = 1;
        this.setAcceleration();
    }

    public void stop() {
        this.m_move = false;
        this.setAcceleration();
    }

    public void toggle() {
        if (this.m_move) {
            this.stop();
        } else {
            this.start();
        }
    }

    public boolean isMoving() {
        return this.m_move;
    }

    protected void paintRadius(Graphics g) {
        g.setColor(Color.black);
        int y1 = this.m_block[0].getY();
        int y2 = this.m_block[1].getY();
        int y = y1 > y2 ? y1 - this.m_original_y : y2 - this.m_original_y;
        double d = 61.0;
        double angle = y2 > y1 ? 0.5235987755982988 - (double)(2 * y) / d : 0.5235987755982988 + (double)(2 * y) / d;
        int X = (int)((double)88 + d / (double)2 * Math.cos(angle));
        int Y = (int)((double)57 - d / (double)2 * Math.sin(angle));
        g.drawLine(88, 57, X, Y);
    }

    protected void paintTension(int which, Graphics g, int x, int y, int s_width, Color color) {
        double m_tension = which == 1 ? this.m_tension1 : this.m_tension2;
        g.setColor(color);
        int length = (int)m_tension;
        g.fillRect(x + s_width / 2 - 2, y + s_width / 2 - length, 4, length);
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        this.m_arrowY[0] = y + s_width / 2 - length;
        this.m_arrowY[1] = y + s_width / 2 - length;
        this.m_arrowY[2] = y + s_width / 2 - length - 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(Color.white);
        g.fillOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(Color.black);
        g.drawOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
    }

    public void paintWeight(int which, Graphics g, int x, int y, int s_width, Color color) {
        g.setColor(color);
        double m_mass = which == 1 ? this.m_mg1 : this.m_mg2;
        int length = (int)m_mass;
        g.fillRect(x + s_width / 2 - 2, y + s_width / 2, 4, length);
        this.m_arrowX[0] = x + s_width / 2 - 6;
        this.m_arrowX[1] = x + s_width / 2 + 6;
        this.m_arrowX[2] = x + s_width / 2;
        this.m_arrowY[0] = y + s_width / 2 + length;
        this.m_arrowY[1] = y + s_width / 2 + length;
        this.m_arrowY[2] = y + s_width / 2 + length + 10;
        g.fillPolygon(this.m_arrowX, this.m_arrowY, 3);
        g.setColor(Color.white);
        g.fillOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
        g.setColor(Color.black);
        g.drawOval(x + s_width / 2 - 2, y + s_width / 2 - 2, 4, 4);
    }

    public double getAcceleration() {
        return this.m_acceleration;
    }

    public void paintNormal(int which, Graphics g, int x, int y, int s_width, Color color) {
        if (which == 1) {
            if (this.m_normal1 > 0.0) {
                double old = this.m_mg1;
                this.m_mg1 = this.m_normal1;
                this.paintWeight(which, g, x, y, s_width, color);
                this.m_mg1 = old;
                if (this.m_mg1 < this.m_normal1) {
                    this.paintWeight(which, g, x, y, s_width, this.m_weight_color);
                }
            } else if (this.m_normal1 < 0.0) {
                double old = this.m_tension1;
                this.m_tension1 = -this.m_normal1;
                this.paintTension(which, g, x, y, s_width, color);
                this.m_tension1 = old;
                if (this.m_tension1 < Math.abs(this.m_normal1)) {
                    this.paintTension(which, g, x, y, s_width, this.m_tens_color);
                }
            }
        } else if (this.m_normal2 > 0.0) {
            double old = this.m_mg2;
            this.m_mg2 = this.m_normal2;
            this.paintWeight(which, g, x, y, s_width, color);
            this.m_mg2 = old;
            if (this.m_mg2 < this.m_normal2) {
                this.paintWeight(which, g, x, y, s_width, this.m_weight_color);
            }
        } else if (this.m_normal2 < 0.0) {
            double old = this.m_tension2;
            this.m_tension2 = -this.m_normal2;
            this.paintTension(which, g, x, y, s_width, color);
            this.m_tension2 = old;
            if (this.m_tension2 < Math.abs(this.m_normal2)) {
                this.paintTension(which, g, x, y, s_width, this.m_tens_color);
            }
        }
    }

    public void paintStuff(Graphics g) {
        int mass2 = this.m_block[1].getMass();
        g.setColor(Color.black);
        g.drawString(ASim20.cutDouble(String.valueOf(this.m_acceleration)), 416, 41);
        g.drawString(ASim20.cutDouble(String.valueOf(this.m_tension1)), 235, 100);
        g.drawString(ASim20.cutDouble(String.valueOf(this.m_mg1)), 235, 121);
        if (this.m_normal1 != 0.0) {
            g.drawString(ASim20.cutDouble(String.valueOf(Math.abs(this.m_normal1))), 235, 144);
        } else {
            g.drawString("n/a", 235, 144);
        }
        if (mass2 != 0) {
            g.drawString(ASim20.cutDouble(String.valueOf(this.m_tension2)), 235, 178);
            g.drawString(ASim20.cutDouble(String.valueOf(this.m_mg2)), 235, 201);
        } else {
            g.drawString("n/a", 235, 178);
            g.drawString("n/a", 235, 201);
        }
        if (this.m_normal2 != 0.0 && mass2 != 0) {
            g.drawString(ASim20.cutDouble(String.valueOf(Math.abs(this.m_normal2))), 235, 224);
        } else {
            g.drawString("n/a", 235, 224);
        }
        if (ASim20.getPulleyMass() == 0) {
            g.setColor(Color.white);
            g.fillRect(147, 240, 190, 79);
        } else {
            g.drawString(ASim20.cutDouble(String.valueOf(this.m_aa)), 268, 275);
            g.drawString(ASim20.cutDouble(String.valueOf(this.m_mi)), 262, 292);
            g.drawString(ASim20.cutDouble(String.valueOf(this.m_nt)), 252, 310);
        }
    }

    public int getBlockMass(int block) {
        if (block == 1) {
            return this.m_block[0].getMass();
        }
        return this.m_block[1].getMass();
    }
}

