/*
 * Decompiled with CFR 0.152.
 */
import com.maris.awt.NumericField;
import com.maris.awt.Slider;
import com.maris.awt.advImageButton;
import com.maris.awt.zImageButton;
import com.maris.util.MMath;
import com.maris.util.Primitive;
import com.maris.util.zITimerListener;
import com.maris.util.zTimer;
import com.maris.util.zUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.net.URL;

public class Sim5
extends Applet
implements Runnable,
zITimerListener {
    protected Color m_stringColor = null;
    protected Thread m_loadData = null;
    protected Graphics m_gr = null;
    private Graphics backGC = null;
    private Image backBuffer = null;
    protected int m_loadProgress = 0;
    private Image m_bgImage = null;
    private Image m_sliderImage = null;
    private Image m_planetImage = null;
    private Image m_satelliteImage = null;
    private Image m_startImage = null;
    private Image m_initImage = null;
    private Image m_pauseImage = null;
    private Image m_fwImage = null;
    private Image m_bwImage = null;
    private Image m_kepler2lawImage = null;
    private Image m_kepler2law2Image = null;
    private zImageButton m_Start = null;
    private zImageButton m_Init = null;
    private zImageButton m_Pause = null;
    private zImageButton m_Kepler2law = null;
    private zImageButton m_Kepler2law2 = null;
    private advImageButton m_fw = null;
    private advImageButton m_bw = null;
    private Slider m_sdVel = null;
    private Slider m_sdDist = null;
    private Slider m_sdMass = null;
    private NumericField m_tfVel = null;
    private NumericField m_tfDist = null;
    private NumericField m_tfMass = null;
    private static final double minSatelliteMass = 5.0;
    private static final double maxSatellitelMass = 100.0;
    private static final int minSatelliteSize = 8;
    private static final int maxSatelliteSize = 16;
    private boolean m_isRun = false;
    private zTimer timer = null;
    private int appWidth;
    private int appHeight;
    private Font font12 = null;
    private Font font10 = null;
    private static final Rectangle graphRect = new Rectangle(34, 4, 258, 258);
    private Graphics graphGC = null;
    private Image graphBuffer = null;
    private static final double factor = 1.5;
    private static final double G = 1.0;
    private static final double planetMass = 10000.0;
    private static final int xCenter = 160;
    private static final int yCenter = 132;
    private static final double deltat = 0.05;
    private double m_vel = 8.0;
    private double m_dist = 80.0;
    private double m_mass = 50.0;
    private int satelliteRadius = Sim5.SatelliteRadius(this.m_mass);
    private int planetRadius;
    private double m_currTime = 0.0;
    private double m_currVelX;
    private double m_currVelY;
    private double m_currX;
    private double m_currY;
    private double m_currSpeed;
    private double m_currForce;
    private int m_satX;
    private int m_satY;
    private Polygon m_keplerPol = new Polygon(new int[3], new int[3], 3);
    private double m_keplerTimeOn = -1.0;
    private double m_keplerTimeOff = -1.0;
    private String m_mediaBase = null;

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdVel.mouseMove(n, n2);
            this.m_sdDist.mouseMove(n, n2);
            this.m_sdMass.mouseMove(n, n2);
            Container container = this.getParent();
            if (container instanceof Frame) {
                if (this.IsChangeCursor(this.m_sdVel, n, n2) || this.IsChangeCursor(this.m_sdDist, n, n2) || this.IsChangeCursor(this.m_sdMass, n, n2) || this.IsChangeCursor(this.m_Start, n, n2) || this.IsChangeCursor(this.m_Init, n, n2) || this.IsChangeCursor(this.m_Pause, n, n2) || this.IsChangeCursor(this.m_Kepler2law, n, n2) || this.IsChangeCursor((zImageButton)this.m_bw, n, n2) || this.IsChangeCursor((zImageButton)this.m_fw, n, n2)) {
                    ((Frame)container).setCursor(12);
                } else {
                    ((Frame)container).setCursor(0);
                }
            }
        }
        return true;
    }

    private synchronized void newBackBuffer() {
        this.backBuffer = this.getParent().createImage(this.appWidth, this.appHeight);
        if (zUtil.sysIsMacOS() && zUtil.sysIsNetscape()) {
            this.font12 = new Font("Arial", 0, 11);
            this.font10 = new Font("Arial", 0, 9);
        } else {
            this.font12 = new Font("Arial", 0, 12);
            this.font10 = new Font("Arial", 0, 10);
        }
        if (this.backBuffer != null) {
            this.backGC = this.backBuffer.getGraphics();
            return;
        }
        this.backGC = this.getGraphics();
    }

    private static int SatelliteRadius(double d) {
        return (int)(8.0 + 8.0 * ((d - 5.0) / 95.0)) >>> 1;
    }

    public void paint(Graphics graphics) {
        if (this.backBuffer != null) {
            if (!this.m_isRun && this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.backGC.drawImage(this.m_bgImage, 0, 0, this);
            int n = (int)Math.round(this.m_currX * 1.5);
            int n2 = (int)Math.round(this.m_currY * 1.5);
            int n3 = 160 + n;
            int n4 = 132 - n2;
            if (this.m_currTime <= this.m_keplerTimeOff) {
                this.m_keplerPol.xpoints[1] = this.m_keplerPol.xpoints[2];
                this.m_keplerPol.ypoints[1] = this.m_keplerPol.ypoints[2];
                this.m_keplerPol.xpoints[2] = n3 - Sim5.graphRect.x;
                this.m_keplerPol.ypoints[2] = n4 - Sim5.graphRect.y;
                if (this.m_currTime >= this.m_keplerTimeOn) {
                    this.graphGC.setColor(Color.gray.brighter());
                    this.graphGC.fillPolygon(this.m_keplerPol);
                }
            } else if (this.m_Kepler2law2.isVisible()) {
                this.m_keplerTimeOn = this.m_keplerTimeOff + 0.5;
                this.m_keplerTimeOff = this.m_keplerTimeOn + 1.0;
            }
            if (this.m_currTime > 0.0) {
                this.graphGC.setColor(Color.black);
                this.graphGC.drawLine(this.m_satX - Sim5.graphRect.x, this.m_satY - Sim5.graphRect.y, n3 - Sim5.graphRect.x, n4 - Sim5.graphRect.y);
            }
            this.m_satX = n3;
            this.m_satY = n4;
            this.backGC.drawImage(this.graphBuffer, Sim5.graphRect.x, Sim5.graphRect.y, this);
            this.backGC.drawImage(this.m_planetImage, 160 - this.planetRadius, 132 - this.planetRadius, this);
            int n5 = this.satelliteRadius << 1;
            this.backGC.drawImage(this.m_satelliteImage, n3 - this.satelliteRadius, n4 - this.satelliteRadius, n5, n5, this);
            this.backGC.setFont(this.font12);
            this.backGC.setColor(this.m_stringColor);
            this.backGC.drawString(zUtil.formatDouble((double)MMath.round((double)this.m_currTime, (int)2), (int)2), 450, 38);
            this.backGC.drawString(zUtil.formatDouble((double)this.m_currSpeed, (int)2), 450, 72);
            this.backGC.setColor(Color.red);
            int n6 = n3 + (int)Math.round(this.m_currVelX * 3.0);
            int n7 = n4 - (int)Math.round(this.m_currVelY * 3.0);
            this.backGC.drawString("V", n6 - 10, n7 + 4);
            Primitive.vectorDraw((Graphics)this.backGC, (Point)new Point(n3, n4), (Point)new Point(n6, n7), (Dimension)new Dimension(10, 6), (int)7);
            this.backGC.setColor(Color.blue);
            double d = (this.m_dist - this.m_currForce * 0.25) / this.m_dist;
            int n8 = 160 + (int)Math.round(d * (double)n);
            int n9 = 132 - (int)Math.round(d * (double)n2);
            this.backGC.drawString("F", n8 - 10, n9 + 4);
            Primitive.vectorDraw((Graphics)this.backGC, (Point)new Point(160 + n, 132 - n2), (Point)new Point(n8, n9), (Dimension)new Dimension(10, 6), (int)7);
            this.backGC.setColor(Color.black);
            this.backGC.drawString("arbitrary units", 11, 19);
            this.m_sdVel.draw(this.backGC);
            this.m_sdDist.draw(this.backGC);
            this.m_sdMass.draw(this.backGC);
            graphics.drawImage(this.backBuffer, 0, 0, this);
            return;
        }
        graphics.setColor(this.m_stringColor);
        String string = "Loading media";
        int n = 0;
        while (n < this.m_loadProgress) {
            string = string + " .";
            ++n;
        }
        graphics.drawRect(0, 0, this.appWidth - 1, this.appHeight - 1);
        graphics.drawString(string, 20, 20);
    }

    protected boolean IsChangeCursor(zImageButton zImageButton2, int n, int n2) {
        Point point = zImageButton2.location();
        return zImageButton2.isEnabled() && zImageButton2.inside(n - point.x, n2 - point.y);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return this.mouseMove(event, n, n2);
    }

    protected boolean IsChangeCursor(Slider slider, int n, int n2) {
        return slider.isEnabled() && slider.inside(n, n2);
    }

    public void destroy() {
        this.removeAll();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.m_loadData = null;
        this.backGC = null;
        this.backBuffer = null;
        this.graphBuffer = null;
        this.graphGC = null;
        this.m_bgImage = null;
        this.m_sliderImage = null;
        this.m_planetImage = null;
        this.m_satelliteImage = null;
        this.m_startImage = null;
        this.m_initImage = null;
        this.m_pauseImage = null;
        this.m_fwImage = null;
        this.m_bwImage = null;
        this.m_kepler2lawImage = null;
        this.m_kepler2law2Image = null;
        this.m_Kepler2law = null;
        this.m_Kepler2law2 = null;
        this.m_Start = null;
        this.m_Pause = null;
        this.m_Init = null;
        this.m_fw = null;
        this.m_bw = null;
        this.m_sdVel = null;
        this.m_sdDist = null;
        this.m_sdMass = null;
        this.m_tfVel = null;
        this.m_tfDist = null;
        this.m_tfMass = null;
    }

    protected void InitData() {
        this.m_currTime = 0.0;
        this.m_currX = this.m_dist;
        this.m_currY = 0.0;
        this.m_currVelX = 0.0;
        this.m_currVelY = this.m_vel;
        double d = Math.sqrt(this.m_currX * this.m_currX + this.m_currY * this.m_currY);
        this.m_currForce = 1.0 * (10000.0 * this.m_mass) / (d * d);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void Forward() {
        if (!this.isLimitEnd()) {
            this.m_currTime += 0.05;
            double d = Math.sqrt(this.m_currX * this.m_currX + this.m_currY * this.m_currY);
            this.m_currForce = 1.0 * (10000.0 * this.m_mass) / (d * d);
            double d2 = -this.m_currForce * this.m_currX / (this.m_mass * d);
            double d3 = -this.m_currForce * this.m_currY / (this.m_mass * d);
            this.m_currVelX += d2 * 0.05;
            this.m_currVelY += d3 * 0.05;
            this.m_currX += this.m_currVelX * 0.05;
            this.m_currY += this.m_currVelY * 0.05;
            this.m_currSpeed = Math.sqrt(this.m_currVelX * this.m_currVelX + this.m_currVelY * this.m_currVelY);
        }
    }

    private synchronized void newGraphBuffer() {
        this.graphBuffer = this.getParent().createImage(Sim5.graphRect.width, Sim5.graphRect.height);
        this.graphGC = this.graphBuffer != null ? this.graphBuffer.getGraphics() : this.getGraphics();
        this.EraseGraphBuffer();
    }

    public void Backward() {
        if (!this.isLimitStart()) {
            this.m_currTime -= 0.05;
            this.m_currX -= this.m_currVelX * 0.05;
            this.m_currY -= this.m_currVelY * 0.05;
            double d = Math.sqrt(this.m_currX * this.m_currX + this.m_currY * this.m_currY);
            this.m_currForce = 1.0 * (10000.0 * this.m_mass) / (d * d);
            double d2 = -this.m_currForce * this.m_currX / (this.m_mass * d);
            double d3 = -this.m_currForce * this.m_currY / (this.m_mass * d);
            this.m_currVelX -= d2 * 0.05;
            this.m_currVelY -= d3 * 0.05;
            this.m_currSpeed = Math.sqrt(this.m_currVelX * this.m_currVelX + this.m_currVelY * this.m_currVelY);
        }
    }

    public void timerAction(zTimer zTimer2) {
        this.Forward();
        if (!this.isLimitEnd()) {
            this.repaint();
            return;
        }
        this.action(null, this.m_Pause);
    }

    public boolean action(Event event, Object object) {
        if (this.m_Start == object) {
            this.UpdateTextFields();
            this.m_sdVel.disable();
            this.m_sdDist.disable();
            this.m_sdMass.disable();
            this.m_tfVel.disable();
            this.m_tfDist.disable();
            this.m_tfMass.disable();
            this.m_Start.disable();
            this.m_Pause.enable();
            this.m_bw.disable();
            this.m_fw.disable();
            this.m_isRun = true;
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = new zTimer((zITimerListener)this, 50L);
            this.timer.start();
        } else if (this.m_Init == object) {
            this.m_isRun = false;
            if (this.timer != null) {
                this.timer.stop();
            }
            this.EraseGraphBuffer();
            this.InitData();
            this.m_sdVel.enable();
            this.m_sdDist.enable();
            this.m_sdMass.enable();
            this.m_tfVel.enable();
            this.m_tfDist.enable();
            this.m_tfMass.enable();
            this.m_Start.enable();
            this.m_Pause.disable();
            this.m_bw.disable();
            this.m_fw.enable();
            this.setKeplerTime();
            this.repaint();
        } else if (this.m_Pause == object) {
            this.m_isRun = false;
            this.m_Pause.disable();
            this.m_bw.enable();
            if (!this.isLimitEnd()) {
                this.m_Start.enable();
                this.m_fw.enable();
            }
            this.repaint();
        } else if (this.m_fw == object) {
            this.UpdateTextFields();
            this.Forward();
            this.m_bw.enable();
            if (this.isLimitEnd()) {
                this.m_Start.disable();
                this.m_fw.disable();
                this.m_fw.stop();
            }
            this.m_sdVel.disable();
            this.m_sdDist.disable();
            this.m_sdMass.disable();
            this.m_tfVel.disable();
            this.m_tfDist.disable();
            this.m_tfMass.disable();
            this.repaint();
        } else if (this.m_bw == object) {
            this.UpdateTextFields();
            this.Backward();
            this.m_Start.enable();
            this.m_fw.enable();
            if (this.isLimitStart()) {
                this.m_bw.disable();
                this.m_bw.stop();
            }
            this.m_sdVel.disable();
            this.m_sdDist.disable();
            this.m_sdMass.disable();
            this.m_tfVel.disable();
            this.m_tfDist.disable();
            this.m_tfMass.disable();
            this.repaint();
        } else if (this.m_Kepler2law == object) {
            this.m_Kepler2law2.show(true);
            this.m_Kepler2law.show(false);
            this.setKeplerTime();
            this.repaint();
        } else if (this.m_Kepler2law2 == object) {
            this.m_Kepler2law.show(true);
            this.m_Kepler2law2.show(false);
            this.setKeplerTime();
            this.repaint();
        } else if (this.m_sdVel == object) {
            this.m_vel = ((Slider)object).getAbsolutPosition();
            this.m_tfVel.setValue(this.m_vel);
            this.InitData();
            this.repaint();
        } else if (this.m_sdDist == object) {
            this.m_dist = ((Slider)object).getAbsolutPosition();
            this.m_tfDist.setValue(this.m_dist);
            this.InitData();
            this.repaint();
        } else if (this.m_sdMass == object) {
            this.m_mass = ((Slider)object).getAbsolutPosition();
            this.m_tfMass.setValue(this.m_mass);
            this.satelliteRadius = Sim5.SatelliteRadius(this.m_mass);
            this.InitData();
            this.repaint();
        } else if (this.m_tfMass == object) {
            this.m_mass = this.m_tfMass.getValue();
            this.m_sdMass.setAbsolutPosition(this.m_mass);
            this.InitData();
            this.repaint();
        } else if (this.m_tfVel == object) {
            this.m_vel = this.m_tfVel.getValue();
            this.m_sdVel.setAbsolutPosition(this.m_vel);
            this.InitData();
            this.repaint();
        } else if (this.m_tfDist == object) {
            this.m_dist = this.m_tfDist.getValue();
            this.m_sdDist.setAbsolutPosition(this.m_dist);
            this.InitData();
            this.repaint();
        }
        return true;
    }

    private synchronized void EraseGraphBuffer() {
        this.graphGC.setColor(Color.white);
        this.graphGC.fillRect(0, 0, Sim5.graphRect.width, Sim5.graphRect.height);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdVel.mouseDown(n, n2);
            this.m_sdDist.mouseDown(n, n2);
            this.m_sdMass.mouseDown(n, n2);
        }
        return true;
    }

    private void UpdateTextFields() {
        if (!(this.m_tfMass.isUpdateValue() && this.m_tfVel.isUpdateValue() && this.m_tfDist.isUpdateValue())) {
            this.m_mass = this.m_tfMass.UpdateValue();
            this.m_vel = this.m_tfVel.UpdateValue();
            this.m_dist = this.m_tfDist.UpdateValue();
            this.m_sdMass.setAbsolutPosition(this.m_mass);
            this.m_sdVel.setAbsolutPosition(this.m_vel);
            this.m_sdDist.setAbsolutPosition(this.m_dist);
            this.satelliteRadius = Sim5.SatelliteRadius(this.m_mass);
            this.InitData();
        }
    }

    public void run() {
        this.m_loadProgress = 0;
        this.m_bgImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file1")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_planetImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file2")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.planetRadius = this.m_planetImage.getWidth(this) >>> 1;
        this.m_satelliteImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file3")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_sliderImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file4")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_startImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file5")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_initImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file6")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_pauseImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file7")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_fwImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file8")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_bwImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file9")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_kepler2lawImage = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file10")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_kepler2law2Image = zUtil.loadImage((Component)this, (URL)this.getCodeBase(), (String)(this.m_mediaBase + this.getParameter("file11")));
        ++this.m_loadProgress;
        if (this.m_gr != null) {
            this.repaint();
        }
        this.m_Start = new zImageButton(this.m_startImage);
        this.add((Component)this.m_Start);
        this.m_Start.reshape(7, 268, this.m_startImage.getWidth(this), this.m_startImage.getHeight(this) >>> 2);
        this.m_Start.hide();
        this.m_Pause = new zImageButton(this.m_pauseImage);
        this.add((Component)this.m_Pause);
        this.m_Pause.reshape(106, 268, this.m_pauseImage.getWidth(this), this.m_pauseImage.getHeight(this) >>> 2);
        this.m_Pause.hide();
        this.m_Init = new zImageButton(this.m_initImage);
        this.add((Component)this.m_Init);
        this.m_Init.reshape(205, 268, this.m_initImage.getWidth(this), this.m_initImage.getHeight(this) >>> 2);
        this.m_Init.hide();
        this.m_bw = new advImageButton(this.m_bwImage, 500L, 50L);
        this.add((Component)this.m_bw);
        this.m_bw.reshape(304, 268, this.m_bwImage.getWidth(this), this.m_bwImage.getHeight(this) >>> 2);
        this.m_bw.hide();
        this.m_fw = new advImageButton(this.m_fwImage, 500L, 50L);
        this.add((Component)this.m_fw);
        this.m_fw.reshape(403, 268, this.m_fwImage.getWidth(this), this.m_fwImage.getHeight(this) >>> 2);
        this.m_fw.hide();
        this.m_Kepler2law = new zImageButton(this.m_kepler2lawImage);
        this.add((Component)this.m_Kepler2law);
        this.m_Kepler2law.reshape(368, 108, this.m_kepler2lawImage.getWidth(this), this.m_kepler2lawImage.getHeight(this) >>> 2);
        this.m_Kepler2law.hide();
        this.m_Kepler2law2 = new zImageButton(this.m_kepler2law2Image);
        this.add((Component)this.m_Kepler2law2);
        this.m_Kepler2law2.reshape(368, 108, this.m_kepler2law2Image.getWidth(this), this.m_kepler2law2Image.getHeight(this) >>> 2);
        this.m_Kepler2law2.hide();
        this.m_sdVel = new Slider(this.m_sliderImage, 346, 177, 495, 177, 32L, 8.0, 11.2, (Container)this);
        this.m_sdVel.setAbsolutPosition(8.0);
        this.m_sdVel.show();
        this.m_sdDist = new Slider(this.m_sliderImage, 346, 217, 495, 217, 20L, 60.0, 80.0, (Container)this);
        this.m_sdDist.setAbsolutPosition(80.0);
        this.m_sdDist.show();
        this.m_sdMass = new Slider(this.m_sliderImage, 346, 257, 495, 257, 19L, 5.0, 100.0, (Container)this);
        this.m_sdMass.setAbsolutPosition(50.0);
        this.m_sdMass.show();
        this.m_tfVel = new NumericField(4, 8.0, 11.2, (Container)this);
        this.m_tfVel.hide();
        this.add((Component)this.m_tfVel);
        this.m_tfVel.reshape(438, 154, 35, 17);
        this.m_tfVel.setValue(this.m_vel);
        this.m_tfVel.setFont(this.font12);
        this.m_tfDist = new NumericField(4, 60.0, 80.0, (Container)this);
        this.m_tfDist.hide();
        this.add((Component)this.m_tfDist);
        this.m_tfDist.reshape(438, 194, 35, 17);
        this.m_tfDist.setValue(this.m_dist);
        this.m_tfDist.setFont(this.font12);
        this.m_tfMass = new NumericField(4, 5.0, 100.0, (Container)this);
        this.m_tfMass.hide();
        this.add((Component)this.m_tfMass);
        this.m_tfMass.reshape(438, 234, 35, 17);
        this.m_tfMass.setValue(this.m_mass);
        this.m_tfMass.setFont(this.font12);
        this.InitData();
        this.newBackBuffer();
        this.newGraphBuffer();
        if (zUtil.sysIsMacOS()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.repaint();
        this.m_tfVel.show();
        this.m_tfDist.show();
        this.m_tfMass.show();
        this.m_Start.show();
        this.m_Init.show();
        this.m_Pause.show();
        this.m_Pause.disable();
        this.m_fw.show();
        this.m_bw.show();
        this.m_bw.disable();
        this.m_Kepler2law.show();
    }

    public void init() {
        Color color;
        this.m_keplerPol.xpoints[0] = 160 - Sim5.graphRect.x;
        this.m_keplerPol.ypoints[0] = 132 - Sim5.graphRect.y;
        this.setLayout(null);
        this.appHeight = this.size().height;
        this.appWidth = this.size().width;
        this.m_gr = this.getGraphics();
        String string = this.getParameter("background");
        if (string != null && (color = zUtil.parseHTMLColor((String)string)) != null) {
            this.setBackground(color);
            this.m_stringColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        this.m_mediaBase = this.getParameter("mediabase");
        if (this.m_mediaBase == null) {
            this.m_mediaBase = "";
        }
        this.m_loadData = new Thread(this);
        this.m_loadData.start();
    }

    protected boolean isLimitEnd() {
        return (double)((float)this.m_currTime) > 12.0 && this.m_currX > 0.0 && this.m_currY > 0.0;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.backBuffer != null) {
            this.m_sdVel.mouseDrag(n, n2);
            this.m_sdDist.mouseDrag(n, n2);
            this.m_sdMass.mouseDrag(n, n2);
        }
        return true;
    }

    protected boolean isLimitStart() {
        return (double)((float)this.m_currTime) <= 0.0;
    }

    private void setKeplerTime() {
        if (this.m_Kepler2law2.isVisible()) {
            this.m_keplerTimeOn = (int)this.m_currTime + 1;
            this.m_keplerTimeOff = this.m_keplerTimeOn + 1.0;
            return;
        }
        if (MMath.isZero((double)this.m_currTime)) {
            this.m_keplerTimeOff = -1.0;
            this.m_keplerTimeOn = -1.0;
        }
    }
}

