/*
 * Decompiled with CFR 0.152.
 */
import com.maris.ACommon.ASlider;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ASim30
extends Applet
implements Runnable {
    protected Thread m_thread = null;
    protected Graphics m_offscreen_graphics = null;
    protected Image m_offscreen_image = null;
    protected int m_width;
    protected int m_height;
    protected MediaTracker m_tracker;
    protected Image m_bkImage = null;
    protected Image m_sliderImage = null;
    protected ASlider m_slider1;
    protected ASlider m_slider2;
    protected ASlider m_slider3;
    int charge1 = 2;
    int charge2 = 0;
    int charge3 = 0;
    int xTest;
    int yTest;
    int x1;
    int x;
    int y1;
    int y;
    int numLines1;
    int numLines2;
    int numLines3;
    double Q1;
    double Q2;
    double Q3;
    double pi;
    double R1;
    double R2inner;
    double R2outer;
    double R3;
    double E;
    double rSq;
    double r;

    public void init() {
        this.m_width = this.size().width;
        this.m_height = this.size().height;
        this.m_offscreen_image = this.createImage(this.m_width, this.m_height);
        this.m_tracker = new MediaTracker(this);
        if (this.m_offscreen_image == null) {
            System.out.println("Couldn't create offscreen graphics, exiting...");
            System.exit(-1);
        }
        this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        String m_mediaBase = this.getParameter("mediabase");
        if (m_mediaBase == null) {
            m_mediaBase = "";
        }
        this.m_bkImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file1"))));
        if (this.m_bkImage == null) {
            System.out.println("Couldn't find background image, exiting...");
            System.exit(-1);
        }
        this.m_sliderImage = this.getImage(this.getCodeBase(), String.valueOf(m_mediaBase).concat(String.valueOf(this.getParameter("file2"))));
        if (this.m_sliderImage == null) {
            System.out.println("Couldn't find slider image, exiting...");
            System.exit(-1);
        }
        this.m_tracker.addImage(this.m_bkImage, 0);
        this.m_tracker.addImage(this.m_sliderImage, 1);
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_slider1 = new ASlider(this.m_sliderImage, 4, 286, 149, 12, -4, 4, 2);
        this.m_slider2 = new ASlider(this.m_sliderImage, 172, 286, 149, 12, -4, 4, 0);
        this.m_slider3 = new ASlider(this.m_sliderImage, 340, 286, 149, 12, -4, 4, 0);
    }

    public void run() {
        this.pi = 3.141592654;
        this.xTest = -1;
        this.yTest = -1;
        this.R1 = 20.0;
        this.R2inner = 40.0;
        this.R2outer = 50.0;
        this.R3 = 4.0;
        this.x1 = 250;
        this.y1 = 120;
        while (this.m_thread == Thread.currentThread()) {
            this.Q1 = (double)this.charge1 * 1.0E-6;
            this.Q2 = (double)this.charge2 * 1.0E-6;
            this.Q3 = (double)this.charge3 * 1.0E-6;
            this.numLines1 = Math.abs(4 * (this.charge1 + this.charge3));
            this.numLines2 = Math.abs(4 * (this.charge2 + this.charge1 + this.charge3));
            this.numLines3 = Math.abs(4 * this.charge3);
            if (this.xTest > -1 && this.yTest > -1) {
                this.x = this.xTest - this.x1;
                this.y = this.y1 - this.yTest;
                this.rSq = this.x * this.x + this.y * this.y;
                this.r = Math.sqrt(this.rSq);
                this.E = this.r < this.R1 ? (this.charge3 != 0 && this.r > 0.0 ? 8.99E13 * this.Q3 / this.rSq : 0.0) : (this.r < this.R2outer ? (this.charge2 != 0 && this.r > this.R2inner ? 0.0 : 8.99E13 * (this.Q1 + this.Q3) / this.rSq) : (this.r > this.R2outer ? 8.99E13 * (this.Q1 + this.Q2 + this.Q3) / this.rSq : 0.0));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void update(Graphics g) {
        if (this.m_offscreen_graphics != null) {
            this.paint(this.m_offscreen_graphics);
            g.drawImage(this.m_offscreen_image, 0, 0, null);
        } else {
            System.out.println("Null graphics");
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.m_bkImage, 0, 0, null);
        this.paintSim(g);
        this.paintVector(g);
        this.m_slider1.paint(g);
        this.m_slider2.paint(g);
        this.m_slider3.paint(g);
        g.drawString(String.valueOf(this.m_slider1.getCurrentValue()), this.m_slider1.getX() + 4, 280);
        g.drawString(String.valueOf(this.m_slider2.getCurrentValue()), this.m_slider2.getX() + 4, 280);
        g.drawString(String.valueOf(this.m_slider3.getCurrentValue()), this.m_slider3.getX() + 4, 280);
    }

    public boolean mouseUp(Event event, int x, int y) {
        this.m_slider1.onMouseUp(x, y);
        this.m_slider2.onMouseUp(x, y);
        this.m_slider3.onMouseUp(x, y);
        return false;
    }

    public boolean mouseDown(Event event, int x, int y) {
        this.m_slider1.onMouseDown(x, y);
        this.m_slider2.onMouseDown(x, y);
        this.m_slider3.onMouseDown(x, y);
        return false;
    }

    public boolean mouseMove(Event event, int x, int y) {
        this.xTest = x;
        this.yTest = y;
        if (this.xTest < 150 || this.xTest > 350 || this.yTest < 20 || this.yTest <= 220) {
            // empty if block
        }
        this.m_slider1.onMouseMove(x, y);
        this.m_slider2.onMouseMove(x, y);
        this.m_slider3.onMouseMove(x, y);
        return false;
    }

    public boolean mouseDrag(Event event, int x, int y) {
        if (this.m_slider1.onMouseDrag(x, y)) {
            this.charge1 = this.m_slider1.getCurrentValue();
        }
        if (this.m_slider2.onMouseDrag(x, y)) {
            this.charge2 = this.m_slider2.getCurrentValue();
        }
        if (this.m_slider3.onMouseDrag(x, y)) {
            this.charge3 = this.m_slider3.getCurrentValue();
        }
        return false;
    }

    public static String cutDouble(String value) {
        int index = value.indexOf(".");
        if (index == -1) {
            return value;
        }
        if (value.length() > index + 2) {
            return value.substring(0, index + 3);
        }
        return value;
    }

    public void paintSim(Graphics g) {
        double tempAngle;
        int yMid;
        int xMid;
        double angle;
        int i;
        double endRadius;
        double startRadius;
        double arrowAngle = this.pi / 7.0;
        double arrowLength = 8.0;
        g.setColor(Color.green);
        if (this.charge2 != 0) {
            g.fillOval(this.x1 - (int)this.R2outer, this.y1 - (int)this.R2outer, 2 * (int)this.R2outer, 2 * (int)this.R2outer);
            g.setColor(Color.white);
            g.fillOval(this.x1 - (int)this.R2inner, this.y1 - (int)this.R2inner, 2 * (int)this.R2inner, 2 * (int)this.R2inner);
        }
        g.setColor(Color.blue);
        if (this.charge1 != 0) {
            g.drawOval(this.x1 - (int)this.R1, this.y1 - (int)this.R1, 2 * (int)this.R1, 2 * (int)this.R1);
        }
        g.setColor(Color.red);
        if (this.charge3 != 0) {
            g.fillOval(this.x1 - (int)this.R3, this.y1 - (int)this.R3, 2 * (int)this.R3, 2 * (int)this.R3);
            g.setColor(Color.white);
            if (this.charge3 > 0) {
                g.drawLine(this.x1 - 3, this.y1, this.x1 + 3, this.y1);
                g.drawLine(this.x1, this.y1 - 3, this.x1, this.y1 + 3);
            }
            if (this.charge3 < 0) {
                g.drawLine(this.x1 - 3, this.y1, this.x1 + 3, this.y1);
            }
        }
        g.setColor(Color.black);
        g.drawString(String.valueOf(String.valueOf("X = ").concat(String.valueOf(ASim30.cutDouble(String.valueOf(0.01 * (double)this.x))))).concat(String.valueOf(" m")), 24, 200);
        g.drawString(String.valueOf(String.valueOf("Y = ").concat(String.valueOf(ASim30.cutDouble(String.valueOf(0.01 * (double)this.y))))).concat(String.valueOf(" m")), 24, 215);
        g.drawString(String.valueOf(String.valueOf("E = ").concat(String.valueOf((int)this.E))).concat(String.valueOf(" N/C")), 24, 230);
        if (this.charge3 != 0) {
            startRadius = this.R3;
            endRadius = 100.0;
            if (this.charge2 != 0) {
                endRadius = this.R2inner;
            }
            if (this.charge1 != 0) {
                endRadius = this.R1;
            }
            for (i = 0; i < this.numLines3; ++i) {
                angle = (double)i * 2.0 * this.pi / (double)this.numLines3;
                g.drawLine(this.x1 + (int)(startRadius * Math.cos(angle)), this.y1 - (int)(startRadius * Math.sin(angle)), this.x1 + (int)(endRadius * Math.cos(angle)), this.y1 - (int)(endRadius * Math.sin(angle)));
                xMid = this.x1 + (int)(0.5 * (startRadius + endRadius) * Math.cos(angle));
                yMid = this.y1 - (int)(0.5 * (startRadius + endRadius) * Math.sin(angle));
                if (this.charge3 > 0) {
                    if (this.charge1 != 0) {
                        xMid = this.x1 + (int)(endRadius * Math.cos(angle));
                        yMid = this.y1 - (int)(endRadius * Math.sin(angle));
                    }
                    angle += this.pi;
                }
                tempAngle = angle + arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
                tempAngle = angle - arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
            }
        }
        if (this.charge1 != 0) {
            startRadius = this.R1;
            endRadius = 100.0;
            if (this.charge2 != 0) {
                endRadius = this.R2inner;
            }
            for (i = 0; i < this.numLines1; ++i) {
                angle = (double)i * 2.0 * this.pi / (double)this.numLines1;
                g.drawLine(this.x1 + (int)(startRadius * Math.cos(angle)), this.y1 - (int)(startRadius * Math.sin(angle)), this.x1 + (int)(endRadius * Math.cos(angle)), this.y1 - (int)(endRadius * Math.sin(angle)));
                xMid = this.x1 + (int)(0.5 * (startRadius + endRadius) * Math.cos(angle));
                yMid = this.y1 - (int)(0.5 * (startRadius + endRadius) * Math.sin(angle));
                if (this.charge1 + this.charge3 > 0) {
                    if (this.charge2 != 0) {
                        xMid = this.x1 + (int)(endRadius * Math.cos(angle));
                        yMid = this.y1 - (int)(endRadius * Math.sin(angle));
                    }
                    angle += this.pi;
                }
                tempAngle = angle + arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
                tempAngle = angle - arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
            }
        }
        if (this.charge2 != 0) {
            startRadius = this.R2outer;
            endRadius = 100.0;
            for (i = 0; i < this.numLines2; ++i) {
                angle = (double)i * 2.0 * this.pi / (double)this.numLines2;
                g.drawLine(this.x1 + (int)(startRadius * Math.cos(angle)), this.y1 - (int)(startRadius * Math.sin(angle)), this.x1 + (int)(endRadius * Math.cos(angle)), this.y1 - (int)(endRadius * Math.sin(angle)));
                xMid = this.x1 + (int)(0.5 * (startRadius + endRadius) * Math.cos(angle));
                yMid = this.y1 - (int)(0.5 * (startRadius + endRadius) * Math.sin(angle));
                if (this.charge1 + this.charge2 + this.charge3 > 0) {
                    angle += this.pi;
                }
                tempAngle = angle + arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
                tempAngle = angle - arrowAngle;
                g.drawLine(xMid, yMid, xMid + (int)(arrowLength * Math.cos(tempAngle)), yMid - (int)(arrowLength * Math.sin(tempAngle)));
            }
        }
    }

    public void paintVector(Graphics g) {
        if (this.xTest < 150 || this.xTest > 350 || this.yTest < 20 || this.yTest > 220) {
            return;
        }
        int cl = 20;
        int radius = 30;
        int arrow_length = 6;
        double arrow_angle = 0.5235987755982988;
        int X = this.xTest - this.x1;
        int Y = this.yTest - this.y1;
        double R = Math.sqrt(X * X + Y * Y);
        double cos = (double)X / R;
        double angle = Y <= 0 ? Math.acos(cos) : Math.PI * 2 - Math.acos(cos);
        g.setColor(Color.gray);
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xa = 0;
        int ya = 0;
        int xb = 0;
        int yb = 0;
        if (this.E > 0.0) {
            x1 = this.xTest - (int)((double)(radius / 2) * Math.cos(angle));
            y1 = this.yTest + (int)((double)(radius / 2) * Math.sin(angle));
            x2 = this.xTest + (int)((double)(radius / 2) * Math.cos(angle));
            y2 = this.yTest - (int)((double)(radius / 2) * Math.sin(angle));
            xa = x2 - (int)((double)arrow_length * Math.cos(angle - arrow_angle));
            ya = y2 + (int)((double)arrow_length * Math.sin(angle - arrow_angle));
            xb = x2 - (int)((double)arrow_length * Math.cos(angle + arrow_angle));
            yb = y2 + (int)((double)arrow_length * Math.sin(angle + arrow_angle));
        } else if (this.E < 0.0) {
            x1 = this.xTest + (int)((double)(radius / 2) * Math.cos(angle));
            y1 = this.yTest - (int)((double)(radius / 2) * Math.sin(angle));
            x2 = this.xTest - (int)((double)(radius / 2) * Math.cos(angle));
            y2 = this.yTest + (int)((double)(radius / 2) * Math.sin(angle));
            xa = x2 + (int)((double)arrow_length * Math.cos(angle - arrow_angle));
            ya = y2 - (int)((double)arrow_length * Math.sin(angle - arrow_angle));
            xb = x2 + (int)((double)arrow_length * Math.cos(angle + arrow_angle));
            yb = y2 - (int)((double)arrow_length * Math.sin(angle + arrow_angle));
        }
        if (this.E != 0.0) {
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x2, y2, xa, ya);
            g.drawLine(x2, y2, xb, yb);
        }
        g.setColor(Color.black);
    }
}

